/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol.giopmsgheaders;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.TargetAddress;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.TargetAddressHelper;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ObjectKeyCacheEntry;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Principal;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class RequestMessage_1_2
extends Message_1_2
implements RequestMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private TimingPoints tp;
    private byte response_flags = 0;
    private byte[] reserved = null;
    private TargetAddress target = null;
    private String operation = null;
    private ServiceContexts service_contexts = null;
    private ObjectKeyCacheEntry entry = null;

    RequestMessage_1_2(ORB orb) {
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.service_contexts = ServiceContextDefaults.makeServiceContexts(orb);
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
    }

    RequestMessage_1_2(ORB orb, int _request_id, byte _response_flags, byte[] _reserved, TargetAddress _target, String _operation, ServiceContexts _service_contexts) {
        super(1195986768, GIOPVersion.V1_2, (byte)0, (byte)0, 0);
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.request_id = _request_id;
        this.response_flags = _response_flags;
        this.reserved = _reserved;
        this.target = _target;
        this.operation = _operation;
        this.service_contexts = _service_contexts;
    }

    @Override
    public int getRequestId() {
        return this.request_id;
    }

    @Override
    public boolean isResponseExpected() {
        return (this.response_flags & 1) == 1;
    }

    @Override
    public byte[] getReserved() {
        return this.reserved;
    }

    @Override
    public ObjectKeyCacheEntry getObjectKeyCacheEntry() {
        if (this.entry == null) {
            this.entry = MessageBase.extractObjectKeyCacheEntry(this.target, this.orb);
        }
        return this.entry;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    @Override
    public void setServiceContexts(ServiceContexts sc) {
        this.service_contexts = sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(org.omg.CORBA.portable.InputStream istream) {
        this.tp.enter_giopHeaderReadRequest();
        try {
            super.read(istream);
            this.request_id = istream.read_ulong();
            this.response_flags = istream.read_octet();
            this.reserved = new byte[3];
            for (int _o0 = 0; _o0 < 3; ++_o0) {
                this.reserved[_o0] = istream.read_octet();
            }
            this.target = TargetAddressHelper.read(istream);
            this.getObjectKeyCacheEntry();
            this.operation = istream.read_string();
            this.service_contexts = ServiceContextDefaults.makeServiceContexts((InputStream)istream);
            ((CDRInputObject)istream).setHeaderPadding(true);
        }
        finally {
            this.tp.exit_giopHeaderReadRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(org.omg.CORBA.portable.OutputStream ostream) {
        this.tp.enter_giopHeaderWriteRequest();
        try {
            super.write(ostream);
            ostream.write_ulong(this.request_id);
            ostream.write_octet(this.response_flags);
            RequestMessage_1_2.nullCheck(this.reserved);
            if (this.reserved.length != 3) {
                throw this.wrapper.badReservedLength(CompletionStatus.COMPLETED_MAYBE);
            }
            for (int _i0 = 0; _i0 < 3; ++_i0) {
                ostream.write_octet(this.reserved[_i0]);
            }
            RequestMessage_1_2.nullCheck(this.target);
            TargetAddressHelper.write(ostream, this.target);
            ostream.write_string(this.operation);
            this.service_contexts.write((OutputStream)ostream, GIOPVersion.V1_2);
            ((CDROutputObject)ostream).setHeaderPadding(true);
        }
        finally {
            this.tp.exit_giopHeaderWriteRequest();
        }
    }

    @Override
    public void callback(MessageHandler handler) throws IOException {
        handler.handleInput(this);
    }
}

