/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.TemporarySelectorClosedException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.TemporarySelectorState;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public class TemporarySelectorStateClosed
implements TemporarySelectorState {
    private final boolean debug;

    private TemporarySelectorStateClosed() {
        this.debug = true;
    }

    public TemporarySelectorStateClosed(ORB theOrb) {
        ORB itsOrb = theOrb;
        this.debug = itsOrb.transportDebugFlag;
    }

    @Override
    public int select(Selector theSelector, long theTimeout) throws IOException {
        String selectorToString = this.getSelectorToString(theSelector);
        throw new TemporarySelectorClosedException("Temporary Selector " + selectorToString + " closed");
    }

    @Override
    public SelectionKey registerChannel(Selector theSelector, SelectableChannel theSelectableChannel, int theOps) throws IOException {
        String selectorToString = this.getSelectorToString(theSelector);
        throw new TemporarySelectorClosedException("Temporary Selector " + selectorToString + " closed");
    }

    @Override
    public TemporarySelectorState cancelKeyAndFlushSelector(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        String selectorToString = this.getSelectorToString(theSelector);
        throw new TemporarySelectorClosedException("Temporary Selector " + selectorToString + " closed");
    }

    @Override
    public TemporarySelectorState close(Selector theSelector) throws IOException {
        String selectorToString = this.getSelectorToString(theSelector);
        if (this.debug) {
            this.dprint("close()->: selector: " + selectorToString);
        }
        if (theSelector != null && theSelector.isOpen()) {
            theSelector.close();
        }
        if (this.debug) {
            this.dprint("close()<-: selector: " + selectorToString);
        }
        return this;
    }

    @Override
    public TemporarySelectorState removeSelectedKey(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        String selectorToString = this.getSelectorToString(theSelector);
        throw new TemporarySelectorClosedException("Temporary Selector " + selectorToString + " closed");
    }

    private String getSelectorToString(Selector theSelector) {
        String selectorToString = "(null)";
        if (theSelector != null) {
            selectorToString = theSelector.toString();
        }
        return selectorToString;
    }

    private void dprint(String theMsg) {
        ORBUtility.dprint("TemporarySelectorStateClosed", theMsg);
    }
}

