/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.common.util.XMLUtil;
import com.sun.xml.registry.uddi.BusinessLifeCycleManagerImpl;
import com.sun.xml.registry.uddi.BusinessQueryManagerImpl;
import com.sun.xml.registry.uddi.CapabilityProfileImpl;
import com.sun.xml.registry.uddi.ConnectionImpl;
import com.sun.xml.registry.uddi.LifeCycleManagerImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIObjectCache;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public class RegistryServiceImpl
implements RegistryService {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private BusinessLifeCycleManager businessLCM;
    private BusinessQueryManager businessQM;
    private LifeCycleManager lcm;
    private ConnectionImpl connection;
    private BulkResponse bulkResponse;
    private UDDIMapper uddiMapper;
    private String serviceId;
    private UDDIObjectCache objectManager;
    private HashMap bulkResponses = new HashMap();
    private XMLUtil xmlUtil;
    private boolean securitySet = false;
    private HashMap equivalentConcepts = new HashMap();
    private String defaultPostalSchemeId;

    RegistryServiceImpl(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.serviceId = Utility.generateUUID();
        this.xmlUtil = XMLUtil.getInstance();
        this.uddiMapper = new UDDIMapper(this);
        this.objectManager = this.uddiMapper.getObjectManager();
    }

    public UDDIMapper getUDDIMapper() {
        if (this.uddiMapper == null) {
            this.uddiMapper = new UDDIMapper(this);
        }
        return this.uddiMapper;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public UDDIObjectCache getObjectManager() {
        if (this.objectManager == null) {
            this.objectManager = this.uddiMapper.getObjectManager();
        }
        return this.objectManager;
    }

    @Override
    public CapabilityProfile getCapabilityProfile() throws JAXRException {
        return CapabilityProfileImpl.getInstance();
    }

    @Override
    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        if (this.businessLCM == null) {
            this.businessLCM = new BusinessLifeCycleManagerImpl(this);
        }
        return this.businessLCM;
    }

    @Override
    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        if (this.businessQM == null) {
            this.businessQM = new BusinessQueryManagerImpl(this);
        }
        return this.businessQM;
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        if (this.lcm == null) {
            this.lcm = new LifeCycleManagerImpl(this);
        }
        return this.lcm;
    }

    @Override
    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        throw new UnsupportedCapabilityException();
    }

    @Override
    public String makeRegistrySpecificRequest(String string2) throws JAXRException {
        boolean bl = false;
        try {
            return this.uddiMapper.makeRegistrySpecificRequest(string2, bl);
        }
        catch (JAXRException jAXRException) {
            bl = true;
            return this.uddiMapper.makeRegistrySpecificRequest(string2, bl);
        }
    }

    void addConceptMapping(String string2, String string3) throws JAXRException {
        if (string2 != null && string3 != null) {
            this.equivalentConcepts.put(string2, string3);
        }
    }

    HashMap getEquivalentConcepts() {
        return this.equivalentConcepts;
    }

    void setDefaultPostalScheme() {
        if (this.defaultPostalSchemeId == null) {
            this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        }
    }

    @Override
    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        this.defaultPostalSchemeId = this.connection.getDefaultPostalAddressScheme();
        if (this.defaultPostalSchemeId == null) {
            this.logger.finest(" defaultPostalSchemeId is null");
        }
        if (this.uddiMapper == null) {
            this.getUDDIMapper();
        }
        if (this.uddiMapper != null) {
            ClassificationScheme classificationScheme = this.uddiMapper.getClassificationSchemeById(this.defaultPostalSchemeId);
            return classificationScheme;
        }
        return null;
    }

    void storeBulkResponse(BulkResponse bulkResponse) {
        try {
            this.bulkResponses.put(bulkResponse.getRequestId(), bulkResponse);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Storing response with id: " + bulkResponse.getRequestId());
            }
        }
        catch (JAXRException jAXRException) {
            this.logger.log(Level.SEVERE, jAXRException.getMessage(), jAXRException);
        }
    }

    @Override
    public BulkResponse getBulkResponse(String string2) throws JAXRException {
        Object v = this.bulkResponses.remove(string2);
        if (v == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("RegistryServiceImpl:No_response_exists_for_specified_requestId"));
        }
        return (BulkResponse)v;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public SOAPBody jaxmSend(SOAPMessage sOAPMessage, boolean bl) throws JAXRException {
        SOAPBody sOAPBody = null;
        try {
            Object object;
            Object object2;
            String string2;
            final String string3 = this.getConnection().getHttpProxyHost();
            final String string4 = this.getConnection().getHttpProxyPort();
            String string5 = this.getConnection().getProxyUserName();
            String string6 = this.getConnection().getProxyPassword();
            final String string7 = this.getConnection().getHttpsProxyHost();
            final String string8 = this.getConnection().getHttpsProxyPort();
            if (string3 != null && !string3.equals("") && string4 != null && !string4.equals("")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Properties properties = System.getProperties();
                        properties.put("http.proxyHost", string3);
                        properties.put("http.proxyPort", string4);
                        return null;
                    }
                });
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("proxy host = " + string3);
                    this.logger.finest("proxy port = " + string4);
                }
            }
            if (string7 != null && !string7.equals("") && string8 != null && !string8.equals("")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Properties properties = System.getProperties();
                        properties.put("https.proxyHost", string7);
                        properties.put("https.proxyPort", string8);
                        return null;
                    }
                });
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("https proxy host = " + string7);
                    this.logger.finest("https proxy port = " + string8);
                }
            }
            final SOAPConnectionFactory sOAPConnectionFactory = (SOAPConnectionFactory)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return SOAPConnectionFactory.newInstance();
                    }
                    catch (SOAPException sOAPException) {
                        sOAPException.printStackTrace();
                        return null;
                    }
                }
            });
            SOAPConnection sOAPConnection = (SOAPConnection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return sOAPConnectionFactory.createConnection();
                    }
                    catch (SOAPException sOAPException) {
                        sOAPException.printStackTrace();
                        return null;
                    }
                }
            });
            if (string5 != null && string6 != null) {
                string2 = string5;
                object2 = string6;
                object = (String)AccessController.doPrivileged(new PrivilegedAction((String)object2){
                    final /* synthetic */ String val$fProxyPassword;
                    {
                        this.val$fProxyPassword = string3;
                    }

                    public Object run() {
                        return "Basic " + new BASE64Encoder().encode((string2 + ":" + this.val$fProxyPassword).getBytes());
                    }
                });
                sOAPMessage.getMimeHeaders().setHeader("Proxy-Authorization", (String)object);
            }
            string2 = null;
            if (bl) {
                if (!this.securitySet) {
                    this.securitySet = true;
                }
                string2 = this.connection.getLifeCycleManagerURL();
            } else {
                string2 = this.connection.getQueryManagerURL();
            }
            sOAPMessage.saveChanges();
            MarshallerUtil.getInstance().log(sOAPMessage);
            object2 = new URL(string2);
            object = sOAPConnection.call(sOAPMessage, object2);
            MarshallerUtil.getInstance().log((SOAPMessage)object);
            sOAPBody = ((SOAPMessage)object).getSOAPBody();
            sOAPConnection.close();
        }
        catch (Exception exception) {
            this.logger.log(Level.FINEST, exception.getMessage(), exception);
            throw new JAXRException(exception);
        }
        return sOAPBody;
    }

    public Node send(SOAPMessage sOAPMessage, boolean bl) throws JAXRException {
        boolean bl2 = this.getConnection().useSOAP();
        try {
            String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("useSOAP");
                }
            });
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                bl2 = true;
            }
        }
        catch (Throwable throwable) {
            this.logger.finest("Ignoring error checking for system useSOAP property: " + throwable);
        }
        if (bl2) {
            this.logger.fine("External Soap no longer used");
        }
        return this.jaxmSend(sOAPMessage, bl);
    }

    private void printNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.printNode(nodeList.item(i));
        }
    }

    public String getCurrentUser() {
        ConnectionImpl connectionImpl = this.getConnection();
        if (connectionImpl != null) {
            return connectionImpl.getCurrentUser();
        }
        return null;
    }
}

