/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.commons.NamedThreadFactory;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScheduledTaskManager {
    private static final Logger LOGGER = Logger.getLogger(ScheduledTaskManager.class);
    private static final AtomicInteger instanceNumber = new AtomicInteger(1);
    private static final long DELAY = 2000L;
    private static final long PERIOD = 100L;
    private final String name;
    private final ScheduledExecutorService executorService;
    private final Queue<ScheduledFuture<?>> scheduledTaskHandles;

    public ScheduledTaskManager(String name) {
        this.name = name.trim();
        String threadNamePrefix = this.name.toLowerCase().replaceAll("\\s+", "-") + "-scheduler-" + instanceNumber.getAndIncrement();
        this.executorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory(threadNamePrefix));
        this.scheduledTaskHandles = new ConcurrentLinkedQueue();
    }

    public void stopAllTasks() {
        ScheduledFuture<?> handle;
        while ((handle = this.scheduledTaskHandles.poll()) != null) {
            handle.cancel(false);
        }
    }

    public void shutdown() {
        this.stopAllTasks();
        this.executorService.shutdown();
        if (!this.executorService.isTerminated()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                LOGGER.fine("Interrupted while waiting for a scheduler to shut down.", (Throwable)ex);
            }
            if (!this.executorService.isTerminated()) {
                this.executorService.shutdownNow();
            }
        }
    }

    public ScheduledFuture<?> startTask(Runnable task, long initialDelay, long period) {
        ScheduledFuture<?> taskHandle = this.executorService.scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
        if (!this.scheduledTaskHandles.offer(taskHandle)) {
            LOGGER.warning(String.format("Unable to store handle for task of class [ %s ]", task.getClass().getName()));
        }
        return taskHandle;
    }

    public ScheduledFuture<?> runOnce(Runnable task) {
        return this.startTask(task, 2000L, 100L);
    }
}

