/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.event;

import org.glassfish.api.event.EventTypes;

public interface EventListener {
    public void event(Event var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Event<T> {
        final long inception;
        final EventTypes<T> type;
        final T hook;

        public Event(EventTypes<T> type2) {
            if (type2.getHookType() != null) {
                throw new IllegalArgumentException("Null event hook [" + type2.getHookType() + "]");
            }
            this.inception = System.currentTimeMillis();
            this.type = type2;
            this.hook = null;
        }

        public Event(EventTypes<T> type2, T hook) {
            this.inception = System.currentTimeMillis();
            this.type = type2;
            this.hook = hook;
        }

        public long inception() {
            return this.inception;
        }

        public String name() {
            return this.type.type();
        }

        public boolean is(EventTypes type2) {
            return type2 == this.type;
        }

        public T hook() {
            return this.type.getHookType().cast(this.hook);
        }

        public EventTypes<T> type() {
            return this.type;
        }
    }
}

