/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor
extends ORMetadata {
    private String m_access;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters = new ArrayList<ObjectTypeConverterMetadata>();
    private List<StructConverterMetadata> m_structConverters = new ArrayList<StructConverterMetadata>();
    private List<TypeConverterMetadata> m_typeConverters = new ArrayList<TypeConverterMetadata>();
    private List<PropertyMetadata> m_properties = new ArrayList<PropertyMetadata>();
    private MetadataDescriptor m_descriptor;
    private MetadataProject m_project;
    private String m_name;

    public MetadataAccessor(String xmlElement) {
        super(xmlElement);
    }

    public MetadataAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        super(annotation, accessibleObject);
        this.m_project = project;
        this.setDescriptor(descriptor);
        this.initAccess();
    }

    public void addConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverter();
    }

    public String getAccess() {
        return this.m_access;
    }

    @Override
    public MetadataAnnotatedElement getAccessibleObject() {
        return (MetadataAnnotatedElement)super.getAccessibleObject();
    }

    public String getAccessibleObjectName() {
        return this.getAccessibleObject().getName();
    }

    public MetadataAnnotatedElement getAnnotatedElement() {
        return this.getAccessibleObject();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    protected MetadataAnnotation getAnnotation(Class annotation) {
        return this.getAnnotation(annotation.getName());
    }

    protected MetadataAnnotation getAnnotation(String annotation) {
        return this.getAccessibleObject().getAnnotation(annotation, this.m_descriptor);
    }

    public String getAttributeName() {
        return this.getAccessibleObject().getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public MetadataClass getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public String getName() {
        return this.m_name;
    }

    protected String getName(DatabaseField field, String defaultName, String context) {
        return this.getName(field.getName(), defaultName, context);
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAnnotatedElementName());
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    protected String getDefaultAttributeName() {
        return this.m_project.useDelimitedIdentifier() ? this.getAttributeName() : this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName((String)this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer value, Integer defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected String getValue(String value, String defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    public boolean hasAccess() {
        return this.m_access != null;
    }

    public boolean hasPropertyAccess() {
        return this.hasAccess() && this.m_access.equals("PROPERTY");
    }

    public void initAccess() {
        MetadataAnnotation access;
        if (this.m_access == null && (access = this.getAnnotation("javax.persistence.Access")) != null) {
            this.setAccess((String)access.getAttribute("value"));
        }
    }

    public void initXMLAccessor(MetadataDescriptor descriptor, MetadataProject project) {
        this.m_project = project;
        this.setDescriptor(descriptor);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_converters, accessibleObject);
        this.initXMLObjects(this.m_objectTypeConverters, accessibleObject);
        this.initXMLObjects(this.m_structConverters, accessibleObject);
        this.initXMLObjects(this.m_typeConverters, accessibleObject);
        this.initXMLObjects(this.m_properties, accessibleObject);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAccessibleObject().isAnnotationPresent(annotation, this.m_descriptor);
    }

    public abstract boolean isProcessed();

    @Override
    public void merge(ORMetadata metadata) {
        MetadataAccessor accessor = (MetadataAccessor)metadata;
        this.m_access = (String)this.mergeSimpleObjects(this.m_access, accessor.getAccess(), accessor, "@access");
        this.m_converters = this.mergeORObjectLists(this.m_converters, accessor.getConverters());
        this.m_objectTypeConverters = this.mergeORObjectLists(this.m_objectTypeConverters, accessor.getObjectTypeConverters());
        this.m_structConverters = this.mergeORObjectLists(this.m_structConverters, accessor.getStructConverters());
        this.m_typeConverters = this.mergeORObjectLists(this.m_typeConverters, accessor.getTypeConverters());
        this.m_properties = this.mergeORObjectLists(this.m_properties, accessor.getProperties());
    }

    public abstract void process();

    protected void processCustomConverters() {
        for (ConverterMetadata converter : this.m_converters) {
            this.m_project.addConverter(converter);
        }
        MetadataAnnotation converter = this.getAnnotation(Converter.class);
        if (converter != null) {
            this.m_project.addConverter(new ConverterMetadata(converter, this.getAccessibleObject()));
        }
    }

    protected void processObjectTypeConverters() {
        for (ObjectTypeConverterMetadata objectTypeConverter : this.m_objectTypeConverters) {
            this.m_project.addConverter(objectTypeConverter);
        }
        MetadataAnnotation objectTypeConverter = this.getAnnotation(ObjectTypeConverter.class);
        if (objectTypeConverter != null) {
            this.m_project.addConverter(new ObjectTypeConverterMetadata(objectTypeConverter, this.getAccessibleObject()));
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns) {
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = primaryKeyJoinColumns.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (pkJoinColumns.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
            for (PrimaryKeyJoinColumnMetadata pkJoinColumn : pkJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
        } else if (pkJoinColumns.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
        }
        return pkJoinColumns;
    }

    protected void processStructConverter() {
        for (StructConverterMetadata structConverter : this.m_structConverters) {
            this.m_project.addConverter(structConverter);
        }
        MetadataAnnotation converter = this.getAnnotation(StructConverter.class);
        if (converter != null) {
            this.m_project.addConverter(new StructConverterMetadata(converter, this.getAccessibleObject()));
        }
    }

    protected void processTable(TableMetadata table, String defaultName) {
        this.getProject().processTable(table, defaultName, this.m_descriptor.getDefaultCatalog(), this.m_descriptor.getDefaultSchema());
    }

    protected void processTypeConverters() {
        for (TypeConverterMetadata typeConverter : this.m_typeConverters) {
            this.m_project.addConverter(typeConverter);
        }
        MetadataAnnotation typeConverter = this.getAnnotation(TypeConverter.class);
        if (typeConverter != null) {
            this.m_project.addConverter(new TypeConverterMetadata(typeConverter, this.getAccessibleObject()));
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    protected void setFieldName(DatabaseField field, String defaultName, String context) {
        field.setName(this.getName(field, defaultName, context), Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
        if (this.useDelimitedIdentifier()) {
            field.setUseDelimiters(this.useDelimitedIdentifier());
        }
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.m_properties = properties;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    protected boolean useDelimitedIdentifier() {
        return this.m_project.useDelimitedIdentifier();
    }
}

