/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityClassListenerMetadata
extends EntityListenerMetadata {
    private EntityAccessor m_accessor;
    private MetadataDescriptor m_descriptor;

    public EntityClassListenerMetadata(EntityAccessor accessor) {
        super(null, null, accessor.getAccessibleObject());
        this.m_accessor = accessor;
        this.m_descriptor = accessor.getDescriptor();
        this.setPostLoad(accessor.getPostLoad());
        this.setPostPersist(accessor.getPostPersist());
        this.setPostRemove(accessor.getPostRemove());
        this.setPostUpdate(accessor.getPostUpdate());
        this.setPrePersist(accessor.getPrePersist());
        this.setPreRemove(accessor.getPreRemove());
        this.setPreUpdate(accessor.getPreUpdate());
    }

    public void process(List<MappedSuperclassAccessor> mappedSuperclasses, ClassLoader loader) {
        Class accessorClass = this.getClassForName(this.m_accessor.getJavaClass().getName(), loader);
        this.m_listener = new EntityClassListener(accessorClass);
        this.processCallbackMethods(this.getDeclaredMethods(accessorClass), this.m_descriptor);
        if (!this.m_descriptor.excludeSuperclassListeners()) {
            for (MappedSuperclassAccessor mappedSuperclass : mappedSuperclasses) {
                Class superClass = this.getClassForName(mappedSuperclass.getJavaClass().getName(), loader);
                this.processCallbackMethods(this.getDeclaredMethods(superClass), this.m_descriptor);
            }
        }
        if (this.m_listener.hasCallbackMethods()) {
            this.m_descriptor.setEntityEventListener(this.m_listener);
        }
    }
}

