/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-connector-work-security-map")
@Scoped(value=PerLookup.class)
@I18n(value="delete.connector.work.security.map")
public class DeleteConnectorWorkSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorWorkSecurityMap.class);
    @Param(name="raname")
    String raName;
    @Param(name="mapname", primary=true)
    String mapName;
    @Inject
    Resources resources;
    @Inject
    WorkSecurityMap[] workSecurityMaps;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceExists()) {
            report.setMessage(localStrings.getLocalString("delete.connector.work.security.map.notFound", "A connector work security map named {0} for resource adapter {1} does not exist.", new Object[]{this.mapName, this.raName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (WorkSecurityMap resource : DeleteConnectorWorkSecurityMap.this.workSecurityMaps) {
                        if (!resource.getName().equals(DeleteConnectorWorkSecurityMap.this.mapName) || !resource.getResourceAdapterName().equals(DeleteConnectorWorkSecurityMap.this.raName)) continue;
                        param.getResources().remove(resource);
                        break;
                    }
                    return DeleteConnectorWorkSecurityMap.this.workSecurityMaps;
                }
            }, this.resources);
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(DeleteConnectorWorkSecurityMap.class.getName()).log(Level.SEVERE, "delete-connector-work-security-map failed", tfe);
            report.setMessage(localStrings.getLocalString("delete.connector.work.security.map.fail", "Unable to delete connector work security map {0} for resource adapter {1}", new Object[]{this.mapName, this.raName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isResourceExists() {
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof WorkSecurityMap) || !((WorkSecurityMap)resource).getName().equals(this.mapName) || !((WorkSecurityMap)resource).getResourceAdapterName().equals(this.raName)) continue;
            return true;
        }
        return false;
    }
}

