/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-connector-connection-pools")
@Scoped(value=PerLookup.class)
@I18n(value="list.connector.connection.pools")
public class ListConnectorConnectionPools
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorConnectionPools.class);
    @Inject
    ConnectorConnectionPool[] connPools;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (ConnectorConnectionPool cp : this.connPools) {
                list.add(cp.getName());
            }
            for (String cpName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(cpName);
            }
        }
        catch (Exception e) {
            Logger.getLogger(ListConnectorConnectionPools.class.getName()).log(Level.SEVERE, "Something went wrong in list-connector-connection-pools", e);
            report.setMessage(localStrings.getLocalString("list.connector.connection.pools.failed", "List connector connection pools failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

