/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.PrincipalMap;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.DeleteConnectorWorkSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-connector-work-security-maps")
@Scoped(value=PerLookup.class)
@I18n(value="list.connector.work.security.maps")
public class ListConnectorWorkSecurityMaps
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorWorkSecurityMaps.class);
    @Param(name="securitymap", optional=true)
    String securityMap;
    @Param(name="resource-adapter-name", primary=true)
    String raName;
    @Inject
    Resources resources;
    @Inject
    WorkSecurityMap[] workSecurityMaps;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart mp = report.getTopMessagePart();
        try {
            boolean foundWSM = false;
            for (WorkSecurityMap wsm : this.workSecurityMaps) {
                if (!wsm.getResourceAdapterName().equals(this.raName)) continue;
                if (this.securityMap == null) {
                    this.listWorkSecurityMap(wsm, mp);
                    foundWSM = true;
                    continue;
                }
                if (!wsm.getName().equals(this.securityMap)) continue;
                this.listWorkSecurityMap(wsm, mp);
                foundWSM = true;
                break;
            }
            if (!foundWSM) {
                report.setMessage(localStrings.getLocalString("list.connector.work.security.maps.workSecurityMapNotFound", "Nothing to list. Either the resource adapter {0} does not exist or theresource adapter {0} is not associated with any work security map.", new Object[]{this.raName}));
            }
        }
        catch (Exception e) {
            Logger.getLogger(DeleteConnectorWorkSecurityMap.class.getName()).log(Level.SEVERE, "list-connector-work-security-maps failed", e);
            report.setMessage(localStrings.getLocalString("list.connector.work.security.maps.fail", "Unable to list connector work security map {0} for resource adapter {1}", new Object[]{this.securityMap, this.raName}) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void listWorkSecurityMap(WorkSecurityMap wsm, ActionReport.MessagePart mp) {
        ActionReport.MessagePart part;
        List principalList = wsm.getPrincipalMap();
        List groupList = wsm.getGroupMap();
        for (PrincipalMap map : principalList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.work.security.maps.eisPrincipalAndMappedPrincipal", "{0}: EIS principal={1}, mapped principal={2}", new Object[]{wsm.getName(), map.getEisPrincipal(), map.getMappedPrincipal()}));
        }
        for (PrincipalMap map : groupList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.work.security.maps.eisGroupAndMappedGroup", "{0}: EIS group={1}, mapped group={2}", new Object[]{wsm.getName(), map.getEisGroup(), map.getMappedGroup()}));
        }
    }
}

