/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="entity-bean-mon", group="monitoring", isSingleton=false)
@ManagedObject
public class EntityBeanStatsProvider
extends EjbMonitoringStatsProvider {
    private BoundedRangeStatisticImpl pooledCount = null;
    private BoundedRangeStatisticImpl readyCount = null;
    private EntityContainer delegate;

    public EntityBeanStatsProvider(EntityContainer delegate, long beanId, String appName, String moduleName, String beanName) {
        super(beanId, appName, moduleName, beanName);
        this.delegate = delegate;
        long now = System.currentTimeMillis();
        this.pooledCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxPoolSize(), (long)delegate.getSteadyPoolSize(), "PooledCount", "count", "Number of entity beans in pooled state", now, now);
        this.readyCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxCacheSize(), 0L, "ReadyCount", "count", "Number of entity beans in ready state", now, now);
    }

    @ManagedAttribute(id="pooledcount")
    @Description(value="Number of entity beans in pooled state")
    public RangeStatistic getPooledCount() {
        this.pooledCount.setCurrent(this.delegate.getPooledCount());
        return this.pooledCount.getStatistic();
    }

    @ManagedAttribute(id="readycount")
    @Description(value="Number of entity beans in ready state")
    public RangeStatistic getReadyCount() {
        this.readyCount.setCurrent(this.delegate.getReadyCount());
        return this.readyCount.getStatistic();
    }
}

