/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.glassfish.internal.api.Globals;
import org.glassfish.persistence.common.I18NHelper;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.jvnet.hk2.component.Habitat;

public class DeploymentHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)DeploymentHelper.class.getClassLoader());
    private static Logger logger = LogHelperPersistenceManager.getLogger();

    public static String getDDLNamePrefix(Object info) {
        return Java2DBProcessorHelper.getDDLNamePrefix((Object)info);
    }

    public static boolean isJavaToDatabase(EjbBundleDescriptor bundle) {
        Properties userPolicy = bundle.getCMPResourceReference().getSchemaGeneratorProperties();
        return DeploymentHelper.isJavaToDatabase(userPolicy);
    }

    public static boolean isJavaToDatabase(Properties prop) {
        String value;
        if (prop != null && !StringHelper.isEmpty((String)(value = prop.getProperty("java-to-database")))) {
            if (logger.isLoggable(500)) {
                logger.fine("java-to-database property is set.");
            }
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static Connection getConnection(String name) throws SQLException {
        if (logger.isLoggable(500)) {
            logger.fine("ejb.DeploymentHelper.getconnection", (Object)name);
        }
        Habitat habitat = Globals.getDefaultHabitat();
        DataSource ds = null;
        try {
            ConnectorRuntime connectorRuntime = (ConnectorRuntime)habitat.getByContract(ConnectorRuntime.class);
            ds = (DataSource)DataSource.class.cast(connectorRuntime.lookupNonTxResource(name, false));
        }
        catch (Exception e) {
            throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.jndi.lookupfailed", (String)name));
        }
        return ds.getConnection();
    }

    private static void handleUnexpectedInstance(String name, Object value) {
        JDOFatalUserException e = new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.jndi.unexpectedinstance", (String)name, (String)value.getClass().getName()));
        logger.severe(((Throwable)e).toString());
        throw e;
    }
}

