/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.model;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.spi.persistence.support.sqlstore.ConfigCache;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceConfig;
import com.sun.jdo.spi.persistence.support.sqlstore.VersionConsistencyCache;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.model.ClassDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigCacheImpl
implements ConfigCache,
ApplicationLifeCycleEventListener {
    private Map classConfigs = new HashMap();
    private Map oidClassToClassType;
    private VersionConsistencyCache vcCache;
    private Map classLoaderToClassType = new HashMap();
    protected static final Logger logger = LogHelperSQLStore.getLogger();

    public ConfigCacheImpl() {
        this.oidClassToClassType = new HashMap();
        EJBHelper.registerApplicationLifeCycleEventListener(this);
    }

    public synchronized PersistenceConfig getPersistenceConfig(Class pcClass) {
        ClassDesc sqlConfig = (ClassDesc)this.classConfigs.get(pcClass);
        if (sqlConfig == null) {
            sqlConfig = ClassDesc.newInstance(pcClass);
            this.classConfigs.put(pcClass, sqlConfig);
            sqlConfig.initialize(this);
            this.oidClassToClassType.put(sqlConfig.getOidClass(), pcClass);
            this.addToClassLoaderMap(pcClass);
        }
        return sqlConfig;
    }

    public Class getClassByOidClass(Class oidType) {
        return (Class)this.oidClassToClassType.get(oidType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyApplicationUnloaded(ClassLoader classLoader) {
        boolean debug = logger.isLoggable(300);
        ConfigCacheImpl configCacheImpl = this;
        synchronized (configCacheImpl) {
            List pcClasses;
            if (debug) {
                Object[] items = new Object[]{"classLoaderToClassType", this.classLoaderToClassType.size()};
                logger.finest("sqlstore.model.configcacheimpl.size_before", items);
            }
            if ((pcClasses = (List)this.classLoaderToClassType.get(classLoader)) != null) {
                Object[] items;
                if (debug) {
                    Object[] items2 = new Object[]{"classConfigs", this.classConfigs.size()};
                    logger.finest("sqlstore.model.configcacheimpl.size_before", items2);
                    items2 = new Object[]{"oidClassToClassType", this.oidClassToClassType.size()};
                    logger.finest("sqlstore.model.configcacheimpl.size_before", items2);
                }
                for (Class classType : pcClasses) {
                    ClassDesc config = (ClassDesc)this.classConfigs.remove(classType);
                    Class oidClass = config.getOidClass();
                    this.oidClassToClassType.remove(oidClass);
                    if (!config.hasVersionConsistency() || this.vcCache == null) continue;
                    this.vcCache.removePCType(classType);
                }
                if (debug) {
                    items = new Object[]{"classConfigs", this.classConfigs.size()};
                    logger.finest("sqlstore.model.configcacheimpl.size_after", items);
                    items = new Object[]{"oidClassToClassType", this.oidClassToClassType.size()};
                    logger.finest("sqlstore.model.configcacheimpl.size_after", items);
                }
                this.classLoaderToClassType.remove(classLoader);
                if (debug) {
                    items = new Object[]{"classLoaderToClassType", this.classLoaderToClassType.size()};
                    logger.finest("sqlstore.model.configcacheimpl.size_after", items);
                }
            }
        }
        TypeTable.removeInstance(classLoader);
        Model model = Model.RUNTIME;
        model.removeResourcesFromCaches(classLoader);
    }

    public synchronized void setVersionConsistencyCache(VersionConsistencyCache vcCache) {
        this.vcCache = vcCache;
    }

    private void addToClassLoaderMap(Class pcClass) {
        ClassLoader classLoader = pcClass.getClassLoader();
        ArrayList<Class> classes = (ArrayList<Class>)this.classLoaderToClassType.get(classLoader);
        if (classes == null) {
            classes = new ArrayList<Class>();
            this.classLoaderToClassType.put(classLoader, classes);
        }
        classes.add(pcClass);
    }
}

