/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Subscription
extends Consumer {
    static final long serialVersionUID = -6794838710921895217L;
    private static CacheHashMap cache = new CacheHashMap(20);
    static Map durableList = new HashMap();
    static Map nonDurableList = new HashMap();
    boolean isDurable = true;
    transient Map activeConsumers = null;
    transient boolean stored = false;
    SubSet msgsSubset = null;
    int maxNumActiveConsumers = 1;
    transient Object subLock = new Object();
    protected String durableName = null;
    protected String clientID = null;
    int hashcode = 0;
    private static boolean loaded = false;

    public boolean isDurable() {
        return this.isDurable;
    }

    public int numInProcessMsgs() {
        int n = this.msgs.size();
        return n += this.numPendingAcks();
    }

    public int numPendingAcks() {
        int n = 0;
        List list = this.getChildConsumers();
        for (Consumer consumer : list) {
            n += consumer.numPendingAcks();
        }
        return n;
    }

    public List getChildConsumers() {
        if (this.activeConsumers == null) {
            return new ArrayList();
        }
        return new ArrayList(this.activeConsumers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("type", "SUBSCRIPTION");
        if (this.durableName != null) {
            hashtable.put("durableName", this.durableName);
        } else {
            hashtable.put("durableName", "<none - shared non-durable>");
        }
        hashtable.put("isDurable", String.valueOf(this.isDurable));
        hashtable.put("clientID", this.clientID);
        hashtable.put("stored", String.valueOf(this.stored));
        hashtable.put("maxNumActiveConsumers", String.valueOf(this.maxNumActiveConsumers));
        hashtable.put("activeConsumers", String.valueOf(this.valid));
        Vector<String> vector = new Vector<String>();
        Map map = this.activeConsumers;
        synchronized (map) {
            Iterator iterator = this.activeConsumers.keySet().iterator();
            while (iterator.hasNext()) {
                vector.add(String.valueOf(((ConsumerUID)iterator.next()).longValue()));
            }
        }
        return hashtable;
    }

    public int getActiveSubscriberCnt() {
        return this.activeConsumers.size();
    }

    public void setConsumerUID(ConsumerUID consumerUID) {
        this.uid = consumerUID;
    }

    public boolean equals(Object object) {
        if (object instanceof Subscription) {
            Subscription subscription = (Subscription)object;
            if (this.isDurable != subscription.isDurable) {
                return false;
            }
            if (this.isDurable) {
                return this.durableName.equals(subscription.durableName) && this.clientID.equals(subscription.clientID);
            }
            return (this.clientID == subscription.clientID || this.clientID != null && this.clientID.equals(subscription.clientID)) && (this.dest == subscription.dest || this.dest != null && this.dest.equals(subscription.dest)) && (this.selstr == subscription.selstr || this.selstr != null && this.selstr.equals(subscription.selstr));
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.activeConsumers = new HashMap();
        this.subLock = new Object();
        this.stored = true;
        this.active = false;
        this.getConsumerUID().setShouldStore(true);
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
    }

    private int calcHashcode() {
        if (this.isDurable) {
            return this.durableName.hashCode() * 31 + this.clientID.hashCode();
        }
        return this.dest.hashCode() * 31 + (this.clientID == null ? 0 : this.clientID.hashCode()) + 961 * (this.selstr == null ? 0 : this.selstr.hashCode());
    }

    private Subscription(DestinationUID destinationUID, String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3, ConsumerUID consumerUID) throws IOException, SelectorFormatException, BrokerException {
        super(destinationUID, string, bl, consumerUID);
        this.logger.log(4, "Creating Subscription " + this.uid + " with DurableName " + string2 + " and clientID " + string3);
        this.getConsumerUID().setShouldStore(true);
        this.durableName = string2;
        this.clientID = string3;
        this.activeConsumers = new HashMap();
        this.active = false;
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
        if (bl2) {
            Globals.getClusterBroadcast().recordCreateSubscription(this);
        } else if (Globals.getHAEnabled()) {
            bl3 = bl2;
            this.stored = bl2;
        }
        try {
            if (bl3) {
                Globals.getStore().storeInterest(this, Destination.PERSIST_SYNC);
                this.stored = true;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string2, string3, destinationUID.toString()};
            this.logger.log(8, "B3147", objectArray, (Throwable)exception);
        }
    }

    private Subscription(DestinationUID destinationUID, String string, String string2, boolean bl) throws IOException, SelectorFormatException, BrokerException {
        super(destinationUID, string2, bl, (ConnectionUID)null);
        this.isDurable = false;
        this.logger.log(4, "Creating Non-Durable Subscription " + this.uid + " with clientID " + string);
        this.getConsumerUID().setShouldStore(true);
        this.clientID = string;
        this.activeConsumers = new HashMap();
        this.active = false;
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
    }

    public void setMaxNumActiveConsumers(int n) {
        this.maxNumActiveConsumers = n;
    }

    public int getMaxNumActiveConsumers() {
        return this.maxNumActiveConsumers;
    }

    public void setShared(boolean bl) {
        this.maxNumActiveConsumers = bl ? this.getFirstDestination().getMaxNumSharedConsumers() : 1;
    }

    public boolean getShared() {
        return this.maxNumActiveConsumers != 1;
    }

    public void destroyConsumer(Set set, Map map, boolean bl, boolean bl2, boolean bl3) {
        if (!this.valid) {
            return;
        }
        if (!this.isDurable) {
            for (Object[] objectArray : this.getDestinations()) {
                try {
                    objectArray.removeConsumer(this.uid, map, bl, false);
                }
                catch (Exception exception) {
                    this.logger.logStack(8, "Internal Error ", exception);
                }
            }
        }
        super.destroyConsumer(set, map, bl, bl2, bl3);
        if (this.stored) {
            try {
                Globals.getStore().removeInterest(this, Destination.PERSIST_SYNC);
                this.stored = false;
            }
            catch (Exception exception) {
                Object[] objectArray;
                objectArray = new String[]{this.durableName, this.clientID, this.dest.toString()};
                this.logger.log(32, "B3148", objectArray, (Throwable)exception);
            }
        }
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void sendCreateSubscriptionNotification(Consumer consumer) throws BrokerException {
        Destination destination = this.getFirstDestination();
        if (!(destination != null && (destination.getIsLocal() || destination.isInternal() || destination.isAdmin()) || Globals.getClusterBroadcast() == null)) {
            Globals.getClusterBroadcast().createSubscription(this, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachConsumer(Consumer consumer) throws BrokerException {
        this.logger.log(4, "Attaching Consumer " + consumer + " to durable " + this + " with  " + this.msgs.size() + " msgs " + this.getDestinationUID() + "[" + this.getConsumerUID() + "]");
        Object object = this.subLock;
        synchronized (object) {
            Object[] objectArray;
            if (this.maxNumActiveConsumers == 1) {
                if (this.conuid == null) {
                    objectArray = consumer.getConsumerUID();
                    this.uid.setConnectionUID(objectArray.getConnectionUID());
                    this.conuid = objectArray.getConnectionUID();
                }
            } else if (!this.activeConsumers.isEmpty() && consumer.noLocal != this.noLocal) {
                throw new IllegalStateException("nolocal must match on all consumers");
            }
            if (this.maxNumActiveConsumers != -1 && this.activeConsumers.size() >= this.maxNumActiveConsumers) {
                objectArray = new String[]{this.getDestinations().toString(), this.toString(), String.valueOf(this.maxNumActiveConsumers), String.valueOf(this.activeConsumers.size())};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4207", objectArray), "B4207", null, 409);
            }
            boolean bl = this.isActive();
            consumer.setStoredConsumerUID(this.getConsumerUID());
            consumer.getConsumerUID().setShouldStore(true);
            this.activeConsumers.put(consumer.getConsumerUID(), consumer);
            if (this.msgsSubset == null) {
                this.msgsSubset = this.msgs.subSet((Filter)null);
            }
            consumer.setParentList(this.msgsSubset);
            consumer.setSubscription(this);
            boolean bl2 = this.active = !this.activeConsumers.isEmpty();
            if (this.isActive() && !bl) {
                Iterator iterator = Destination.findMatchingIDs(this.getDestinationUID()).iterator();
                while (iterator.hasNext()) {
                    Destination destination = Destination.getDestination((DestinationUID)iterator.next());
                    if (destination == null || destination.isLoaded()) continue;
                    this.logger.log(4, "Loading " + destination);
                    try {
                        destination.load();
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(8, "Internal Exception: unable to load destination " + destination, brokerException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void releaseConsumer(ConsumerUID consumerUID) {
        this.logger.log(4, "Releasing Consumer " + consumerUID + " from durable " + this);
        this.pause("Subscription: releaseConsumer " + consumerUID);
        Consumer consumer = null;
        Class<Subscription> clazz = this.subLock;
        // MONITORENTER : clazz
        consumer = (Consumer)this.activeConsumers.remove(consumerUID);
        consumer.pause("Subscription: releaseConsumer B ");
        consumer.setParentList(null);
        this.active = !this.activeConsumers.isEmpty();
        // MONITOREXIT : clazz
        if (!this.isDurable) {
            clazz = Subscription.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.core.Subscription.class
            boolean bl = this.active = !this.activeConsumers.isEmpty();
            if (!this.active) {
                this.logger.log(4, "Cleaning up non-durable  subscription " + this);
                String string = this.clientID + ":" + consumer.getDestinationUID() + ":" + this.selstr;
                nonDurableList.remove(string);
                this.destroyConsumer(new HashSet(), null, false, true, false);
            }
            // MONITOREXIT : clazz
        }
        consumer.resume("Subscription: releaseConsumer B ");
        this.resume("Subscription: release consumer " + consumerUID);
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUniqueName() {
        String string = null;
        string = this.isDurable ? this.clientID + ":" + this.durableName : this.dest + ":" + this.clientID + ":" + this.selstr;
        return URLEncoder.encode(string);
    }

    public String toString() {
        String string = "Subscription :" + this.uid + " - ";
        string = string + " dest=" + this.getDestinationUID();
        if (!this.isDurable) {
            return string + this.uid;
        }
        if (this.clientID != null) {
            string = string + " CID=" + this.clientID;
        }
        if (this.durableName != null) {
            string = string + " DN=" + this.durableName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() throws BrokerException {
        super.purgeConsumer();
        Object object = this.subLock;
        synchronized (object) {
            for (Consumer consumer : this.activeConsumers.values()) {
                consumer.purgeConsumer();
            }
        }
    }

    private static Object getKey(String string, String string2) {
        return "CID=" + string + ":DNAME=" + string2;
    }

    public static void clearSubscriptions() {
        nonDurableList.clear();
        cache.clear();
        durableList.clear();
        loaded = false;
    }

    public static void initSubscriptions() {
        Consumer consumer;
        Consumer consumer2;
        Object object;
        Logger logger = Globals.getLogger();
        logger.log(4, "Initializing consumers");
        if (loaded) {
            return;
        }
        loaded = true;
        Consumer[] consumerArray = null;
        try {
            consumerArray = Globals.getStore().getLoadConsumerException();
        }
        catch (Exception exception) {
            logger.logStack(4, "Error loading consumer exception ", exception);
        }
        if (consumerArray != null) {
            object = consumerArray;
            while (object != null) {
                ConsumerUID consumerUID = (ConsumerUID)object.getKey();
                consumer2 = (Consumer)object.getValue();
                if (consumerUID == null && consumer2 == null) {
                    logger.log(16, "B3044", "both key and value are corrupted");
                    continue;
                }
                if (consumerUID == null) {
                    try {
                        Globals.getStore().storeInterest(consumer2, true);
                    }
                    catch (Exception exception) {
                        logger.log(16, "B2094", (Object)consumer2.getConsumerUID(), (Throwable)exception);
                    }
                } else {
                    logger.log(16, "B2095", consumerUID.toString());
                    try {
                        consumer = new Consumer(consumerUID);
                        Globals.getStore().removeInterest(consumer, false);
                    }
                    catch (Exception exception) {
                        logger.logStack(4, "Error removing corrupt consumer " + consumerUID, exception);
                    }
                }
                object = object.getNextException();
            }
        }
        try {
            object = Globals.getStore().getAllInterests();
            for (int i = 0; i < ((Consumer[])object).length; ++i) {
                Object object2;
                consumer2 = object[i];
                if (consumer2 == null) continue;
                assert (consumer2 instanceof Subscription);
                consumer = (Subscription)consumer2;
                String string = ((Subscription)consumer).getClientID();
                String string2 = ((Subscription)consumer).getDurableName();
                logger.log(8, "Loading stored durable " + string + ":" + string2);
                Object object3 = Subscription.getKey(string, string2);
                if (durableList.get(object3) != null) {
                    logger.log(8, "B3100", "loaded durable consumer [cid=" + string + ", dn=" + string2 + "] already exists " + durableList.get(object3));
                }
                durableList.put(object3, consumer);
                DestinationUID destinationUID = consumer.getDestinationUID();
                if (destinationUID.isWildcard()) {
                    wildcardConsumers.add(consumer2.getConsumerUID());
                    object2 = Destination.findMatchingIDs(destinationUID);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        DestinationUID destinationUID2 = (DestinationUID)iterator.next();
                        Destination destination = Destination.getDestination(destinationUID2);
                        destination.addConsumer(consumer, false);
                    }
                    continue;
                }
                object2 = Destination.getDestination(destinationUID.getName(), destinationUID.isQueue() ? 1 : 2, true, true);
                ((Destination)object2).addConsumer(consumer, false);
            }
        }
        catch (Exception exception) {
            logger.logStack(32, "B3146", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllDurableSubscriptions(DestinationUID destinationUID) {
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription subscription : durableList.values()) {
                if (destinationUID != null && !destinationUID.equals(subscription.getDestinationUID())) continue;
                hashSet.add(subscription);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllNonDurableSubscriptions(DestinationUID destinationUID) {
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription subscription : nonDurableList.values()) {
                if (destinationUID != null && !destinationUID.equals(subscription.getDestinationUID())) continue;
                hashSet.add(subscription);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllSubscriptions(DestinationUID destinationUID) {
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription subscription : durableList.values()) {
                if (destinationUID != null && !destinationUID.equals(subscription.getDestinationUID())) continue;
                hashSet.add(subscription);
            }
            for (Subscription subscription : nonDurableList.values()) {
                if (destinationUID != null && !destinationUID.equals(subscription.getDestinationUID())) continue;
                hashSet.add(subscription);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return hashSet;
        }
    }

    public static Subscription remoteUnsubscribe(String string, String string2) throws BrokerException {
        return Subscription.unsubscribe(string, string2, false, false, false, false);
    }

    public static Subscription unsubscribe(String string, String string2) throws BrokerException {
        return Subscription.unsubscribe(string, string2, false, false);
    }

    public static Subscription unsubscribeOnDestroy(String string, String string2, boolean bl) throws BrokerException {
        return Subscription.unsubscribe(string, string2, false, true, bl, true);
    }

    public static Subscription unsubscribe(String string, String string2, boolean bl) throws BrokerException {
        return Subscription.unsubscribe(string, string2, bl, false);
    }

    private static Subscription unsubscribe(String string, String string2, boolean bl, boolean bl2) throws BrokerException {
        return Subscription.unsubscribe(string, string2, bl, bl2, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Subscription unsubscribe(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws BrokerException {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Object object = Subscription.getKey(string2, string);
            Subscription subscription = (Subscription)durableList.get(object);
            if (subscription == null) {
                DestinationUID destinationUID = (DestinationUID)cache.get(string + ":" + string2);
                if (destinationUID != null) {
                    Object[] objectArray = new String[]{string, string2, destinationUID.toString()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4209", objectArray), "B4209", null, 412);
                }
                Object[] objectArray = new String[]{string, string2};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4058", objectArray), "B4058", null, 404);
            }
            if (subscription.isActive()) {
                if (bl || bl2) {
                    Iterator iterator = null;
                    Object object2 = subscription.subLock;
                    synchronized (object2) {
                        iterator = new HashSet(subscription.activeConsumers.values()).iterator();
                    }
                    while (iterator.hasNext()) {
                        object2 = (Consumer)iterator.next();
                        ((Consumer)object2).destroyConsumer(new HashSet(), null, false, bl2, bl3);
                    }
                    subscription.activeConsumers.clear();
                } else {
                    Object[] objectArray = new String[]{subscription.getDestinationUID().getName(), string, string2};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4007", objectArray), "B4007", null, 409);
                }
            }
            if (bl4) {
                cache.put(string + ":" + string2, subscription.getDestinationUID());
            }
            if (bl3) {
                Globals.getClusterBroadcast().recordUnsubscribe(subscription);
            }
            durableList.remove(object);
            subscription.destroyConsumer(new HashSet(), null, false, bl2, bl3);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return subscription;
        }
    }

    public static Subscription subscribe(String string, String string2, String string3, DestinationUID destinationUID, boolean bl, boolean bl2, ConsumerUID consumerUID) throws BrokerException, SelectorFormatException {
        return Subscription.subscribe(string, string2, string3, destinationUID, bl, bl2, true, consumerUID);
    }

    public static Subscription subscribe(String string, String string2, String string3, DestinationUID destinationUID, boolean bl, boolean bl2, boolean bl3) throws BrokerException, SelectorFormatException {
        return Subscription.subscribe(string, string2, string3, destinationUID, bl, bl2, bl3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription subscribe(String string, String string2, String string3, DestinationUID destinationUID, boolean bl, boolean bl2, boolean bl3, ConsumerUID consumerUID) throws BrokerException, SelectorFormatException {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription subscription = Subscription.findDurableSubscription(string2, string);
            if (subscription != null) {
                Object[] objectArray = new String[]{string, string2, destinationUID.toString()};
                throw new ConflictException(Globals.getBrokerResources().getKString("B4095", objectArray));
            }
            try {
                subscription = new Subscription(destinationUID, string3, bl, string, string2, bl2, bl3, consumerUID);
            }
            catch (IOException iOException) {
                Object[] objectArray = new String[]{string, string2, destinationUID.toString()};
                throw new BrokerException(Globals.getBrokerResources().getKString("B3149", objectArray), iOException);
            }
            durableList.put(Subscription.getKey(string2, string), subscription);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findDurableSubscription(String string, String string2) {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            assert (string != null);
            assert (string2 != null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (Subscription)durableList.get(Subscription.getKey(string, string2));
        }
    }

    public static Subscription findCreateDurableSubscription(String string, String string2, DestinationUID destinationUID, String string3, boolean bl) throws BrokerException, SelectorFormatException {
        return Subscription.findCreateDurableSubscription(string, string2, destinationUID, string3, bl, false, null);
    }

    public static Subscription findCreateDurableSubscription(String string, String string2, DestinationUID destinationUID, String string3, boolean bl, boolean bl2) throws BrokerException, SelectorFormatException {
        return Subscription.findCreateDurableSubscription(string, string2, destinationUID, string3, bl, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findCreateDurableSubscription(String string, String string2, DestinationUID destinationUID, String string3, boolean bl, boolean bl2, ConsumerUID consumerUID) throws BrokerException, SelectorFormatException {
        Logger logger = Globals.getLogger();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription subscription = Subscription.findDurableSubscription(string, string2);
            if (subscription != null && (subscription.isActive() && !subscription.getShared() || !destinationUID.equals(subscription.getDestinationUID()) || subscription.getNoLocal() != bl || string3 != subscription.getSelectorStr() && (string3 == null || !string3.equals(subscription.getSelectorStr())))) {
                if (subscription.isActive() && !subscription.getShared()) {
                    Object[] objectArray = new String[]{string2, string, destinationUID.toString()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4095", objectArray), "B4095", null, 409);
                }
                logger.log(4, "Unsubscribing " + string2 + ":" + string);
                Subscription.unsubscribe(string2, string, false, false, bl2, false);
                subscription = null;
            }
            if (subscription == null) {
                logger.log(4, "creating new durable subscriber " + string + ":" + string2 + " got " + subscription);
                subscription = Subscription.subscribe(string2, string, string3, destinationUID, bl, bl2, consumerUID);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return subscription;
        }
    }

    private static String createNDUID(String string, DestinationUID destinationUID, String string2) {
        return string + ":" + destinationUID + ":" + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findNonDurableSubscription(String string, DestinationUID destinationUID, String string2) {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            String string3 = Subscription.createNDUID(string, destinationUID, string2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (Subscription)nonDurableList.get(string3);
        }
    }

    public static Subscription createAttachNonDurableSub(Consumer consumer, Connection connection) throws BrokerException, IOException, SelectorFormatException {
        String string = null;
        if (connection != null) {
            string = (String)connection.getClientData("client id");
        }
        return Subscription.createAttachNonDurableSub(consumer, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription createAttachNonDurableSub(Consumer consumer, String string) throws BrokerException, IOException, SelectorFormatException {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription subscription = Subscription.findNonDurableSubscription(string, consumer.getDestinationUID(), consumer.getSelectorStr());
            if (subscription == null) {
                subscription = Subscription.findCreateNonDurableSubscription(string, consumer.getSelectorStr(), consumer.getDestinationUID(), consumer.getNoLocal(), null);
            }
            subscription.attachConsumer(consumer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return subscription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findCreateNonDurableSubscription(String string, String string2, DestinationUID destinationUID, boolean bl, ConsumerUID consumerUID) throws BrokerException, IOException, SelectorFormatException {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            String string3 = Subscription.createNDUID(string, destinationUID, string2);
            Subscription subscription = (Subscription)nonDurableList.get(string3);
            if (subscription == null) {
                subscription = new Subscription(destinationUID, string, string2, bl);
                if (consumerUID != null) {
                    subscription.setConsumerUID(consumerUID);
                }
                Globals.getLogger().log(4, "Created new non-durable subscription " + subscription);
                nonDurableList.put(string3, subscription);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return subscription;
        }
    }
}

