/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jms.management.server.DestinationNotification;
import com.sun.messaging.jms.management.server.DestinationState;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class DestinationMonitor
extends MQMBeanReadOnly {
    private Destination d = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] numWildcardConsumersSignature;
    private static MBeanParameterInfo[] numWildcardProducersSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] dstNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationMonitor(Destination destination) {
        this.d = destination;
    }

    public Integer getAvgNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgActiveConsumers());
    }

    public Integer getAvgNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgFailoverConsumers());
    }

    public Integer getAvgNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getAvgActiveConsumers());
    }

    public Long getAvgNumMsgs() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getAverageMessages());
    }

    public Long getAvgTotalMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getAverageMessageBytes());
    }

    public String getConnectionID() {
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID connectionUID = this.d.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        return Long.toString(connectionUID.longValue());
    }

    public Boolean isCreatedByAdmin() {
        boolean bl = !this.d.isAutoCreated() && !this.d.isInternal() && !this.d.isDMQ() && !this.d.isAdmin();
        return bl;
    }

    public Boolean getCreatedByAdmin() {
        return this.isCreatedByAdmin();
    }

    public Long getDiskReserved() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getDiskReserved());
    }

    public Long getDiskUsed() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getDiskUsed());
    }

    public Integer getDiskUtilizationRatio() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getDiskUtilizationRatio());
    }

    public Long getMsgBytesIn() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessageBytesIn());
    }

    public Long getMsgBytesOut() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessageBytesOut());
    }

    public String getName() {
        return this.d.getDestinationName();
    }

    public Integer getNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getActiveConsumers());
    }

    public Integer getNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getFailoverConsumers());
    }

    public Integer getNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getNumConsumers());
    }

    public Integer getNumWildcards() throws MBeanException {
        Object object;
        Iterator iterator;
        int n = this.getNumConsumers();
        int n2 = this.getNumProducers();
        int n3 = 0;
        if (n > 0) {
            iterator = this.d.getConsumers();
            while (iterator.hasNext()) {
                object = (Consumer)iterator.next();
                if (!((Consumer)object).isWildcard()) continue;
                ++n3;
            }
        }
        if (n2 > 0) {
            iterator = this.d.getProducers();
            while (iterator.hasNext()) {
                object = (Producer)iterator.next();
                if (!((Producer)object).isWildcard()) continue;
                ++n3;
            }
        }
        return new Integer(n3);
    }

    public Integer getNumWildcardConsumers() throws MBeanException {
        return this.getNumWildcardConsumers(null);
    }

    public Integer getNumWildcardConsumers(String string) throws MBeanException {
        int n = this.getNumConsumers();
        if (n <= 0) {
            return new Integer(0);
        }
        Iterator iterator = this.d.getConsumers();
        if (iterator == null) {
            return new Integer(0);
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            if (!consumer.isWildcard()) continue;
            if (string != null) {
                DestinationUID destinationUID = consumer.getDestinationUID();
                if (!destinationUID.getName().equals(string)) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return new Integer(n2);
    }

    public Integer getNumWildcardProducers() throws MBeanException {
        return this.getNumWildcardProducers(null);
    }

    public Integer getNumWildcardProducers(String string) throws MBeanException {
        int n = this.getNumProducers();
        if (n <= 0) {
            return new Integer(0);
        }
        Iterator iterator = this.d.getProducers();
        if (iterator == null) {
            return new Integer(0);
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            Producer producer = (Producer)iterator.next();
            if (!producer.isWildcard()) continue;
            if (string != null) {
                DestinationUID destinationUID = producer.getDestinationUID();
                if (!destinationUID.getName().equals(string)) continue;
                ++n2;
                continue;
            }
            ++n2;
        }
        return new Integer(n2);
    }

    public String[] getWildcards() throws MBeanException {
        DestinationUID destinationUID;
        Object object;
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        int n = this.getNumConsumers();
        int n2 = this.getNumProducers();
        if (n > 0) {
            iterator = this.d.getConsumers();
            while (iterator.hasNext()) {
                object = (Consumer)iterator.next();
                if (!((Consumer)object).isWildcard()) continue;
                destinationUID = ((Consumer)object).getDestinationUID();
                arrayList.add(destinationUID.getName());
            }
        }
        if (n2 > 0) {
            iterator = this.d.getProducers();
            while (iterator.hasNext()) {
                object = (Producer)iterator.next();
                if (!((Producer)object).isWildcard()) continue;
                destinationUID = ((Producer)object).getDestinationUID();
                arrayList.add(destinationUID.getName());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getConsumerWildcards() throws MBeanException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        int n = this.getNumConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getConsumers();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            if (!consumer.isWildcard()) continue;
            DestinationUID destinationUID = consumer.getDestinationUID();
            arrayList.add(destinationUID.getName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getProducerWildcards() throws MBeanException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        int n = this.getNumProducers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getProducers();
        while (iterator.hasNext()) {
            Producer producer = (Producer)iterator.next();
            if (!producer.isWildcard()) continue;
            DestinationUID destinationUID = producer.getDestinationUID();
            arrayList.add(destinationUID.getName());
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public Long getNumMsgs() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nMessages - destinationInfo.nTxnMessages);
    }

    public Long getNumMsgsRemote() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nRemoteMessages);
    }

    public Long getNumMsgsHeldInTransaction() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nTxnMessages);
    }

    public Long getNumMsgsIn() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessagesIn());
    }

    public Long getNumMsgsOut() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getMessagesOut());
    }

    public Long getNumMsgsPendingAcks() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nUnackMessages);
    }

    public Integer getNumProducers() {
        return new Integer(this.d.getProducerCount());
    }

    public Long getPeakMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterLargestMsgBytes());
    }

    public Integer getPeakNumActiveConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWActiveConsumers());
    }

    public Integer getPeakNumBackupConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWFailoverConsumers());
    }

    public Integer getPeakNumConsumers() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Integer(destMetricsCounters.getHWActiveConsumers());
    }

    public Long getPeakNumMsgs() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterMessages());
    }

    public Long getPeakTotalMsgBytes() {
        DestMetricsCounters destMetricsCounters = this.d.getMetrics();
        return new Long(destMetricsCounters.getHighWaterMessageBytes());
    }

    public String getNextMessageID() {
        PacketReference packetReference = this.d.peekNext();
        if (packetReference != null) {
            return packetReference.getSysMessageID().toString();
        }
        return "";
    }

    public Integer getState() {
        return new Integer(DestinationUtil.toExternalDestState(this.d.getState()));
    }

    public String getStateLabel() {
        return DestinationState.toString(DestinationUtil.toExternalDestState(this.d.getState()));
    }

    public Boolean isTemporary() {
        return this.d.isTemporary();
    }

    public Boolean getTemporary() {
        return this.isTemporary();
    }

    public Long getTotalMsgBytes() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nMessageBytes - destinationInfo.nTxnMessageBytes);
    }

    public Long getTotalMsgBytesRemote() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nRemoteMessageBytes);
    }

    public Long getTotalMsgBytesHeldInTransaction() {
        DestinationInfo destinationInfo = DestinationUtil.getDestinationInfo(this.d);
        if (destinationInfo == null) {
            return null;
        }
        return new Long(destinationInfo.nTxnMessageBytes);
    }

    public String getType() {
        return this.d.isQueue() ? "q" : "t";
    }

    public String[] getActiveConsumerIDs() throws MBeanException {
        int n = this.getNumActiveConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getActiveConsumers().iterator();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getActiveConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getBackupConsumerIDs() throws MBeanException {
        int n = this.getNumBackupConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getFailoverConsumers().iterator();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getBackupConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public ObjectName getConnection() throws MBeanException {
        ObjectName objectName = null;
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID connectionUID = this.d.getConnectionUID();
        if (connectionUID == null) {
            return null;
        }
        try {
            objectName = MQObjectName.createConnectionMonitor(Long.toString(connectionUID.longValue()));
        }
        catch (Exception exception) {
            this.handleOperationException("getConnection", exception);
        }
        return objectName;
    }

    public String[] getConsumerIDs() throws MBeanException {
        int n = this.getNumConsumers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getConsumers();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            long l = consumer.getConsumerUID().longValue();
            try {
                String string;
                stringArray[n2] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getConsumerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String[] getProducerIDs() throws MBeanException {
        int n = this.getNumProducers();
        if (n <= 0) {
            return null;
        }
        Iterator iterator = this.d.getProducers();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            Producer producer = (Producer)iterator.next();
            long l = producer.getProducerUID().longValue();
            try {
                stringArray[n2] = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getProducerIDs", exception);
            }
            ++n2;
        }
        return stringArray;
    }

    public String getMBeanName() {
        return "DestinationMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1134");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationCompact() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.compact", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPause(String string) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.pause", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        destinationNotification.setPauseType(string);
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPurge() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.purge", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationResume() {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.resume", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(this.getName());
        destinationNotification.setDestinationType(this.getType());
        this.sendNotification(destinationNotification);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[40];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("AvgNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1090"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("AvgNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1091"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("AvgNumConsumers", Integer.class.getName(), mbr.getString("MB1092"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("AvgNumMsgs", Long.class.getName(), mbr.getString("MB1093"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("AvgTotalMsgBytes", Long.class.getName(), mbr.getString("MB1094"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("ConnectionID", String.class.getName(), mbr.getString("MB1095"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("CreatedByAdmin", Boolean.class.getName(), mbr.getString("MB1096"), true, false, true);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("DiskReserved", Long.class.getName(), mbr.getString("MB1097"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("DiskUsed", Long.class.getName(), mbr.getString("MB1098"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("DiskUtilizationRatio", Integer.class.getName(), mbr.getString("MB1099"), true, false, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1100"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("MsgBytesOut", Long.class.getName(), mbr.getString("MB1101"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1087"), true, false, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("NumActiveConsumers", Integer.class.getName(), mbr.getString("MB1102"), true, false, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("NumBackupConsumers", Integer.class.getName(), mbr.getString("MB1103"), true, false, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1104"), true, false, false);
        mBeanAttributeInfoArray[16] = new MBeanAttributeInfo("NumWildcards", Integer.class.getName(), mbr.getString("MB1243"), true, false, false);
        mBeanAttributeInfoArray[17] = new MBeanAttributeInfo("NumWildcardConsumers", Integer.class.getName(), mbr.getString("MB1244"), true, false, false);
        mBeanAttributeInfoArray[18] = new MBeanAttributeInfo("NumWildcardProducers", Integer.class.getName(), mbr.getString("MB1245"), true, false, false);
        mBeanAttributeInfoArray[19] = new MBeanAttributeInfo("NumMsgs", Long.class.getName(), mbr.getString("MB1105"), true, false, false);
        mBeanAttributeInfoArray[20] = new MBeanAttributeInfo("NumMsgsRemote", Long.class.getName(), mbr.getString("MB1262"), true, false, false);
        mBeanAttributeInfoArray[21] = new MBeanAttributeInfo("NumMsgsHeldInTransaction", Long.class.getName(), mbr.getString("MB1106"), true, false, false);
        mBeanAttributeInfoArray[22] = new MBeanAttributeInfo("NumMsgsIn", Long.class.getName(), mbr.getString("MB1107"), true, false, false);
        mBeanAttributeInfoArray[23] = new MBeanAttributeInfo("NumMsgsOut", Long.class.getName(), mbr.getString("MB1108"), true, false, false);
        mBeanAttributeInfoArray[24] = new MBeanAttributeInfo("NumMsgsPendingAcks", Long.class.getName(), mbr.getString("MB1109"), true, false, false);
        mBeanAttributeInfoArray[25] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1110"), true, false, false);
        mBeanAttributeInfoArray[26] = new MBeanAttributeInfo("PeakMsgBytes", Long.class.getName(), mbr.getString("MB1111"), true, false, false);
        mBeanAttributeInfoArray[27] = new MBeanAttributeInfo("PeakNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1112"), true, false, false);
        mBeanAttributeInfoArray[28] = new MBeanAttributeInfo("PeakNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1113"), true, false, false);
        mBeanAttributeInfoArray[29] = new MBeanAttributeInfo("PeakNumConsumers", Integer.class.getName(), mbr.getString("MB1114"), true, false, false);
        mBeanAttributeInfoArray[30] = new MBeanAttributeInfo("PeakNumMsgs", Long.class.getName(), mbr.getString("MB1115"), true, false, false);
        mBeanAttributeInfoArray[31] = new MBeanAttributeInfo("PeakTotalMsgBytes", Long.class.getName(), mbr.getString("MB1116"), true, false, false);
        mBeanAttributeInfoArray[32] = new MBeanAttributeInfo("NextMessageID", String.class.getName(), mbr.getString("MB1266"), true, false, false);
        mBeanAttributeInfoArray[33] = new MBeanAttributeInfo("State", Integer.class.getName(), mbr.getString("MB1117"), true, false, false);
        mBeanAttributeInfoArray[34] = new MBeanAttributeInfo("StateLabel", String.class.getName(), mbr.getString("MB1118"), true, false, false);
        mBeanAttributeInfoArray[35] = new MBeanAttributeInfo("Temporary", Boolean.class.getName(), mbr.getString("MB1119"), true, false, true);
        mBeanAttributeInfoArray[36] = new MBeanAttributeInfo("TotalMsgBytes", Long.class.getName(), mbr.getString("MB1120"), true, false, false);
        mBeanAttributeInfoArray[37] = new MBeanAttributeInfo("TotalMsgBytesRemote", Long.class.getName(), mbr.getString("MB1263"), true, false, false);
        mBeanAttributeInfoArray[38] = new MBeanAttributeInfo("TotalMsgBytesHeldInTransaction", Long.class.getName(), mbr.getString("MB1121"), true, false, false);
        mBeanAttributeInfoArray[39] = new MBeanAttributeInfo("Type", String.class.getName(), mbr.getString("MB1088"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1251"));
        numWildcardConsumersSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1252"));
        numWildcardProducersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[10];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getActiveConsumerIDs", mbr.getString("MB1128"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBackupConsumerIDs", mbr.getString("MB1129"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getConnection", mbr.getString("MB1130"), null, ObjectName.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1131"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1132"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("getWildcards", mbr.getString("MB1246"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("getConsumerWildcards", mbr.getString("MB1247"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("getNumWildcardConsumers", mbr.getString("MB1248"), numWildcardConsumersSignature, Integer.class.getName(), 0);
        mBeanOperationInfoArray[8] = new MBeanOperationInfo("getProducerWildcards", mbr.getString("MB1249"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[9] = new MBeanOperationInfo("getNumWildcardProducers", mbr.getString("MB1250"), numWildcardProducersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        dstNotificationTypes = new String[]{"mq.destination.compact", "mq.destination.pause", "mq.destination.purge", "mq.destination.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(dstNotificationTypes, DestinationNotification.class.getName(), mbr.getString("MB1133"));
        notifs = mBeanNotificationInfoArray;
    }
}

