/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.ext;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ext.JMSBGDAO;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMSBGDAOImpl
extends BaseDAOImpl
implements JMSBGDAO {
    private String tableName = null;
    protected String insertSQL;
    protected String updateBrokerIdSQL;
    protected String deleteSQL;
    protected String selectBrokerIdSQL;
    protected String selectUpdatedTimeSQL;
    protected String selectCreatedTimeSQL;
    protected String selectNamesByBrokerIdSQL;

    public JMSBGDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQJMSBG41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("NAME").append(", ").append("BROKER_ID").append(", ").append("CREATED_TS").append(", ").append("UPDATED_TS").append(") VALUES ( ?, ?, ?, ?)").toString();
        this.updateBrokerIdSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?, ").append("UPDATED_TS").append(" = ? ").append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").append(Util.brokerNotTakenOverClause(dBManager)).toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").append(" AND ").append("BROKER_ID").append(" = ?").toString();
        this.selectBrokerIdSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectUpdatedTimeSQL = new StringBuffer(128).append("SELECT ").append("UPDATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectCreatedTimeSQL = new StringBuffer(128).append("SELECT ").append("CREATED_TS").append(" FROM ").append(this.tableName).append(" WHERE ").append("NAME").append(" = ?").toString();
        this.selectNamesByBrokerIdSQL = new StringBuffer(128).append("SELECT ").append("NAME").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQJMSBG41";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, String string, Logger logger) throws DupKeyException, Exception {
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        try {
            DBManager dBManager = DBManager.getDBManager();
            if (connection == null) {
                connection2 = connection = dBManager.getConnection(true);
            }
            try {
                preparedStatement = connection.prepareStatement(this.insertSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, dBManager.getBrokerID());
                preparedStatement.setLong(3, System.currentTimeMillis());
                preparedStatement.setLong(4, 0L);
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    String string2 = "B4080";
                    this.logger.log(32, string2, sQLException);
                    Util.logExt(logger, Level.SEVERE, string2, sQLException);
                }
                this.checkDupKeyOnException(connection, string, logger);
                throw exception;
            }
            Object var11_10 = null;
            this.closeSQL(null, preparedStatement, connection2, logger);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.closeSQL(null, preparedStatement, connection2, logger);
            throw throwable;
        }
    }

    public void updateBrokerId(Connection connection, String string, String string2, String string3, Logger logger) throws KeyNotFoundException, StoreBeingTakenOverException, Exception {
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.updateBrokerIdSQL);
                preparedStatement.setString(1, string2);
                preparedStatement.setLong(2, System.currentTimeMillis());
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, string3);
                if (Globals.getHAEnabled()) {
                    preparedStatement.setString(5, dBManager.getBrokerID());
                }
                if (preparedStatement.executeUpdate() == 0) {
                    Util.checkBeingTakenOver(connection, dBManager, this.logger, logger);
                    throw new KeyNotFoundException("Name " + string + " not found in store");
                }
                Object var12_10 = null;
                this.closeSQL(null, preparedStatement, connection2, logger);
            }
            catch (Exception exception) {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    String string4 = "B4080";
                    this.logger.log(32, string4, sQLException);
                    Util.logExt(logger, Level.SEVERE, string4, sQLException);
                }
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.closeSQL(null, preparedStatement, connection2, logger);
            throw throwable;
        }
    }

    public void delete(Connection connection, String string, Logger logger) throws Exception {
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                DBManager dBManager = DBManager.getDBManager();
                if (connection == null) {
                    connection2 = connection = dBManager.getConnection(true);
                }
                preparedStatement = connection.prepareStatement(this.deleteSQL);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, dBManager.getBrokerID());
                if (preparedStatement.executeUpdate() == 0) {
                    throw new KeyNotFoundException("Name " + string + " not found in store ");
                }
                Object var10_8 = null;
                this.closeSQL(null, preparedStatement, connection2, logger);
            }
            catch (Exception exception) {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    String string2 = "B4080";
                    this.logger.log(32, string2, sQLException);
                    Util.logExt(logger, Level.SEVERE, string2, sQLException);
                }
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.closeSQL(null, preparedStatement, connection2, logger);
            throw throwable;
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = new StringBuffer(128).append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("'").toString();
        this.deleteAll(connection, string, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBrokerId(Connection connection, String string, Logger logger) throws Exception {
        String string2 = null;
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (connection == null) {
                connection2 = connection = DBManager.getDBManager().getConnection(true);
            }
            preparedStatement = connection.prepareStatement(this.selectBrokerIdSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new KeyNotFoundException("Name " + string + " not found in store");
            }
            string2 = resultSet.getString(1);
            Object var9_8 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
            throw throwable;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdatedTime(Connection connection, String string, Logger logger) throws KeyNotFoundException, Exception {
        long l = -1L;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (connection == null) {
                connection2 = connection = DBManager.getDBManager().getConnection(true);
            }
            preparedStatement = connection.prepareStatement(this.selectUpdatedTimeSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new KeyNotFoundException("Name " + string + " not found in store");
            }
            l = resultSet.getLong(1);
            Object var10_8 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreatedTime(Connection connection, String string, Logger logger) throws KeyNotFoundException, Exception {
        long l = -1L;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (connection == null) {
                connection2 = connection = DBManager.getDBManager().getConnection(true);
            }
            preparedStatement = connection.prepareStatement(this.selectCreatedTimeSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new KeyNotFoundException("Name " + string + " not found in store");
            }
            l = resultSet.getLong(1);
            Object var10_8 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNamesByBroker(Connection connection, String string, Logger logger) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBManager dBManager = DBManager.getDBManager();
            if (connection == null) {
                connection2 = connection = DBManager.getDBManager().getConnection(true);
            }
            preparedStatement = connection.prepareStatement(this.selectNamesByBrokerIdSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            Object var10_9 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.closeSQL(resultSet, preparedStatement, connection2, logger);
            throw throwable;
        }
        return arrayList;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("JMSBridge(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    private void checkDupKeyOnException(Connection connection, String string, Logger logger) throws DupKeyException {
        if (connection == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.selectCreatedTimeSQL);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                throw new DupKeyException("Name " + string + " already exists in DB");
            }
        }
        catch (Exception exception) {
            if (exception instanceof DupKeyException) {
                throw (DupKeyException)exception;
            }
            String string2 = this.br.getKString("B4117", "Exception on checkDupKey for name " + string);
            this.logger.log(16, string2, exception);
            Util.logExt(logger, Level.WARNING, string2, exception);
        }
    }

    private void closeSQL(ResultSet resultSet, PreparedStatement preparedStatement, Connection connection, Logger logger) {
        try {
            Util.close(resultSet, preparedStatement, connection);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            String string = "Unable to close SQL connection or statement: " + exception.getMessage() + (throwable == null ? "" : " - " + throwable.getMessage());
            this.logger.log(16, string, exception);
            Util.logExt(logger, Level.WARNING, string, exception);
        }
    }
}

