/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private final HashMap<Locale, ResourceBundle> bundles = new HashMap(5);
    private String bundleName = null;
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        this.bundleName = packageName + ".LocalStrings";
    }

    public String getString(String key) {
        return this.getString(key, Locale.getDefault());
    }

    public String getString(String key, Locale locale) {
        return MessageFormat.format(this.getStringInternal(key, locale), null);
    }

    protected String getStringInternal(String key) {
        return this.getStringInternal(key, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringInternal(String key, Locale locale) {
        if (key == null) {
            String msg = "key is null";
            throw new NullPointerException(msg);
        }
        ResourceBundle bundle = this.bundles.get(locale);
        if (bundle == null) {
            HashMap<Locale, ResourceBundle> hashMap = this.bundles;
            synchronized (hashMap) {
                bundle = this.bundles.get(locale);
                if (bundle == null) {
                    bundle = ResourceBundle.getBundle(this.bundleName, locale, this.getClass().getClassLoader());
                    this.bundles.put(locale, bundle);
                }
            }
        }
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return "Cannot find message associated with key '" + key + "'";
        }
    }

    public String getString(String key, Object[] args) {
        return this.getString(key, args, Locale.getDefault());
    }

    public String getString(String key, Object[] args, Locale locale) {
        String iString = null;
        String value = this.getStringInternal(key, locale);
        try {
            Object[] nonNullArgs = args;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                if (nonNullArgs == args) {
                    nonNullArgs = (Object[])args.clone();
                }
                nonNullArgs[i] = "null";
            }
            iString = MessageFormat.format(value, nonNullArgs);
        }
        catch (IllegalArgumentException iae) {
            StringBuffer buf = new StringBuffer();
            buf.append(value);
            for (int i = 0; i < args.length; ++i) {
                buf.append(" arg[" + i + "]=" + args[i]);
            }
            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        return this.getString(key, arg, Locale.getDefault());
    }

    public String getString(String key, Object arg, Locale locale) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args, locale);
    }

    public String getString(String key, Object arg1, Object arg2) {
        return this.getString(key, arg1, arg2, Locale.getDefault());
    }

    public String getString(String key, Object arg1, Object arg2, Locale locale) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args, locale);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getString(key, arg1, arg2, arg3, Locale.getDefault());
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Locale locale) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args, locale);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getString(key, arg1, arg2, arg3, arg4, Locale.getDefault());
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Locale locale) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getResourceBundleLocale(Locale requestLocale) {
        ResourceBundle bundle = this.bundles.get(requestLocale);
        if (bundle == null) {
            HashMap<Locale, ResourceBundle> hashMap = this.bundles;
            synchronized (hashMap) {
                bundle = this.bundles.get(requestLocale);
                if (bundle == null) {
                    bundle = ResourceBundle.getBundle(this.bundleName, requestLocale);
                    this.bundles.put(requestLocale, bundle);
                }
            }
        }
        return bundle.getLocale();
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            managers.put(packageName, mgr);
        }
        return mgr;
    }
}

