/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.tomcat.util.modeler.BaseAttributeFilter;
import org.apache.tomcat.util.modeler.BaseNotificationBroadcasterEntry;
import org.apache.tomcat.util.modeler.FixedNotificationFilter;
import org.apache.tomcat.util.modeler.Registry;

public class BaseNotificationBroadcaster
implements NotificationBroadcaster {
    protected ArrayList<BaseNotificationBroadcasterEntry> entries = new ArrayList();
    NotificationListener[][] hooks = new NotificationListener[20][];
    int[] hookCount = new int[20];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        ArrayList<BaseNotificationBroadcasterEntry> arrayList = this.entries;
        synchronized (arrayList) {
            if (filter instanceof BaseAttributeFilter) {
                BaseAttributeFilter newFilter = (BaseAttributeFilter)filter;
                for (BaseNotificationBroadcasterEntry item : this.entries) {
                    if (item.listener != listener || item.filter == null || !(item.filter instanceof BaseAttributeFilter) || item.handback != handback) continue;
                    BaseAttributeFilter oldFilter = (BaseAttributeFilter)item.filter;
                    String[] newNames = newFilter.getNames();
                    String[] oldNames = oldFilter.getNames();
                    if (newNames.length == 0) {
                        oldFilter.clear();
                    } else if (oldNames.length != 0) {
                        for (int i = 0; i < newNames.length; ++i) {
                            oldFilter.addAttribute(newNames[i]);
                        }
                    }
                    return;
                }
            }
            this.entries.add(new BaseNotificationBroadcasterEntry(listener, filter, handback));
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        ArrayList<BaseNotificationBroadcasterEntry> arrayList = this.entries;
        synchronized (arrayList) {
            Iterator<BaseNotificationBroadcasterEntry> items = this.entries.iterator();
            while (items.hasNext()) {
                BaseNotificationBroadcasterEntry item = items.next();
                if (item.listener != listener) continue;
                items.remove();
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeNotificationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Notification notification) {
        ArrayList<BaseNotificationBroadcasterEntry> arrayList = this.entries;
        synchronized (arrayList) {
            for (BaseNotificationBroadcasterEntry item : this.entries) {
                if (item.filter != null && !item.filter.isNotificationEnabled(notification)) continue;
                item.listener.handleNotification(notification, item.handback);
            }
        }
    }

    private synchronized void registerNotifications(FixedNotificationFilter filter) {
        String[] names = filter.getNames();
        Registry reg = Registry.getRegistry(null, null);
        for (int i = 0; i < names.length; ++i) {
            int code = reg.getId(null, names[i]);
            if (this.hooks.length < code) {
                throw new RuntimeException("Too many hooks " + code);
            }
            NotificationListener[] listeners = this.hooks[code];
            if (listeners != null) continue;
        }
    }
}

