/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable")
@I18n(value="disable.command")
@Scoped(value=PerLookup.class)
public class DisableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DisableCommand.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Deployment deployment;
    @Inject(name="default-instance-name")
    protected Server server;

    public DisableCommand() {
        this.origin = OpsParams.Origin.unload;
    }

    public void execute(AdminCommandContext context) {
        block7: {
            ActionReport report = context.getActionReport();
            Logger logger = context.getLogger();
            if (!this.deployment.isRegistered(this.name())) {
                report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)this.target, (String)this.name())).booleanValue()) {
                logger.fine("The application is already disabled");
                return;
            }
            ApplicationInfo appInfo = this.deployment.get(this.name());
            try {
                UndeployCommandParameters commandParams = new UndeployCommandParameters();
                commandParams.origin = this.origin;
                commandParams.name = this.name();
                ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(appInfo.getSource()).build();
                ApplicationName module = ConfigBeansUtilities.getModule((String)this.name());
                Application application = null;
                if (module instanceof Application) {
                    application = (Application)module;
                }
                if (application != null) {
                    deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
                    deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
                }
                appInfo.stop(deploymentContext, deploymentContext.getLogger());
                appInfo.unload(deploymentContext);
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) break block7;
                for (ApplicationRef ref : this.server.getApplicationRef()) {
                    if (!ref.getRef().equals(this.name())) continue;
                    ConfigSupport.apply(new SingleConfigCode<ApplicationRef>(){

                        @Override
                        public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                            param.setEnabled(String.valueOf(false));
                            return null;
                        }
                    }, ref);
                    break;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error during disabling: ", e);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(e.getMessage());
            }
        }
    }
}

