/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.spi.component;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractResourceConstructor;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.inject.ServerInjectableProviderContext;
import com.sun.jersey.server.spi.component.ResourceComponentInjector;
import com.sun.jersey.spi.inject.Injectable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceComponentConstructor {
    private final Class c;
    private final ResourceComponentInjector rci;
    private final Constructor constructor;
    private final Method postConstruct;
    private final List<AbstractHttpContextInjectable> injectables;
    private static final Map<Class, Object> DEFAULT_VALUES = ResourceComponentConstructor.createDefaultValues();

    public ResourceComponentConstructor(ServerInjectableProviderContext sipc, ComponentScope scope, AbstractResource ar) {
        this.c = ar.getResourceClass();
        this.rci = new ResourceComponentInjector(sipc, scope, ar);
        this.postConstruct = ar.getPostConstructMethods().size() > 0 ? ar.getPostConstructMethods().get(0) : null;
        ConstructorInjectablePair cip = this.getConstructor(sipc, scope, ar);
        if (cip == null || cip.is.size() == 0) {
            this.constructor = null;
            this.injectables = null;
        } else {
            this.constructor = cip.con;
            this.injectables = AbstractHttpContextInjectable.transform(cip.is);
            Class<?>[] types = this.constructor.getParameterTypes();
            for (int i = 0; i < this.injectables.size(); ++i) {
                Object defaultValue;
                if (this.injectables.get(i) != null || (defaultValue = DEFAULT_VALUES.get(types[i])) == null) continue;
                this.injectables.set(i, new AbstractHttpContextInjectable(){

                    public Object getValue(HttpContext c) {
                        return defaultValue;
                    }
                });
            }
        }
    }

    public Object construct(HttpContext hc) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o = this._construct(hc);
        this.rci.inject(hc, o);
        if (this.postConstruct != null) {
            this.postConstruct.invoke(o, new Object[0]);
        }
        return o;
    }

    public Object _construct(HttpContext hc) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.constructor == null) {
            return this.c.newInstance();
        }
        Object[] params = new Object[this.injectables.size()];
        int i = 0;
        for (AbstractHttpContextInjectable injectable : this.injectables) {
            params[i++] = injectable != null ? injectable.getValue(hc) : null;
        }
        return this.constructor.newInstance(params);
    }

    private <T> ConstructorInjectablePair getConstructor(ServerInjectableProviderContext sipc, ComponentScope scope, AbstractResource ar) {
        if (ar.getConstructors().isEmpty()) {
            return null;
        }
        TreeSet<ConstructorInjectablePair> cs = new TreeSet<ConstructorInjectablePair>(new ConstructorComparator());
        for (AbstractResourceConstructor arc : ar.getConstructors()) {
            List<Injectable> is = sipc.getInjectable(arc.getParameters(), scope);
            cs.add(new ConstructorInjectablePair(arc.getCtor(), is));
        }
        return (ConstructorInjectablePair)cs.first();
    }

    private static Map<Class, Object> createDefaultValues() {
        HashMap<Class, Object> defaultValues = new HashMap<Class, Object>();
        defaultValues.put(Byte.TYPE, (byte)0);
        defaultValues.put(Short.TYPE, (short)0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Long.TYPE, 0L);
        defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValues.put(Double.TYPE, 0.0);
        defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValues.put(Boolean.TYPE, Boolean.FALSE);
        return defaultValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorComparator<T>
    implements Comparator<ConstructorInjectablePair> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(ConstructorInjectablePair o1, ConstructorInjectablePair o2) {
            int p = Collections.frequency(o1.is, null) - Collections.frequency(o2.is, null);
            if (p != 0) {
                return p;
            }
            return o2.con.getParameterTypes().length - o1.con.getParameterTypes().length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorInjectablePair {
        private final Constructor con;
        private final List<Injectable> is;

        private ConstructorInjectablePair(Constructor con, List<Injectable> is) {
            this.con = con;
            this.is = is;
        }
    }
}

