/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.ClientJarMaker;
import org.glassfish.internal.api.Globals;

class ClientJarMakerImpl
implements ClientJarMaker {
    protected Properties props;

    public ClientJarMakerImpl(Properties props) {
        this.props = props;
    }

    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        this.create(descriptor, source, source, target, stubs, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(RootDeploymentDescriptor descriptor, ReadableArchive source, ReadableArchive source2, WritableArchive target, ZipItem[] stubs, Properties props) throws IOException {
        ArchivistFactory archivistFactory = Globals.getDefaultHabitat().getComponent(ArchivistFactory.class);
        HashSet<String> elements = new HashSet<String>();
        for (int i = 0; i < stubs.length; ++i) {
            ZipItem item = stubs[i];
            if (elements.contains(item.getName())) continue;
            elements.add(item.getName());
            OutputStream os = null;
            InputStream is = null;
            try {
                os = target.putNextEntry(item.getName());
                is = new BufferedInputStream(new FileInputStream(item.getFile()));
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
                continue;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    target.closeEntry();
                }
            }
        }
        Vector<String> moduleNames = new Vector<String>();
        if (descriptor.isApplication()) {
            Application app = (Application)descriptor;
            for (ModuleDescriptor<BundleDescriptor> md : app.getModules()) {
                Archivist moduleArchivist = archivistFactory.getArchivist(md.getModuleType());
                ReadableArchive subSource = source.getSubArchive(md.getArchiveUri());
                ReadableArchive subSource2 = source2.getSubArchive(md.getArchiveUri());
                moduleNames.add(md.getArchiveUri());
                Vector<String> subEntries = new Vector<String>();
                subEntries.add("META-INF/MANIFEST.MF");
                BundleDescriptor subBundleDesc = md.getDescriptor();
                WebServicesDescriptor wsd = subBundleDesc.getWebServices();
                if (wsd != null) {
                    for (WebService ws : wsd.getWebServices()) {
                        subEntries.add(ws.getMappingFileUri());
                    }
                }
                Set refs = subBundleDesc.getServiceReferenceDescriptors();
                for (ServiceReferenceDescriptor srd : refs) {
                    subEntries.add(srd.getMappingFileUri());
                }
                ArrayList<String> embeddedFiles = new ArrayList<String>();
                Enumeration e = subSource.entries();
                while (e.hasMoreElements()) {
                    String entryName = (String)e.nextElement();
                    if (entryName.endsWith(".xml") || subEntries.contains(entryName) || entryName.startsWith(subBundleDesc.getWsdlDir())) {
                        embeddedFiles.add(entryName);
                        continue;
                    }
                    try {
                        this.copy(subSource, target, entryName);
                    }
                    catch (IOException ioe) {}
                }
                WritableArchive subTarget = target.createSubArchive(md.getArchiveUri());
                for (String entryName : embeddedFiles) {
                    this.copyWithOverride(subSource, subSource2, subTarget, entryName);
                }
                this.copy(subSource, subSource2, subTarget, moduleArchivist.getStandardDDFile().getDeploymentDescriptorPath(), embeddedFiles);
                if (moduleArchivist.getConfigurationDDFile() != null) {
                    this.copy(subSource, subSource2, subTarget, moduleArchivist.getConfigurationDDFile().getDeploymentDescriptorPath(), embeddedFiles);
                }
                this.copy(subSource, subTarget, "META-INF/MANIFEST.MF");
                target.closeEntry(subTarget);
                subSource.close();
                subSource2.close();
            }
        }
        Archivist archivist = archivistFactory.getArchivist(descriptor.getModuleType());
        String appClientFileName = target.getURI().getSchemeSpecificPart().substring(target.getURI().getSchemeSpecificPart().lastIndexOf(File.separatorChar) + 1);
        this.copy(source, target, "META-INF/MANIFEST.MF");
        ArrayList<String> xmlFiles = new ArrayList<String>();
        String libDir = this.computeLibraryDirectory(descriptor);
        Enumeration e = ((FileArchive)source).entries(moduleNames.elements());
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (entryName.equals(appClientFileName)) continue;
            if (entryName.endsWith(".jar") && !this.inLibDirSubdirectory(libDir, entryName)) {
                ReadableArchive subSource = null;
                try {
                    subSource = source.getSubArchive(entryName);
                    Enumeration subEntries = subSource.entries();
                    while (subEntries.hasMoreElements()) {
                        String subEntryName = (String)subEntries.nextElement();
                        if ("META-INF/persistence.xml".equals(subEntryName)) continue;
                        this.copy(subSource, target, subEntryName);
                    }
                    continue;
                }
                finally {
                    if (subSource != null) {
                        subSource.close();
                    }
                    continue;
                }
            }
            if (entryName.endsWith(".xml")) {
                xmlFiles.add(entryName);
            }
            this.copyWithOverride(source, source2, target, entryName);
        }
        this.copy(source, source2, target, archivist.getStandardDDFile().getDeploymentDescriptorPath(), xmlFiles);
        this.copy(source, source2, target, archivist.getConfigurationDDFile().getDeploymentDescriptorPath(), xmlFiles);
    }

    private void copy(ReadableArchive source, ReadableArchive source2, WritableArchive target, String fileEntryName, List xmlFiles) throws IOException {
        if (!xmlFiles.contains(fileEntryName)) {
            this.copyWithOverride(source, source2, target, fileEntryName);
        }
    }

    private void copy(ReadableArchive source, WritableArchive target, String entryName) throws IOException {
        block20: {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = source.getEntry(entryName);
                if (is == null) break block20;
                try {
                    os = target.putNextEntry(entryName);
                }
                catch (ZipException ze) {
                    IOException closeEntryIOException = null;
                    if (os != null) {
                        try {
                            target.closeEntry();
                        }
                        catch (IOException ioe) {
                            closeEntryIOException = ioe;
                        }
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (closeEntryIOException != null) {
                        throw closeEntryIOException;
                    }
                    return;
                }
                ArchivistUtils.copyWithoutClose((InputStream)is, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                IOException closeEntryIOException = null;
                if (os != null) {
                    try {
                        target.closeEntry();
                    }
                    catch (IOException ioe) {
                        closeEntryIOException = ioe;
                    }
                }
                if (is != null) {
                    is.close();
                }
                if (closeEntryIOException != null) {
                    throw closeEntryIOException;
                }
            }
        }
    }

    private void copyWithOverride(ReadableArchive normalSource, ReadableArchive overridingSource, WritableArchive target, String entryName) throws IOException {
        boolean result;
        InputStream is = overridingSource.getEntry(entryName);
        boolean bl = result = is != null;
        if (is != null) {
            is.close();
            this.copy(overridingSource, target, entryName);
        } else {
            this.copy(normalSource, target, entryName);
        }
    }

    private String computeLibraryDirectory(RootDeploymentDescriptor d) {
        String result = null;
        if (d instanceof Application) {
            result = ((Application)d).getLibraryDirectory();
        }
        return result;
    }

    private boolean inLibDirSubdirectory(String libDir, String entryName) {
        boolean result = false;
        if (libDir != null && entryName.startsWith(libDir)) {
            String restOfPath = entryName.substring(libDir.length() + 1);
            result = restOfPath.contains("/");
        }
        return result;
    }
}

