/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInjectionTarget<T>
implements InjectionTarget<T> {
    private final BeanManagerImpl beanManager;
    private final WeldClass<T> type;
    private final ConstructorInjectionPoint<T> constructor;
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private final WeldMethod<?, ?> postConstruct;
    private final WeldMethod<?, ?> preDestroy;
    private final Set<InjectionPoint> injectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;

    public SimpleInjectionTarget(WeldClass<T> type, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.type = type;
        this.injectionPoints = new HashSet<InjectionPoint>();
        ConstructorInjectionPoint<T> constructor = null;
        try {
            constructor = Beans.getBeanConstructor(null, type);
            this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, constructor));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.constructor = constructor;
        this.injectableFields = Beans.getFieldInjectionPoints(null, type);
        this.injectionPoints.addAll(Beans.getFieldInjectionPoints(null, this.injectableFields));
        this.initializerMethods = Beans.getInitializerMethods(null, type);
        this.injectionPoints.addAll(Beans.getParameterInjectionPoints(null, this.initializerMethods));
        this.postConstruct = Beans.getPostConstruct(type);
        this.preDestroy = Beans.getPreDestroy(type);
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(null, type, beanManager);
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(null, type, beanManager);
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(null, type, beanManager);
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(null, type, beanManager);
        for (InjectionPoint ip : this.injectionPoints) {
            if (!ip.getType().equals(InjectionPoint.class)) continue;
            throw new DefinitionException("Cannot inject an InjectionPoint on a non-contextual type. Type: " + type + "; InjectionPoint: " + ip);
        }
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        if (this.constructor == null) {
            Beans.getBeanConstructor(null, this.type);
            throw new IllegalStateException("We were not previously able to find the bean constructor, but now are?");
        }
        return this.constructor.newInstance(this.beanManager, ctx);
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.beanManager, this, instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(instance, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.ejbInjectionPoints, SimpleInjectionTarget.this.persistenceContextInjectionPoints, SimpleInjectionTarget.this.persistenceUnitInjectionPoints, SimpleInjectionTarget.this.resourceInjectionPoints);
                Beans.injectFieldsAndInitializers(instance, ctx, SimpleInjectionTarget.this.beanManager, SimpleInjectionTarget.this.injectableFields, SimpleInjectionTarget.this.initializerMethods);
            }
        }.run();
    }

    @Override
    public void postConstruct(T instance) {
        if (this.postConstruct == null) {
            return;
        }
        try {
            this.postConstruct.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking postConstruct() " + this.postConstruct, e);
        }
    }

    @Override
    public void preDestroy(T instance) {
        if (this.preDestroy == null) {
            return;
        }
        try {
            this.preDestroy.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking preDestroy() " + this.preDestroy, e);
        }
    }

    @Override
    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }
}

