/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.ConcurrentMethodDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.TimeoutValueDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.ejb.TimeoutValueNode;
import org.w3c.dom.Node;

public class ConcurrentMethodNode
extends DeploymentDescriptorNode {
    ConcurrentMethodDescriptor descriptor = null;
    private static final String READ_LOCK = "Read";
    private static final String WRITE_LOCK = "Write";

    public ConcurrentMethodNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class, "setConcurrentMethod");
        this.registerElementHandler(new XMLElement("access-timeout"), TimeoutValueNode.class, "setAccessTimeout");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ConcurrentMethodDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("lock".equals(element.getQName())) {
            this.descriptor.setWriteLock(value.equals(WRITE_LOCK));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, Descriptor descriptor) {
        if (!(descriptor instanceof ConcurrentMethodDescriptor)) {
            throw new IllegalArgumentException(this.getClass() + " cannot handles descriptors of type " + descriptor.getClass());
        }
        ConcurrentMethodDescriptor desc = (ConcurrentMethodDescriptor)descriptor;
        Node concurrentNode = super.writeDescriptor(parent, nodeName, descriptor);
        MethodNode methodNode = new MethodNode();
        methodNode.writeJavaMethodDescriptor(concurrentNode, "method", desc.getConcurrentMethod());
        if (desc.hasLockMetadata()) {
            String lockType = desc.isWriteLocked() ? WRITE_LOCK : READ_LOCK;
            ConcurrentMethodNode.appendTextChild(concurrentNode, "lock", lockType);
        }
        if (desc.hasAccessTimeout()) {
            TimeoutValueNode timeoutValueNode = new TimeoutValueNode();
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(desc.getAccessTimeoutValue());
            timeoutDesc.setUnit(desc.getAccessTimeoutUnit());
            timeoutValueNode.writeDescriptor(concurrentNode, "access-timeout", timeoutDesc);
        }
        return concurrentNode;
    }
}

