/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ejb;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodPermissionDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class MethodPermissionNode
extends DeploymentDescriptorNode {
    private MethodPermissionDescriptor descriptor;

    public MethodPermissionNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class, "addMethod");
    }

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (MethodPermissionDescriptor)DescriptorFactory.getDescriptor(this.getXMLPath());
        }
        return this.descriptor;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if ("unchecked".equals(element.getQName())) {
            this.descriptor.addMethodPermission(MethodPermission.getUncheckedMethodPermission());
        } else {
            super.startElement(element, attributes);
        }
    }

    public void setElementValue(XMLElement element, String value) {
        if ("role-name".equals(element.getQName())) {
            Role role = new Role(value);
            this.descriptor.addMethodPermission(new MethodPermission(role));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, MethodPermissionDescriptor descriptor, EjbDescriptor ejb) {
        Node subNode = super.writeDescriptor(parent, nodeName, descriptor);
        return this.writeDescriptorInNode(subNode, descriptor, ejb);
    }

    public Node writeDescriptorInNode(Node subNode, MethodPermissionDescriptor descriptor, EjbDescriptor ejb) {
        this.writeLocalizedDescriptions(subNode, descriptor);
        MethodPermission[] mps = descriptor.getMethodPermissions();
        if (mps.length == 0) {
            return null;
        }
        if (!mps[0].isExcluded()) {
            if (mps[0].isUnchecked()) {
                MethodPermissionNode.appendChild(subNode, "unchecked");
            } else {
                for (int i = 0; i < mps.length; ++i) {
                    MethodPermissionNode.appendTextChild(subNode, "role-name", mps[i].getRole().getName());
                }
            }
        }
        MethodDescriptor[] methods = descriptor.getMethods();
        MethodNode mn = new MethodNode();
        for (int i = 0; i < methods.length; ++i) {
            String ejbName = ejb.getName();
            mn.writeDescriptor(subNode, "method", methods[i], ejbName);
        }
        return subNode;
    }
}

