/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration.impl;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationAccountConfig;
import com.sun.enterprise.registration.RegistrationAccountFactory;
import com.sun.enterprise.registration.RegistrationDescriptor;
import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.RegistrationServiceConfig;
import com.sun.enterprise.registration.RegistrationServiceFactory;
import com.sun.enterprise.registration.impl.RepositoryManager;
import com.sun.enterprise.registration.impl.SOAccount;
import com.sun.enterprise.registration.impl.ServiceTag;
import com.sun.enterprise.registration.impl.SysnetRegistrationService;
import com.sun.enterprise.registration.impl.SysnetTransferManager;
import java.io.File;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class Test {
    public static void main(String[] args) {
        try {
            Test.testRegistration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testRegistration() {
        try {
            System.out.println("registering...");
            Object[] params = new Object[]{Test.getRepositoryFile(), "glassfish:test"};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.SysnetRegistrationService", params);
            RegistrationService regService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            List<RegistrationDescriptor> l = regService.getRegistrationDescriptors();
            for (RegistrationDescriptor ri : l) {
                System.out.println(ri.getProductName() + " " + ri.getInstanceURN());
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userID", "replaceme");
            map.put("password", "replaceme");
            Object[] accountParams = new Object[]{map};
            RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.impl.SOAccount", accountParams);
            RegistrationAccount account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
            System.out.println("registering...");
            if (!regService.isRegistrationEnabled()) {
                return;
            }
            regService.register(account);
            System.out.println("Registered Successfully");
        }
        catch (ConnectException cex) {
            System.out.println("Connection Exception");
            cex.printStackTrace();
        }
        catch (RegistrationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void testAccountValidation() {
        try {
            Object[] params = new Object[]{Test.getRepositoryFile()};
            RegistrationServiceConfig config = new RegistrationServiceConfig("com.sun.enterprise.registration.impl.SysnetRegistrationService", params);
            RegistrationService regService = RegistrationServiceFactory.getInstance().getRegistrationService(config);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userID", "replaceme");
            map.put("password", "replaceme");
            Object[] accountParams = new Object[]{map};
            RegistrationAccountConfig accountConfig = new RegistrationAccountConfig("com.sun.enterprise.registration.impl.SOAccount", accountParams);
            RegistrationAccount account = RegistrationAccountFactory.getInstance().getRegistrationAccount(accountConfig);
            System.out.println("Is Account Valid? : " + regService.isRegistrationAccountValid(account));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void testServiceTags() throws RegistrationException {
        Properties data = Test.getServiceTagProps();
        ServiceTag st = new ServiceTag(data);
        RepositoryManager rm = new RepositoryManager(Test.getRepositoryFile());
        System.out.println("Initial repository contents:");
        rm.write(System.out);
        try {
            rm.add(st);
            System.out.println("Service tag added");
            List<ServiceTag> list = rm.getServiceTags();
            System.out.println("List of service tags:");
            for (ServiceTag x : list) {
                System.out.println(x.toString());
            }
            try {
                rm.add(st);
            }
            catch (RegistrationException e) {
                System.err.println("Attempt to add duplicate correctly rejected");
            }
            System.out.println("--- end of list of service tags");
            rm.write(System.out);
            System.out.println("going to remove " + st.getSvcTag().getInstanceURN());
            rm.remove(st);
            System.out.println("Service tag removed");
            rm.write(System.out);
            try {
                rm.remove(st);
                System.out.println("Attempt to remove again succeeded; should have failed");
            }
            catch (RegistrationException e) {
                System.err.println("Attempt to remove correctly rejected");
            }
            rm.add(st);
            System.out.println("Setting status to not registered");
            rm.setRegistrationStatus(st, RegistrationDescriptor.RegistrationStatus.NOT_REGISTERED);
            rm.write(System.out);
            System.out.println("Setting status to not registered");
            rm.setRegistrationStatus(st, RegistrationDescriptor.RegistrationStatus.NOT_REGISTERED);
            rm.write(System.out);
            System.out.println("Setting status to transfered");
            rm.setStatus(st, ServiceTag.Status.TRANSFERRED);
            rm.write(System.out);
            System.out.println("Setting status to not transfered");
            rm.setStatus(st, ServiceTag.Status.NOT_TRANSFERRED);
            rm.write(System.out);
            rm = new RepositoryManager(Test.getRepositoryFile());
            System.out.println("Setting status to dont ask for regn");
            rm.setRegistrationReminder(RegistrationService.RegistrationReminder.REMIND_LATER);
            rm.write(System.out);
            System.out.println((Object)rm.getRegistrationStatus());
            Test.testTransferManager(Test.getRepositoryFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void testTransferManager(File repositoryFile) throws RegistrationException {
        System.out.println("Testing transfer of local tags to SysNet");
        SysnetTransferManager tm = new SysnetTransferManager(repositoryFile);
        int count = tm.transferServiceTags();
        System.out.println("Transferred " + count + " service tags");
        RepositoryManager rm = new RepositoryManager(repositoryFile);
        rm.write(System.out);
    }

    private static void testRMRegistration() throws RegistrationException {
        RepositoryManager rm = new RepositoryManager(Test.getRepositoryFile());
        System.out.println("Initial repository contents:");
        rm.write(System.out);
        System.out.println("Setting registration status to NOT REGISTERED");
        rm.setRegistrationStatus(RegistrationService.RegistrationStatus.NOT_REGISTERED);
        rm.write(System.out);
        System.out.println("Setting reg. status to REGISTERED");
        rm.write(System.out);
    }

    private static void testForInstaller() throws RegistrationException {
        SysnetRegistrationService rs = new SysnetRegistrationService(Test.getRepositoryFile(), "webcache.east.sun.com", 8080);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userID", "replaceme");
        map.put("password", "replaceme");
        SOAccount account = new SOAccount(map);
        try {
            System.out.println("is account valid : " + rs.isRegistrationAccountValid(account));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Properties data = Test.getServiceTagProps();
            ServiceTag st = new ServiceTag(data);
            RepositoryManager rm = new RepositoryManager(Test.getRepositoryFile());
            rm.add(st);
            rs.register(account);
            System.out.println("Registered " + rm.getServiceTags().size() + " tags");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Properties getServiceTagProps() {
        Properties data = new Properties();
        data.put("product_name", "AppServer");
        data.put("product_version", "9.1");
        data.put("product_urn", "urn:uuid:5005588c-36f3-11d6-9cec-fc96f718e113");
        data.put("product_parent_urn", "urn:uuid:product-parent");
        data.put("product_parent", "ProductParent");
        data.put("product_defined_inst_id", "installDir=/tmp");
        data.put("product_vendor", "Sun Micosystems");
        data.put("container", "Global");
        data.put("source", "Test");
        data.put("product_defined_inst_id", "installDir=/tmp");
        data.put("product_urn", "urn:uuid:5005588c-36f3-11d6-9cec-fc96f718e113");
        data.put("product_vendor", "ACME Software, Inc.");
        data.put("product_parent_urn", "urn:something");
        data.put("instance_urn", "urn:st:" + UUID.randomUUID().toString());
        return data;
    }

    private static File getRepositoryFile() {
        return new File("test.xml");
    }
}

