/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.logging.LogDomains;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class DownloadableArtifacts {
    private static Logger logger = LogDomains.getLogger(DownloadableArtifacts.class, (String)"javax.enterprise.system.container.appclient");
    private Map<String, Set<FullAndPartURIs>> artifactsMap = new HashMap<String, Set<FullAndPartURIs>>();

    public synchronized void addArtifact(String moduleName, URI full, URI part) {
        Set<FullAndPartURIs> uriPairs = this.artifactsMap.get(moduleName);
        if (uriPairs == null) {
            uriPairs = new HashSet<FullAndPartURIs>();
            this.artifactsMap.put(moduleName, uriPairs);
        }
        FullAndPartURIs fullAndPart = new FullAndPartURIs(full, part);
        uriPairs.add(fullAndPart);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Added downloadable artifact: " + fullAndPart);
        }
    }

    public synchronized void addArtifact(String moduleName, URI full, String part) {
        this.addArtifact(moduleName, full, URI.create(part));
    }

    public synchronized void addArtifacts(String moduleName, Collection<FullAndPartURIs> urisCollection) {
        Set<FullAndPartURIs> uriPairs = this.artifactsMap.get(moduleName);
        if (uriPairs == null) {
            uriPairs = new HashSet<FullAndPartURIs>();
            this.artifactsMap.put(moduleName, uriPairs);
        }
        uriPairs.addAll(urisCollection);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Added downloadable artifacts: " + urisCollection);
        }
    }

    public synchronized Set<FullAndPartURIs> getArtifacts(String moduleName) {
        Set<FullAndPartURIs> uriPairs = new HashSet<FullAndPartURIs>();
        for (Map.Entry<String, Set<FullAndPartURIs>> entry : this.artifactsMap.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(moduleName) && (!key.startsWith(moduleName) || key.charAt(moduleName.length()) != '/')) continue;
            uriPairs.addAll((Collection<FullAndPartURIs>)entry.getValue());
        }
        if (uriPairs.isEmpty()) {
            uriPairs = Collections.emptySet();
        }
        return uriPairs;
    }

    public synchronized void clearArtifacts(String moduleName) {
        Set<FullAndPartURIs> uriPairs = this.artifactsMap.remove(moduleName);
        if (uriPairs != null) {
            uriPairs.clear();
        }
    }

    public static class FullAndPartURIs {
        private URI full;
        private URI part;

        public FullAndPartURIs(URI full, URI part) {
            this.full = full;
            this.part = part;
        }

        public FullAndPartURIs(URI full, String part) {
            this.full = full;
            this.part = URI.create(part);
        }

        public URI getFull() {
            return this.full;
        }

        public URI getPart() {
            return this.part;
        }

        private void setFull(URI full) {
            this.full = full;
        }

        private void setPart(URI part) {
            this.part = part;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullAndPartURIs other = (FullAndPartURIs)obj;
            if (!(this.full == other.full || this.full != null && this.full.equals(other.full))) {
                return false;
            }
            return this.part == other.part || this.part != null && this.part.equals(other.part);
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + (this.full != null ? this.full.hashCode() : 0);
            hash = 29 * hash + (this.part != null ? this.part.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "full URI=" + this.full + "; part URI=" + this.part;
        }
    }
}

