/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service;

import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageTransformer<T, S> {
    public static final String SUN_MQ = "SUN_MQ";
    public static final String STOMP = "STOMP";
    private Object _obj = null;
    private Object _branchTo = null;
    private String _bridgeType = null;
    private boolean _notransfer = false;

    public final void init(Object object, String string) {
        this._obj = object;
        this._branchTo = null;
        this._bridgeType = string;
        this._notransfer = false;
    }

    public final Object getBranchTo() {
        return this._branchTo;
    }

    public final boolean isNoTransfer() {
        return this._notransfer;
    }

    protected final Message createJMSMessage(JMSMessageType jMSMessageType) throws Exception {
        Session session = (Session)this._obj;
        if (session == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        switch (jMSMessageType) {
            case MESSAGE: {
                return session.createMessage();
            }
            case TEXTMESSAGE: {
                return session.createTextMessage();
            }
            case BYTESMESSAGE: {
                return session.createBytesMessage();
            }
            case MAPMESSAGE: {
                return session.createMapMessage();
            }
            case STREAMMESSAGE: {
                return session.createStreamMessage();
            }
            case OBJECTMESSAGE: {
                return session.createObjectMessage();
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + (Object)((Object)jMSMessageType));
    }

    protected final Queue createQueue(String string) throws Exception {
        Session session = (Session)this._obj;
        if (session == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        return session.createQueue(string);
    }

    protected final Topic createTopic(String string) throws Exception {
        Session session = (Session)this._obj;
        if (session == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        return session.createTopic(string);
    }

    protected final void branchTo(Object object) throws Exception {
        if (this._obj == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        if (!this._bridgeType.equals("JMS")) {
            throw new UnsupportedOperationException("MessageTransformer.branchTo() is not supported for bridge type " + this._bridgeType);
        }
        if (object == null) {
            throw new IllegalArgumentException("null passed to MessageTransformer.branchTo()");
        }
        if (!(object instanceof String) && !(object instanceof Destination)) {
            throw new IllegalArgumentException("Unexpected branchTo object type: " + object.getClass().getName());
        }
        this._branchTo = object;
    }

    protected final void noTransfer() throws Exception {
        if (this._obj == null) {
            throw new IllegalStateException("The MessageTransformer is not initialized !");
        }
        if (!this._bridgeType.equals("JMS")) {
            throw new UnsupportedOperationException("MessageTransformer.noTransfer() is not supported for bridge type " + this._bridgeType);
        }
        this._notransfer = true;
    }

    public abstract T transform(S var1, boolean var2, String var3, String var4, String var5, Properties var6) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JMSMessageType {
        MESSAGE,
        TEXTMESSAGE,
        BYTESMESSAGE,
        MAPMESSAGE,
        STREAMMESSAGE,
        OBJECTMESSAGE;

    }
}

