/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.messaging;

import com.sun.messaging.AdministeredObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.OnewayListener;
import javax.xml.messaging.ReqRespListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class JAXMServlet
extends HttpServlet {
    protected MessageFactory msgFactory = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            String string = AdministeredObject.cr.getKString("C4201");
            throw new ServletException(string + "\n" + sOAPException.getMessage());
        }
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.msgFactory = messageFactory;
    }

    protected static MimeHeaders getHeaders(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        MimeHeaders mimeHeaders = new MimeHeaders();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getHeader(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                mimeHeaders.addHeader(string, stringTokenizer.nextToken().trim());
            }
        }
        return mimeHeaders;
    }

    protected static void putHeaders(MimeHeaders mimeHeaders, HttpServletResponse httpServletResponse) {
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            String[] stringArray = mimeHeaders.getHeader(mimeHeader.getName());
            if (stringArray.length == 1) {
                httpServletResponse.setHeader(mimeHeader.getName(), mimeHeader.getValue());
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[n++]);
            }
            httpServletResponse.setHeader(mimeHeader.getName(), stringBuffer.toString());
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MimeHeaders mimeHeaders = JAXMServlet.getHeaders(httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            SOAPMessage sOAPMessage = this.msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
            SOAPMessage sOAPMessage2 = null;
            if (this instanceof ReqRespListener) {
                sOAPMessage2 = ((ReqRespListener)((Object)this)).onMessage(sOAPMessage);
            } else if (this instanceof OnewayListener) {
                ((OnewayListener)((Object)this)).onMessage(sOAPMessage);
            } else {
                String string = AdministeredObject.cr.getKString("C4202", (Object)((Object)((Object)this)).getClass().getName());
                throw new ServletException(string);
            }
            if (sOAPMessage2 != null) {
                if (sOAPMessage2.saveRequired()) {
                    sOAPMessage2.saveChanges();
                }
                httpServletResponse.setStatus(200);
                JAXMServlet.putHeaders(sOAPMessage2.getMimeHeaders(), httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage2.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception exception) {
            String string = AdministeredObject.cr.getKString("C4203");
            throw new ServletException(string + "\n" + exception.getMessage());
        }
    }
}

