/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.audit;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public final class AuditManager {
    static final String NAME = "name";
    static final String CLASSNAME = "classname";
    private static final String AUDIT_MGR_WS_INVOCATION_KEY = "auditmgr.webServiceInvocation";
    private static final String AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY = "auditmgr.ejbAsWebServiceInvocation";
    private static final String AUDIT_MGR_SERVER_STARTUP_KEY = "auditmgr.serverStartup";
    private static final String AUDIT_MGR_SERVER_SHUTDOWN_KEY = "auditmgr.serverShutdown";
    private static final Logger _logger = LogDomains.getLogger(AuditManager.class, (String)"javax.enterprise.system.core.security");
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(AuditManager.class);
    private List instances = Collections.synchronizedList(new ArrayList());
    private Map moduleToNameMap = new HashMap();
    private Map nameToModuleMap = new HashMap();
    private boolean auditOn = false;
    @Inject
    private ServerContext serverContext;

    public void loadAuditModules() {
        try {
            SecurityService securityBean = this.serverContext.getDefaultHabitat().getComponent(SecurityService.class);
            assert (securityBean != null);
            boolean auditFlag = Boolean.parseBoolean(securityBean.getAuditEnabled());
            this.setAuditOn(auditFlag);
            List am = securityBean.getAuditModule();
            for (AuditModule it : am) {
                try {
                    String name = it.getName();
                    String classname = it.getClassname();
                    Properties p = new Properties();
                    p.setProperty(NAME, name);
                    p.setProperty(CLASSNAME, classname);
                    List ep = it.getProperty();
                    for (Property prop : ep) {
                        p.setProperty(prop.getName(), prop.getValue());
                    }
                    com.sun.appserv.security.AuditModule auditModule = this.loadAuditModule(classname, p);
                    this.instances.add(auditModule);
                    this.moduleToNameMap.put(auditModule, name);
                    this.nameToModuleMap.put(name, auditModule);
                }
                catch (Exception ex) {
                    String msg = _localStrings.getLocalString("auditmgr.loaderror", "Audit: Cannot load AuditModule = {0}", new Object[]{it.getName()});
                    _logger.log(Level.WARNING, msg, ex);
                }
            }
        }
        catch (Exception e) {
            String msg = _localStrings.getLocalString("auditmgr.badinit", "Audit: Cannot load Audit Module Initialization information. AuditModules will not be loaded.");
            _logger.log(Level.WARNING, msg, e);
        }
    }

    public void addAuditModule(String name, String classname, Properties props) throws Exception {
        this.removeAuditModule(name);
        com.sun.appserv.security.AuditModule am = this.loadAuditModule(classname, props);
        this.moduleToNameMap.put(am, name);
        this.nameToModuleMap.put(name, am);
        ArrayList<com.sun.appserv.security.AuditModule> list = new ArrayList<com.sun.appserv.security.AuditModule>();
        Collections.copy(this.instances, list);
        list.add(am);
        this.instances = Collections.synchronizedList(list);
    }

    public void removeAuditModule(String name) {
        Object am = this.nameToModuleMap.get(name);
        if (am != null) {
            this.nameToModuleMap.remove(name);
            this.moduleToNameMap.remove(am);
            ArrayList list = new ArrayList();
            Collections.copy(this.instances, list);
            list.remove(am);
            this.instances = Collections.synchronizedList(list);
        }
    }

    com.sun.appserv.security.AuditModule getAuditModule(String name) {
        return (com.sun.appserv.security.AuditModule)this.nameToModuleMap.get(name);
    }

    private com.sun.appserv.security.AuditModule loadAuditModule(String classname, Properties props) throws Exception {
        com.sun.appserv.security.AuditModule auditModule = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> am = Class.forName(classname, true, loader);
        Object obj = am.newInstance();
        auditModule = (com.sun.appserv.security.AuditModule)obj;
        auditModule.init(props);
        return auditModule;
    }

    public void authentication(String user, String realm, boolean success) {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = null;
                try {
                    am = (com.sun.appserv.security.AuditModule)list.get(i);
                    am.authentication(user, realm, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.authentication", " Audit Module {0} threw the followin exception during authentication:", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void webInvocation(String user, HttpServletRequest req, String type, boolean success) {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.webInvocation(user, req, type, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.webinvocation", " Audit Module {0} threw the followin exception during web invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void ejbInvocation(String user, String ejb, String method, boolean success) {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.ejbInvocation(user, ejb, method, success);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString("auditmgr.ejbinvocation", " Audit Module {0} threw the followin exception during ejb invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void webServiceInvocation(String uri, String endpoint, boolean validRequest) {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.webServiceInvocation(uri, endpoint, validRequest);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void ejbAsWebServiceInvocation(String endpoint, boolean validRequest) {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.ejbAsWebServiceInvocation(endpoint, validRequest);
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_EJB_AS_WS_INVOCATION_KEY, " Audit Module {0} threw the following exception during ejb as web service invocation :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void serverStarted() {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.serverStarted();
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_STARTUP_KEY, " Audit Module {0} threw the following exception during server startup :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void serverShutdown() {
        if (this.auditOn) {
            List list = this.instances;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                com.sun.appserv.security.AuditModule am = (com.sun.appserv.security.AuditModule)list.get(i);
                try {
                    am.serverShutdown();
                    continue;
                }
                catch (Exception e) {
                    String name = (String)this.moduleToNameMap.get(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_SHUTDOWN_KEY, " Audit Module {0} threw the following exception during server shutdown :", new Object[]{name});
                    _logger.log(Level.INFO, msg, e);
                }
            }
        }
    }

    public void setAuditOn(boolean auditOn) {
        this.auditOn = auditOn;
    }

    public boolean isAuditOn() {
        return this.auditOn;
    }
}

