/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.solaris.SolarisRealm;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class SolarisLoginModule
extends PasswordLoginModule {
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof SolarisRealm)) {
            String msg = sm.getString("solarislm.badrealm");
            throw new LoginException(msg);
        }
        SolarisRealm solarisRealm = (SolarisRealm)this._currentRealm;
        if (this._username == null || this._username.length() == 0) {
            String msg = sm.getString("solarislm.nulluser");
            throw new LoginException(msg);
        }
        String[] grpList = solarisRealm.authenticate(this._username, this._password);
        if (grpList == null) {
            String msg = sm.getString("solarislm.loginfail", (Object)this._username);
            throw new LoginException(msg);
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("Solaris login succeeded for: " + this._username);
        }
        String[] groupListToForward = new String[grpList.length];
        for (int i = 0; i < grpList.length; ++i) {
            groupListToForward[i] = grpList[i];
        }
        this.commitAuthentication(this._username, this._password, this._currentRealm, groupListToForward);
    }
}

