/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.logging.LogDomains;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.webservices.SOAPMessageContext;
import org.glassfish.webservices.monitoring.EndpointImpl;
import org.glassfish.webservices.monitoring.EndpointType;
import org.glassfish.webservices.monitoring.HttpRequestInfoImpl;
import org.glassfish.webservices.monitoring.MessageListener;
import org.glassfish.webservices.monitoring.MessageTrace;
import org.glassfish.webservices.monitoring.MessageTraceImpl;
import org.glassfish.webservices.monitoring.TransportInfo;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;

public class JAXWSEndpointImpl
extends EndpointImpl {
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();

    JAXWSEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(SOAPMessageContext messageContext) throws Exception {
        boolean status = true;
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (!this.listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("javax.xml.ws.servlet.request");
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(httpReq);
                    wsEngine.processRequest(messageID, messageContext, (TransportInfo)info);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    HttpServletRequest httpReq = (HttpServletRequest)messageContext.get("javax.xml.ws.servlet.request");
                    request.setTransportInfo(new HttpRequestInfoImpl(httpReq));
                    messageContext.put("MONITORING_REQUEST_MESSAGE_TRACE", request);
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning(this.rb.getString("exception.tracing.request") + e.getMessage());
            throw e;
        }
        return status;
    }

    public void processResponse(SOAPMessageContext messageContext) throws Exception {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) {
                String messageID = (String)messageContext.get("MONITORING_MESSAGE_ID");
                if (messageID != null) {
                    wsEngine.processResponse(messageID, messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl response = new MessageTraceImpl();
                    response.setEndpoint(this);
                    response.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed((MessageTrace)messageContext.get("MONITORING_REQUEST_MESSAGE_TRACE"), response);
                    }
                }
            }
        }
        catch (Exception e) {
            WebServiceEngineImpl.sLogger.warning(this.rb.getString("exception.tracing.response") + e.getMessage());
            throw e;
        }
    }
}

