/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnection;
import com.sun.connector.jaxr.JaxrConnectionEventListener;
import com.sun.connector.jaxr.MetaDataImpl;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;

public class JaxrManagedConnection
implements ManagedConnection {
    private XAConnection xacon;
    private Connection con;
    private JaxrConnectionEventListener jaxrListener;
    private PasswordCredential passCred;
    private ManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private boolean supportsXA;
    private boolean supportsLocalTx;
    private boolean destroyed;
    private Properties properties;
    private Set connectionSet;
    Logger log = Logger.getLogger("com.sun.connector.jaxr");

    JaxrManagedConnection(ManagedConnectionFactory managedConnectionFactory, PasswordCredential passwordCredential, XAConnection xAConnection, Connection connection, boolean bl, boolean bl2) {
        this.mcf = managedConnectionFactory;
        this.passCred = passwordCredential;
        this.xacon = xAConnection;
        this.log.fine("JAXRManagedConnection has actual jaxr connection impl");
        this.con = connection;
        this.supportsXA = bl;
        this.supportsLocalTx = bl2;
        this.connectionSet = new HashSet();
        this.log.fine("Instantiating JAXRConnectionEventListener in JAXRManagedConnection constructor");
        this.jaxrListener = new JaxrConnectionEventListener(this);
        this.log.fine("End of JAXRManagedConnection constructor");
    }

    JaxrManagedConnection(ManagedConnectionFactory managedConnectionFactory, Properties properties, XAConnection xAConnection, Connection connection, boolean bl, boolean bl2) {
        this.mcf = managedConnectionFactory;
        this.properties = properties;
        this.xacon = xAConnection;
        this.log.fine("JAXRManagedConnection has actual jaxr connection impl");
        this.con = connection;
        this.supportsXA = bl;
        this.supportsLocalTx = bl2;
        this.connectionSet = new HashSet();
        this.log.fine("Instantiating JAXRConnectionEventListener in JAXRManagedConnection constructor");
        this.jaxrListener = new JaxrConnectionEventListener(this);
        this.log.fine("End of JAXRManagedConnection constructor");
    }

    private void throwResourceException(JAXRException jAXRException) throws ResourceException {
        this.log.fine("throwing REx in in JAXRManagedConnection constructor");
        jAXRException.printStackTrace();
        ResourceException resourceException = new ResourceException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("JAXRException:_") + jAXRException.getMessage());
        resourceException.setLinkedException((Exception)((Object)jAXRException));
        throw resourceException;
    }

    private void throwResourceException(SQLException sQLException) throws ResourceException {
        ResourceException resourceException = new ResourceException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("SQLException:_") + sQLException.getMessage());
        resourceException.setLinkedException((Exception)sQLException);
        throw resourceException;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.checkIfDestroyed();
        this.log.fine("JAXRManagedConnection getting connection");
        JaxrConnection jaxrConnection = new JaxrConnection(this, this.supportsLocalTx);
        this.log.fine("JAXRManagedConnectiond created JAXRConnection");
        this.addJaxrConnection(jaxrConnection);
        this.log.fine("JAXRMananagedConnection adding JAXRConnection to connection set");
        return jaxrConnection;
    }

    public void destroy() throws ResourceException {
        try {
            if (this.destroyed) {
                return;
            }
            this.log.fine("JAXRManagedConnection destroying all JAXRConnections");
            this.destroyed = true;
            for (JaxrConnection jaxrConnection : this.connectionSet) {
                this.log.fine("JAXRManagedConnection destroying JAXRConnection - invalidate");
                jaxrConnection.invalidate();
            }
            this.log.fine("JAXRManagedConnection destorying JAXRConnection - connection set clear");
            this.connectionSet.clear();
            this.log.fine("JAXRManagedConnection destorying JAXRConnection - closing actual jaxr connectionImpl");
            this.con.close();
            if (this.xacon != null) {
                this.xacon.close();
            }
        }
        catch (JAXRException jAXRException) {
            this.throwResourceException(jAXRException);
        }
        catch (SQLException sQLException) {
            this.throwResourceException(sQLException);
        }
    }

    public void cleanup() throws ResourceException {
        try {
            this.checkIfDestroyed();
            this.log.fine("JAXRManagedConnection cleanup all JAXRConnections");
            for (JaxrConnection jaxrConnection : this.connectionSet) {
                this.log.fine("JAXRManagedConnection cleaning JAXRConnection - invalidate");
                jaxrConnection.invalidate();
            }
            this.log.fine("JAXRManagedConnection cleaning JAXRConnection - connection set clear");
            this.connectionSet.clear();
        }
        catch (Exception exception) {
            throw new ResourceException((Throwable)exception);
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        this.checkIfDestroyed();
        this.log.fine("JAXRManagedConnection associate JAXRConnection - ");
        if (!(object instanceof JaxrConnection)) {
            throw new IllegalStateException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Invalid_connection_object:_") + object);
        }
        JaxrConnection jaxrConnection = (JaxrConnection)object;
        this.log.fine("JAXRManagedConnection calling JAXRConnection associateConnection - ");
        jaxrConnection.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.log.fine("JAXRManagedConnection calling jaxr connectionEventListener - addConnectorListener");
        this.jaxrListener.addConnectorListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.jaxrListener.removeConnectorListener(connectionEventListener);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Local_transaction_not_supported"));
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new MetaDataImpl(this);
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    Connection getJaxrConnection() throws ResourceException {
        this.checkIfDestroyed();
        this.log.fine("JAXRManagedConnection returning actual jaxr connectionImpl");
        return this.con;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    Properties getProperties() {
        return this.properties;
    }

    void sendEvent(int n, Exception exception) {
        this.log.fine("JAXRManagedConnection calling eventlistener sendEvent");
        this.jaxrListener.sendEvent(n, exception, null);
    }

    void sendEvent(int n, Exception exception, Object object) {
        this.log.fine("JAXRManagedConnection calling eventlistener sendEvent w/ connectionHandle");
        this.jaxrListener.sendEvent(n, exception, object);
    }

    void removeJaxrConnection(JaxrConnection jaxrConnection) {
        this.log.fine("JAXRManagedConnection removing JAXRConnection from connection set");
        this.connectionSet.remove(jaxrConnection);
        jaxrConnection.invalidate();
        try {
            this.con.close();
            this.log.fine("JAXRManagedConnection Closed actual jaxr ConnectionImpl");
        }
        catch (JAXRException jAXRException) {
            this.log.warning("Error closing jaxr connection");
        }
    }

    void addJaxrConnection(JaxrConnection jaxrConnection) {
        this.log.fine("JAXRManagedConnection adding JAXRConnection to connection set");
        this.connectionSet.add(jaxrConnection);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new IllegalStateException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Managed_connection_is_closed"));
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        this.log.fine("JAXRManagedConnection returning JAXRManagedConnectionFactory");
        return this.mcf;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("XAResource_not_supported"));
    }
}

