/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;

public class HandlerDispatch
extends JkHandler {
    private static Logger log = Logger.getLogger(HandlerDispatch.class.getName());
    JkHandler[] handlers = new JkHandler[32];
    String[] handlerNames = new String[32];
    static final int MAX_HANDLERS = 32;
    static final int RESERVED = 16;
    int currentId = 16;

    public void init() {
    }

    public int registerMessageType(int id, String name, JkHandler h, String[] sig) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Register message " + id + " " + h.getName() + " " + h.getClass().getName());
        }
        if (id < 0) {
            for (int i = 0; i < this.handlerNames.length; ++i) {
                if (this.handlerNames[i] == null || !name.equals(this.handlerNames[i])) continue;
                return i;
            }
            this.handlers[this.currentId] = h;
            this.handlerNames[this.currentId] = name;
            ++this.currentId;
            return this.currentId;
        }
        this.handlers[id] = h;
        this.handlerNames[this.currentId] = name;
        return id;
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        byte type = msg.peekByte();
        ep.setType(type);
        if (type > this.handlers.length || this.handlers[type] == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Invalid handler " + type);
            }
            return 2;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received " + type + " " + this.handlers[type].getName());
        }
        JkHandler handler = this.handlers[type];
        return handler.invoke(msg, ep);
    }
}

