/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.ServiceFactory;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-service")
@Scoped(value=PerLookup.class)
public final class CreateServiceCommand
extends CLICommand {
    private static final String DOMAIN_PARENT_DIR = "domaindir";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String SERVICE_PROPERTIES = "serviceproperties";
    private static final String DRY_RUN = "dry-run";
    private static final String VALID_TYPES = "das|node-agent";
    private static final String DAS_TYPE = "das";
    private File domainDir;
    private String serviceName;
    private File asadminScript;
    private File domainDirParent;
    private String domainName;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateServiceCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        CreateServiceCommand.addOption(opts, (String)NAME, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateServiceCommand.addOption(opts, (String)SERVICE_PROPERTIES, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateServiceCommand.addOption(opts, (String)DRY_RUN, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        CreateServiceCommand.addOption(opts, (String)DOMAIN_PARENT_DIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateServiceCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    protected void validate() throws CommandException, CommandValidationException {
        try {
            super.validate();
            this.validateDomainDir();
            this.validateName();
            this.validateAsadmin();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (CommandValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            boolean dry_run = this.getBooleanOption(DRY_RUN);
            String type = DAS_TYPE;
            com.sun.enterprise.admin.servermgmt.services.Service service = ServiceFactory.getService();
            service.setDate(new Date().toString());
            service.setName(this.serviceName);
            service.setDryRun(dry_run);
            service.setLocation(this.domainDir.getPath());
            service.setType(type.equals(DAS_TYPE) ? AppserverServiceType.Domain : AppserverServiceType.NodeAgent);
            service.setFQSN();
            service.setOSUser();
            service.setAsadminPath(this.asadminScript.getPath());
            if (this.programOpts.getPasswordFile() != null) {
                service.setPasswordFilePath(SmartFile.sanitize((String)new File(this.programOpts.getPasswordFile()).getPath()));
            }
            service.setServiceProperties(this.getOption(SERVICE_PROPERTIES));
            service.isConfigValid();
            service.setTrace(CLILogger.isDebug());
            service.createService(service.tokensAndValues());
            logger.printMessage(service.getSuccessMessage());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (StringUtils.ok((String)msg)) {
                throw new CommandValidationException(msg);
            }
            throw new CommandValidationException((Throwable)e);
        }
        return 0;
    }

    private void validateDomainDir() throws CommandValidationException {
        String domainDirParentPath;
        if (this.operands.size() >= 1) {
            this.domainName = (String)this.operands.get(0);
        }
        this.domainDirParent = !CreateServiceCommand.ok((String)(domainDirParentPath = this.getOption(DOMAIN_PARENT_DIR))) ? this.getDefaultDomainDirParent() : SmartFile.sanitize((File)new File(domainDirParentPath));
        if (!this.domainDirParent.isDirectory()) {
            throw new CommandValidationException(strings.get("create.service.BadDomainDirParent", new Object[]{this.domainDirParent}));
        }
        if (!CreateServiceCommand.ok((String)this.domainName)) {
            this.domainName = this.getTheOneAndOnlyDomain();
        }
        this.domainDir = SmartFile.sanitize((File)new File(this.domainDirParent, this.domainName));
        if (!this.domainDir.isDirectory()) {
            throw new CommandValidationException(strings.get("create.service.BadDomainDir", new Object[]{this.domainDir}));
        }
    }

    private File getDefaultDomainDirParent() {
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!CreateServiceCommand.ok((String)ir)) {
            throw new RuntimeException("Internal Error: System Property not set: com.sun.aas.installRoot");
        }
        return SmartFile.sanitize((File)new File(new File(ir), "domains"));
    }

    private String getTheOneAndOnlyDomain() {
        File[] files = this.domainDirParent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new RuntimeException(strings.get("create.service.noDomainDirs", new Object[]{this.domainDirParent}));
        }
        if (files.length > 1) {
            throw new RuntimeException(strings.get("create.service.tooManyDomainDirs", new Object[]{this.domainDirParent}));
        }
        return files[0].getName();
    }

    private void validateName() {
        this.serviceName = this.getOption(NAME);
        if (!CreateServiceCommand.ok((String)this.serviceName)) {
            this.serviceName = this.domainDir.getName();
        }
        logger.printDebugMessage("service name = " + this.serviceName);
    }

    private void validateAsadmin() throws CommandValidationException {
        String s = SystemPropertyConstants.getAsAdminScriptLocation();
        if (!CreateServiceCommand.ok((String)s)) {
            throw new CommandValidationException(strings.get("internal.error", new Object[]{"Can't get Asadmin script location"}));
        }
        this.asadminScript = SmartFile.sanitize((File)new File(s));
        if (!this.asadminScript.isFile()) {
            throw new CommandValidationException(strings.get("create.service.noAsadminScript", new Object[]{this.asadminScript}));
        }
    }
}

