/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.DirectMapUsableContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedKeyMapContainerPolicy
extends MapContainerPolicy
implements DirectMapUsableContainerPolicy {
    protected transient MapKeyMapping keyMapping;
    protected transient MapComponentMapping valueMapping;
    public DatabaseQuery keyQuery;

    public MappedKeyMapContainerPolicy() {
    }

    public MappedKeyMapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public MappedKeyMapContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        this.keyMapping.addAdditionalFieldsToQuery(selectionQuery, baseExpression);
    }

    @Override
    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession session) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isReadOnly()) {
            return null;
        }
        Object keyValue = ((Map.Entry)object).getKey();
        return this.keyMapping.extractIdentityFieldsForQuery(keyValue, session);
    }

    @Override
    public Object getKeyType() {
        return this.keyMapping.getMapKeyTargetType();
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isReadOnly()) {
            return;
        }
        this.keyMapping.addFieldsForMapKey(joinRow);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session) {
        Object key = null;
        Object value = null;
        if (element instanceof AbstractRecord) {
            AbstractRecord record = (AbstractRecord)element;
            key = this.keyMapping.createMapComponentFromRow(record, null, session);
            value = this.valueMapping.createMapComponentFromRow(record, null, session);
            return this.addInto(key, value, container, session);
        }
        if (element instanceof Association) {
            Association record = (Association)element;
            key = record.getKey();
            value = record.getValue();
            return this.addInto(key, value, container, session);
        }
        return super.addInto(element, container, session);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord dbRow, ObjectBuildingQuery query) {
        Object key = null;
        Object value = null;
        if (this.valueMapping != null && ((DatabaseMapping)((Object)this.valueMapping)).isDirectCollectionMapping() && session.getDescriptor(element.getClass()) != null) {
            key = element;
            value = this.valueMapping.createMapComponentFromRow(dbRow, null, session);
        } else if (this.keyMapping != null) {
            value = element;
            try {
                key = this.keyMapping.createMapComponentFromRow(dbRow, query, session);
            }
            catch (Exception e) {
                throw QueryException.exceptionWhileReadingMapKey(element, e);
            }
        }
        return this.addInto(key, value, container, session);
    }

    @Override
    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = this.keyMapping.getNestedJoinQuery(joinManager, query, session);
        if (nestedQuery != null) {
            joinManager.getJoinedMappingQueries_().put((DatabaseMapping)((Object)this.keyMapping), nestedQuery);
        }
    }

    @Override
    public void addToDeletedObjectsList(Object object, Map deletedObjects) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            Object key = ((Map.Entry)object).getKey();
            this.keyMapping.addKeyToDeletedObjectsList(key, deletedObjects);
        }
        Object unwrapped = this.unwrapIteratorResult(object);
        deletedObjects.put(unwrapped, unwrapped);
    }

    @Override
    public Object buildCloneForKey(Object key, Object parent, UnitOfWorkImpl uow, boolean isExisting) {
        return this.keyMapping.buildElementClone(key, parent, uow, isExisting);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        ReadQuery query = this.keyMapping.buildSelectionQueryForDirectCollectionKeyMapping(this);
        return query;
    }

    public Object buildContainerFromVector(Vector vector, DatabaseQuery query, AbstractSession session) {
        Object container = this.containerInstance(vector.size());
        int size = vector.size();
        for (int index = 0; index < size; ++index) {
            Object element = vector.get(index);
            if (element instanceof AbstractRecord && query.isObjectBuildingQuery()) {
                Object key = null;
                key = this.keyMapping.createMapComponentFromRow((AbstractRecord)element, (ObjectBuildingQuery)query, session);
                Object value = ((AbstractRecord)element).getValues().elementAt(1);
                this.addInto(key, value, container, session);
                continue;
            }
            this.addInto(vector.get(index), container, session);
        }
        return container;
    }

    @Override
    public Object buildKey(AbstractRecord row, ObjectBuildingQuery query, AbstractSession session) {
        return this.keyMapping.createMapComponentFromRow(row, query, session);
    }

    @Override
    public Object buildKeyFromJoinedRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) {
        return this.keyMapping.createMapComponentFromJoinedRow(row, joinManager, query, session);
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
        this.keyMapping.cascadeDiscoverAndPersistUnregisteredNewObjects(((Map.Entry)object).getKey(), newObjects, unregisteredExistingObjects, visitedObjects, uow, false);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.keyMapping.cascadePerformRemoveIfRequired(((Map.Entry)object).getKey(), uow, visitedObjects, false);
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.keyMapping.cascadeRegisterNewIfRequired(((Map.Entry)object).getKey(), uow, visitedObjects, false);
    }

    protected void collectObjectForNewCollection(HashMap originalKeyValues, HashMap cloneKeyValues, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        Object cloneIter = this.iteratorFor(newCollection);
        while (this.hasNext(cloneIter)) {
            Map.Entry wrappedFirstObject = (Map.Entry)this.nextEntry(cloneIter, session);
            Object firstObject = wrappedFirstObject.getValue();
            if (firstObject == null) continue;
            Vector pks = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            if (originalKeyValues.containsKey(pks)) {
                originalKeyValues.remove(pks);
                continue;
            }
            this.buildChangeSetForNewObjectInCollection(wrappedFirstObject, referenceDescriptor, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
            cloneKeyValues.put(pks, firstObject);
        }
    }

    @Override
    public boolean compareContainers(Object firstObjectMap, Object secondObjectMap) {
        if (this.sizeFor(firstObjectMap) != this.sizeFor(secondObjectMap)) {
            return false;
        }
        Object firstIterator = this.iteratorFor(firstObjectMap);
        while (this.hasNext(firstIterator)) {
            Map.Entry entry = (Map.Entry)this.nextEntry(firstIterator);
            Object key = entry.getKey();
            if (((Map)firstObjectMap).get(key).equals(((Map)secondObjectMap).get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        if (this.keyMapping != null) {
            return true;
        }
        return super.compareKeys(sourceValue, session);
    }

    @Override
    protected void createChangeSetForKeys(Map originalKeyValues, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        for (Association association : originalKeyValues.values()) {
            Object object = association.getValue();
            ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
            changeSet.setOldKey(association.getKey());
        }
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        return this.keyMapping.createQueryKeyForMapKey();
    }

    @Override
    public Object createWrappedObjectFromExistingWrappedObject(Object wrappedObject, Object parent, ClassDescriptor referenceDescriptor, MergeManager mergeManager) {
        Object key = ((Map.Entry)wrappedObject).getKey();
        key = this.keyMapping.getTargetVersionOfSourceObject(key, parent, mergeManager);
        key = this.keyMapping.wrapKey(key, mergeManager.getSession());
        Object value = referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(wrappedObject)), mergeManager.getSession());
        return new Association(key, value);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        ((DatabaseMapping)((Object)this.keyMapping)).convertClassNamesToClasses(classLoader);
    }

    @Override
    public void deleteWrappedObject(Object objectDeleted, AbstractSession session) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            this.keyMapping.deleteMapKey(((Map.Entry)objectDeleted).getKey(), session);
        }
        session.deleteObject(this.unwrapIteratorResult(objectDeleted));
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return this.keyMapping.getAdditionalTablesForJoinQuery();
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey(CollectionMapping baseMapping) {
        return this.keyMapping.getAllFieldsForMapKey();
    }

    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return this.keyMapping.getForeignKeyFieldsForMapKey();
    }

    @Override
    public ClassDescriptor getDescriptorForMapKey() {
        return this.keyMapping.getReferenceDescriptor();
    }

    @Override
    public Object getCloneDataFromChangeSet(ObjectChangeSet changeSet) {
        Object key = changeSet.getNewKey();
        if (key == null) {
            key = changeSet.getOldKey();
        }
        return new Association(key, changeSet.getUnitOfWorkClone());
    }

    @Override
    public DatabaseField getDirectKeyField(CollectionMapping baseMapping) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)this.keyMapping).getField();
        }
        return null;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.keyMapping.getIdentityFieldsForMapKey();
    }

    @Override
    public Converter getKeyConverter() {
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)this.keyMapping).getConverter();
        }
        return null;
    }

    public MapKeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public DatabaseQuery getKeyQuery() {
        return this.keyQuery;
    }

    @Override
    public Expression getKeySelectionCriteria() {
        return this.keyMapping.getAdditionalSelectionCriteriaForMapKey();
    }

    public MapComponentMapping getValueMapping() {
        return this.valueMapping;
    }

    @Override
    public void initialize(AbstractSession session, DatabaseTable keyTable) {
        this.getKeyMapping().preinitializeMapKey(keyTable);
        ((DatabaseMapping)((Object)this.keyMapping)).initialize(session);
    }

    @Override
    protected boolean isKeyAvailableFromElement() {
        return false;
    }

    @Override
    public boolean isMappedKeyMapPolicy() {
        return true;
    }

    @Override
    public boolean isMapKeyAttribute() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isAbstractDirectMapping();
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        Object key = ((Map.Entry)element).getKey();
        this.keyMapping.iterateOnMapKey(iterator, key);
    }

    @Override
    public void postCalculateChanges(ObjectChangeSet ocs, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.getKeyMapping())).isForeignReferenceMapping() && ((DatabaseMapping)((Object)this.getKeyMapping())).isPrivateOwned()) {
            Object key = ocs.getOldKey();
            uow.addDeletedPrivateOwnedObjects((DatabaseMapping)((Object)this.getKeyMapping()), key);
        }
        super.postCalculateChanges(ocs, referenceDescriptor, mapping, uow);
    }

    @Override
    public void postCalculateChanges(Object key, Object value, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.getKeyMapping())).isForeignReferenceMapping()) {
            uow.addDeletedPrivateOwnedObjects((DatabaseMapping)((Object)this.getKeyMapping()), key);
        }
        super.postCalculateChanges(key, value, referenceDescriptor, mapping, uow);
    }

    @Override
    public void processAdditionalWritableMapKeyFields(AbstractSession session) {
        if (!((DatabaseMapping)((Object)this.getKeyMapping())).isReadOnly()) {
            CollectionMapping mapping = (CollectionMapping)((Object)this.valueMapping);
            for (DatabaseField field : this.getIdentityFieldsForMapKey()) {
                if (mapping.getReferenceDescriptor().getObjectBuilder().getMappingsByField().containsKey(field) || mapping.getReferenceDescriptor().getAdditionalWritableMapKeyFields().contains(field)) {
                    session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(field.toString(), mapping));
                    continue;
                }
                mapping.getReferenceDescriptor().getAdditionalWritableMapKeyFields().add(field);
            }
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            Object key = ((Map.Entry)object).getKey();
            ((DatabaseMapping)((Object)this.keyMapping)).getReferenceDescriptor().getObjectBuilder().recordPrivateOwnedRemovals(key, uow, false);
        }
        super.recordPrivateOwnedRemovals(((Map.Entry)object).getValue(), referenceDescriptor, uow);
    }

    @Override
    public boolean requiresDataModificationEvents() {
        return true;
    }

    @Override
    public Object keyFrom(Object element, AbstractSession session) {
        if (this.keyMapping != null) {
            return null;
        }
        return super.keyFrom(element, session);
    }

    @Override
    public void postInitialize(AbstractSession session) {
        ((DatabaseMapping)((Object)this.keyMapping)).postInitialize(session);
    }

    @Override
    public void propogatePostDelete(DeleteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).postDeleteAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePostInsert(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).postInsertAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePostUpdate(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            Object key = object;
            if (object instanceof Map.Entry) {
                key = ((Map.Entry)object).getKey();
            }
            ((AggregateObjectMapping)this.keyMapping).postUpdateAttributeValue(query, key);
        }
    }

    @Override
    public void propogatePreDelete(DeleteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preDeleteAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePreInsert(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preInsertAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePreUpdate(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preUpdateAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public boolean propagatesEventsToCollection() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isAggregateObjectMapping();
    }

    @Override
    public void setKeyField(DatabaseField keyField, ClassDescriptor descriptor) {
        if (this.keyMapping == null) {
            DirectToFieldMapping newKeyMapping = new DirectToFieldMapping();
            newKeyMapping.setField(keyField);
            newKeyMapping.setDescriptor(descriptor);
            this.setKeyMapping(newKeyMapping);
        }
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            ((DirectToFieldMapping)this.keyMapping).setField(keyField);
        }
    }

    @Override
    public void setDescriptorForKeyMapping(ClassDescriptor descriptor) {
        ((DatabaseMapping)((Object)this.keyMapping)).setDescriptor(descriptor);
    }

    @Override
    public void setKeyConverter(Converter keyConverter, DirectMapMapping mapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(mapping.getDescriptor(), mapping, keyConverter.getClass().getName());
        }
        ((DirectToFieldMapping)this.keyMapping).setConverter(keyConverter);
    }

    @Override
    public void setKeyConverterClassName(String keyConverterClassName, DirectMapMapping mapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(mapping.getDescriptor(), mapping, keyConverterClassName);
        }
        ((DirectToFieldMapping)this.keyMapping).setConverterClassName(keyConverterClassName);
    }

    public void setKeyMapping(MapKeyMapping mapping) {
        if (((DatabaseMapping)((Object)mapping)).isForeignReferenceMapping() && ((ForeignReferenceMapping)((Object)mapping)).getIndirectionPolicy().usesIndirection()) {
            throw ValidationException.mapKeyCannotUseIndirection((DatabaseMapping)((Object)mapping));
        }
        this.keyMapping = mapping;
        ((DatabaseMapping)((Object)mapping)).setIsMapKeyMapping(true);
    }

    public void setKeyQuery(DatabaseQuery keyQuery) {
        this.keyQuery = keyQuery;
    }

    @Override
    public void setValueField(DatabaseField field, Converter converter) {
    }

    public void setValueMapping(MapComponentMapping mapping) {
        this.valueMapping = mapping;
    }

    @Override
    public boolean shouldIncludeKeyInDeleteEvent() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned();
    }

    @Override
    public boolean shouldUpdateForeignKeysPostInsert() {
        return !((DatabaseMapping)((Object)this.keyMapping)).isReadOnly();
    }

    @Override
    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        indexList.put((DatabaseMapping)((Object)this.keyMapping), index);
        return this.getAllFieldsForMapKey(null).size();
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return this.keyMapping.unwrapKey(key, session);
    }
}

