/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EjbConversionHelper
implements ConversionHelper {
    private NameMapper nameMapper = null;
    private EjbBundleDescriptor bundle = null;
    private HashMap ejbDescMap = new HashMap();
    private HashMap ejbFieldMap = new HashMap();
    private HashMap ejbKeyMap = new HashMap();
    private HashMap ejbPerDescMap = new HashMap();
    private HashMap ejbRelMap = new HashMap();
    boolean generateFields = true;
    boolean ensureValidation = true;

    public EjbConversionHelper(NameMapper nameMapper) {
        this.nameMapper = nameMapper;
        this.bundle = nameMapper.getBundleDescriptor();
        for (Object desc : this.bundle.getEjbs()) {
            if (!(desc instanceof IASEjbCMPEntityDescriptor)) continue;
            IASEjbCMPEntityDescriptor ejbDesc = (IASEjbCMPEntityDescriptor)desc;
            String ejbName = ejbDesc.getName();
            this.ejbDescMap.put(ejbName, ejbDesc);
            PersistenceDescriptor pers = ejbDesc.getPersistenceDescriptor();
            this.ejbPerDescMap.put(ejbName, pers);
            Collection pFields = ejbDesc.getPersistentFields();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            Iterator fIter = pFields.iterator();
            while (fIter.hasNext()) {
                String fieldName = ((PersistentFieldInfo)fIter.next()).name;
                fieldMap.put(fieldName, fieldName);
            }
            this.ejbFieldMap.put(ejbName, fieldMap);
            List pseudoFields = nameMapper.getGeneratedRelationshipsForEjbName(ejbName);
            Iterator pIter = pseudoFields.iterator();
            while (pIter.hasNext()) {
                this.addField(ejbName, (String)pIter.next());
            }
            Collection pKeys = ejbDesc.getPrimaryKeyFields();
            HashMap<String, String> pKeyMap = new HashMap<String, String>();
            Iterator kIter = pKeys.iterator();
            while (kIter.hasNext()) {
                String fieldName = ((PersistentFieldInfo)kIter.next()).name;
                pKeyMap.put(fieldName, fieldName);
            }
            this.ejbKeyMap.put(ejbName, pKeyMap);
        }
        Set rels = this.bundle.getRelationships();
        for (RelationshipDescriptor rel : rels) {
            String sinkEjbName;
            ArrayList<RelationshipDescriptor> sinkRels;
            RelationRoleDescriptor source = rel.getSource();
            RelationRoleDescriptor sink = rel.getSink();
            String sourceEjbName = source.getOwner().getName();
            ArrayList<RelationshipDescriptor> sourceRels = (ArrayList<RelationshipDescriptor>)this.ejbRelMap.get(sourceEjbName);
            if (sourceRels == null) {
                sourceRels = new ArrayList<RelationshipDescriptor>();
                this.ejbRelMap.put(sourceEjbName, sourceRels);
            }
            sourceRels.add(rel);
            String sourceCMRField = source.getCMRField();
            if (sourceCMRField != null) {
                this.addField(sourceEjbName, sourceCMRField);
            }
            if ((sinkRels = (ArrayList<RelationshipDescriptor>)this.ejbRelMap.get(sinkEjbName = sink.getOwner().getName())) == null) {
                sinkRels = new ArrayList<RelationshipDescriptor>();
                this.ejbRelMap.put(sinkEjbName, sinkRels);
            }
            sinkRels.add(rel);
            String sinkCMRField = sink.getCMRField();
            if (sinkCMRField == null) continue;
            this.addField(sinkEjbName, sinkCMRField);
        }
    }

    public String getMappedClassName(String ejbName) {
        return this.nameMapper.getPersistenceClassForEjbName(ejbName);
    }

    public boolean hasField(String ejbName, String fieldName) {
        if (!this.generateFields && this.isGeneratedRelationship(ejbName, fieldName)) {
            return false;
        }
        HashMap fieldMap = (HashMap)this.ejbFieldMap.get(ejbName);
        return fieldMap != null ? fieldMap.get(fieldName) != null : false;
    }

    public Object[] getFields(String ejbName) {
        HashMap fieldMap = (HashMap)this.ejbFieldMap.get(ejbName);
        if (fieldMap != null) {
            ArrayList fields = new ArrayList(fieldMap.keySet());
            if (!this.generateFields) {
                fields.removeAll(this.getGeneratedRelationships(ejbName));
            }
            return fields.toArray();
        }
        return null;
    }

    public boolean isKey(String ejbName, String fieldName, boolean candidate) {
        HashMap keyMap = (HashMap)this.ejbKeyMap.get(ejbName);
        return keyMap != null ? keyMap.get(fieldName) != null : false;
    }

    public String getRelationshipFieldType(String ejbName, String fieldName) {
        if (this.isGeneratedRelationship(ejbName, fieldName)) {
            return Collection.class.getName();
        }
        PersistenceDescriptor pers = (PersistenceDescriptor)this.ejbPerDescMap.get(ejbName);
        return pers.getCMRFieldReturnType(fieldName);
    }

    public String getMultiplicity(String ejbName, String fieldName) {
        RelationRoleDescriptor oppRole = this.getRelationRoleDescriptor(ejbName, fieldName, false);
        return oppRole.getIsMany() ? "Many" : "One";
    }

    public String getRelationshipFieldContent(String ejbName, String fieldName) {
        RelationRoleDescriptor oppRole = this.getRelationRoleDescriptor(ejbName, fieldName, false);
        return oppRole.getOwner().getName();
    }

    public String getInverseFieldName(String ejbName, String fieldName) {
        RelationRoleDescriptor oppRole = this.getRelationRoleDescriptor(ejbName, fieldName, false);
        String inverseName = oppRole.getCMRField();
        if (this.generateFields && inverseName == null) {
            inverseName = this.nameMapper.getGeneratedFieldForEjbField(ejbName, fieldName)[1];
        }
        return inverseName;
    }

    public boolean applyDefaultUnknownPKClassStrategy(String ejbName) {
        IASEjbCMPEntityDescriptor ejbDesc = (IASEjbCMPEntityDescriptor)this.ejbDescMap.get(ejbName);
        String keyClassName = ejbDesc.getPrimaryKeyClassName();
        return keyClassName != null && keyClassName.equals(Object.class.getName());
    }

    public String getGeneratedPKFieldName() {
        return "generatedPKField";
    }

    public String getGeneratedVersionFieldNamePrefix() {
        return "thisVersionFieldWasGeneratedByTheNameMapper";
    }

    public boolean relatedObjectsAreDeleted(String beanName, String fieldName) {
        RelationRoleDescriptor oppRole = this.getRelationRoleDescriptor(beanName, fieldName, false);
        return oppRole.getCascadeDelete();
    }

    public boolean generateFields() {
        return this.generateFields;
    }

    public void setGenerateFields(boolean generateFields) {
        this.generateFields = generateFields;
    }

    public boolean ensureValidation() {
        return this.ensureValidation;
    }

    public void setEnsureValidation(boolean isValidating) {
        this.ensureValidation = isValidating;
    }

    public boolean isGeneratedField(String ejbName, String fieldName) {
        return this.nameMapper.isGeneratedField(ejbName, fieldName);
    }

    public boolean isGeneratedRelationship(String ejbName, String fieldName) {
        return this.nameMapper.isGeneratedEjbRelationship(ejbName, fieldName);
    }

    public List getGeneratedRelationships(String ejbName) {
        return this.nameMapper.getGeneratedRelationshipsForEjbName(ejbName);
    }

    private RelationRoleDescriptor getRelationRoleDescriptor(String ejbName, String cmrFieldName, boolean self) {
        String myEjbName = ejbName;
        String myCMRFieldName = cmrFieldName;
        boolean myself = self;
        if (this.isGeneratedRelationship(ejbName, cmrFieldName)) {
            String[] nfPair = this.nameMapper.getEjbFieldForGeneratedField(ejbName, cmrFieldName);
            myEjbName = nfPair[0];
            myCMRFieldName = nfPair[1];
            myself = !self;
        }
        return this.getRealRelationRoleDescriptor(myEjbName, myCMRFieldName, myself);
    }

    private RelationRoleDescriptor getRealRelationRoleDescriptor(String ejbName, String cmrFieldName, boolean self) {
        ArrayList rels = (ArrayList)this.ejbRelMap.get(ejbName);
        for (int i = 0; i < rels.size(); ++i) {
            RelationshipDescriptor rel = (RelationshipDescriptor)rels.get(i);
            RelationRoleDescriptor source = rel.getSource();
            RelationRoleDescriptor sink = rel.getSink();
            if (ejbName.equals(source.getOwner().getName()) && cmrFieldName.equals(source.getCMRField())) {
                return self ? source : sink;
            }
            if (!ejbName.equals(sink.getOwner().getName()) || !cmrFieldName.equals(sink.getCMRField())) continue;
            return self ? sink : source;
        }
        throw new IllegalArgumentException();
    }

    private void addField(String ejbName, String fieldName) {
        HashMap<String, String> fieldMap = (HashMap<String, String>)this.ejbFieldMap.get(ejbName);
        if (fieldMap == null) {
            fieldMap = new HashMap<String, String>();
            this.ejbFieldMap.put(ejbName, fieldMap);
        }
        fieldMap.put(fieldName, fieldName);
    }
}

