/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.FileCacheStatsProvider;
import com.sun.grizzly.http.FileCache;

public class MonitorableFileCache
extends FileCache {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public MonitorableFileCache(GrizzlyMonitoring grizzlyMonitoring, String monitoringId) {
        FileCacheStatsProvider statsProvider;
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null && (statsProvider = grizzlyMonitoring.getFileCacheStatsProvider(monitoringId)) != null) {
            statsProvider.setStatsObject((Object)this);
        }
    }

    protected void recalcCacheStatsIfMonitoring(FileCache.FileCacheEntry entry) {
        this.recalcCacheStats(entry);
    }

    protected void countHit() {
        super.countHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countHitEvent(this.monitoringId);
    }

    protected void countMiss() {
        super.countMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countMissEvent(this.monitoringId);
    }

    protected void countInfoHit() {
        super.countInfoHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countInfoHitEvent(this.monitoringId);
    }

    protected void countInfoMiss() {
        super.countInfoMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countInfoMissEvent(this.monitoringId);
    }

    protected void countContentHit() {
        super.countContentHit();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countContentHitEvent(this.monitoringId);
    }

    protected void countContentMiss() {
        super.countContentMiss();
        this.grizzlyMonitoring.getFileCacheProbeProvider().countContentMissEvent(this.monitoringId);
    }

    protected void incOpenCacheEntries() {
        super.incOpenCacheEntries();
        this.grizzlyMonitoring.getFileCacheProbeProvider().incOpenCacheEntriesEvent(this.monitoringId);
    }

    protected void decOpenCacheEntries() {
        super.decOpenCacheEntries();
        this.grizzlyMonitoring.getFileCacheProbeProvider().decOpenCacheEntriesEvent(this.monitoringId);
    }

    protected void addHeapSize(long size) {
        super.addHeapSize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().addHeapSizeEvent(this.monitoringId, size);
    }

    protected void subHeapSize(long size) {
        super.subHeapSize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().subHeapSizeEvent(this.monitoringId, size);
    }

    protected void addMappedMemorySize(long size) {
        super.addMappedMemorySize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().addMappedMemorySizeEvent(this.monitoringId, size);
    }

    protected void subMappedMemorySize(long size) {
        super.subMappedMemorySize(size);
        this.grizzlyMonitoring.getFileCacheProbeProvider().subMappedMemorySizeEvent(this.monitoringId, size);
    }
}

