/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.UserProperties;
import com.sun.messaging.jmq.admin.util.UserPropertiesException;
import java.util.Enumeration;
import java.util.Properties;

public class BrokerListProperties
extends UserProperties {
    public static final String FIRST_VERSION = "2.0";
    public static final String VERSION = "2.0";
    private static final String PROP_NAME_VERSION = "version";
    private static final String PROP_NAME_BROKER_BASENAME = "broker";
    private static final String PROP_NAME_BROKER_COUNT = "broker.count";
    private static final String PROP_NAME_BROKER_KEY_PREFIX = "key";
    private static final String PROP_NAME_BROKER_RECV_TIMEOUT_PREFIX = "receiveTimeout";
    private static final String PROP_NAME_BROKER_USERNAME_PREFIX = "userName";
    private static final String PROP_NAME_BROKER_PASSWD_PREFIX = "password";
    private static final String PROP_NAME_BROKER_ATTR_PREFIX = "attrs";
    private boolean DEBUG = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerListProperties() {
        this.setProperty(PROP_NAME_VERSION, "2.0");
    }

    public String getVersion() {
        String string = this.getProperty(PROP_NAME_VERSION);
        return string;
    }

    public int getBrokerCount() {
        int n;
        String string = this.getProperty(PROP_NAME_BROKER_COUNT);
        if (string == null || string.equals("")) {
            return 0;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public BrokerAdmin[] getBrokerAdmin() throws BrokerAdminException {
        int n = this.getBrokerCount();
        if (n <= 0) {
            return null;
        }
        BrokerAdmin[] brokerAdminArray = new BrokerAdmin[n];
        for (int i = 0; i < n; ++i) {
            brokerAdminArray[i] = this.getBrokerAdmin(i);
        }
        return brokerAdminArray;
    }

    public BrokerAdmin getBrokerAdmin(int n) throws BrokerAdminException {
        Properties properties = new Properties();
        String string = PROP_NAME_BROKER_BASENAME + new Integer(n).toString() + ".";
        String string2 = string + PROP_NAME_BROKER_KEY_PREFIX;
        String string3 = this.getProperty(string2, null);
        String string4 = string + PROP_NAME_BROKER_RECV_TIMEOUT_PREFIX;
        long l = -1L;
        String string5 = string + PROP_NAME_BROKER_USERNAME_PREFIX;
        String string6 = this.getProperty(string5, "");
        String string7 = string + PROP_NAME_BROKER_PASSWD_PREFIX;
        String string8 = this.getProperty(string7, "");
        String string9 = string + PROP_NAME_BROKER_ATTR_PREFIX + ".";
        int n2 = string9.length();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string10 = (String)enumeration.nextElement();
            if (!string10.startsWith(string9)) continue;
            String string11 = string10.substring(n2);
            String string12 = this.getProperty(string10);
            properties.setProperty(string11, string12);
        }
        BrokerAdmin brokerAdmin = new BrokerAdmin(properties, string6, string8, l);
        if (string3 != null) {
            brokerAdmin.setKey(string3);
        }
        return brokerAdmin;
    }

    public void addBrokerAdmin(BrokerAdmin brokerAdmin) {
        int n = this.getBrokerCount();
        if (this.DEBUG) {
            System.err.println("Setting properties:");
        }
        String string = PROP_NAME_BROKER_BASENAME + new Integer(n).toString() + ".";
        String string2 = string + PROP_NAME_BROKER_KEY_PREFIX;
        String string3 = brokerAdmin.getKey();
        this.setProperty(string2, string3);
        String string4 = string + PROP_NAME_BROKER_USERNAME_PREFIX;
        String string5 = brokerAdmin.getUserName();
        this.setProperty(string4, string5);
        String string6 = string + PROP_NAME_BROKER_PASSWD_PREFIX;
        String string7 = brokerAdmin.getPassword();
        this.setProperty(string6, string7);
        String string8 = string + PROP_NAME_BROKER_ATTR_PREFIX + ".";
        Properties properties = brokerAdmin.getBrokerAttrs();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string9 = (String)enumeration.nextElement();
            String string10 = properties.getProperty(string9);
            String string11 = string8 + string9;
            this.setProperty(string11, string10);
        }
        this.setProperty(PROP_NAME_BROKER_COUNT, new Integer(++n).toString());
    }

    public Object setProperty(String string, String string2) {
        if (this.DEBUG) {
            System.err.println("\tSetting property: " + string + "=" + string2);
        }
        return super.setProperty(string, string2);
    }

    public void load() throws UserPropertiesException, SecurityException {
        super.load();
        String string = this.getVersion();
        if (string == null) {
            return;
        }
        this.checkVersion(string, "2.0", "2.0");
    }

    private void checkVersion(String string, String string2, String string3) throws UserPropertiesException {
        double d;
        double d2;
        double d3;
        try {
            d3 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            double d4 = 0.0;
            UserPropertiesException userPropertiesException = new UserPropertiesException(acr.getString("A3080", string2));
            throw userPropertiesException;
        }
        try {
            d2 = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            double d5 = 0.0;
            UserPropertiesException userPropertiesException = new UserPropertiesException(acr.getString("A3080", string3));
            throw userPropertiesException;
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[4];
            double d6 = 0.0;
            objectArray[0] = this.getAbsoluteFileName();
            objectArray[1] = PROP_NAME_VERSION;
            objectArray[2] = string;
            objectArray[3] = string2;
            String string4 = acr.getString("A3081", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string4);
            throw userPropertiesException;
        }
        if (d < d2) {
            Object[] objectArray = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, string, string2};
            String string5 = acr.getString("A3081", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string5);
            throw userPropertiesException;
        }
        if (d > d3) {
            Object[] objectArray = new Object[]{this.getAbsoluteFileName(), PROP_NAME_VERSION, string, string2};
            String string6 = acr.getString("A3081", objectArray);
            UserPropertiesException userPropertiesException = new UserPropertiesException(string6);
            throw userPropertiesException;
        }
    }
}

