/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.DestinationName;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapterAssociation;

public class ActivationSpec
implements javax.resource.spi.ActivationSpec,
ResourceAdapterAssociation,
Serializable {
    private static final transient String AUTOACKNOWLEDGE = "Auto-acknowledge";
    private static final transient String DUPSOKACKNOWLEDGE = "Dups-ok-acknowledge";
    private static final transient String NOACKNOWLEDGE = "No-acknowledge";
    private static final transient String DURABLE = "Durable";
    private static final transient String NONDURABLE = "NonDurable";
    private static final transient String QUEUE = "javax.jms.Queue";
    private static final transient String TOPIC = "javax.jms.Topic";
    private static final transient String _className = "com.sun.messaging.jms.ra.ActivationSpec";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_AS";
    protected static final transient String _lgrMID_EET = "MQJMSRA_AS1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_AS1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_AS2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_AS3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_AS4001: ";
    private ResourceAdapter ra = null;
    private String destinationType = "javax.jms.Topic";
    private String destination = null;
    private String messageSelector = null;
    private String acknowledgeMode = "Auto-acknowledge";
    private String subscriptionDurability = "NonDurable";
    private String clientId = null;
    private String subscriptionName = null;
    private String connectionFactoryJNDIName;
    private int endpointPoolMaxSize = 15;
    private int endpointPoolSteadySize = 10;
    private int endpointPoolResizeCount = 1;
    private int endpointPoolResizeTimeout = 5;
    private int endpointExceptionRedeliveryAttempts = 6;
    private int endpointExceptionRedeliveryInterval = 500;
    private boolean sendUndeliverableMsgsToDMQ = true;
    private String addressList = null;
    private boolean addressListSet = false;
    private String customAcknowledgeMode = null;
    private String mdbName = null;
    private String userName = null;
    private String password = null;
    private boolean enableRADirect = false;
    private boolean enableAPIDirect = false;
    private transient ClassLoader contextClassLoader = null;
    private String groupName = null;
    private String raUID = null;
    private boolean inClusteredContainer = false;
    private boolean useSharedSubscriptionInClusteredContainer = true;
    private boolean deliverySerial = false;
    private String options;

    public ActivationSpec() {
        _loggerIM.entering(_className, "constructor()");
    }

    public void validate() throws InvalidPropertyException {
        _loggerIM.entering(_className, "validate()", this);
        if (!DestinationName.isSyntaxValid(this.destination)) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:Invalid destination name=" + this.destination);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.destinationType.equals(TOPIC) && this.subscriptionDurability.equals(DURABLE) && (this.subscriptionName == null || "".equals(this.subscriptionName) || this.clientId == null || "".equals(this.clientId))) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:Both subscriptionName and clientId must be non-null\n\tsubscriptionName=" + this.subscriptionName + "\n\tclientId=" + this.clientId);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointExceptionRedeliveryInterval < 1) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointExceptionRedeliveryInterval must be greater than 0\nInvalid value=" + this.endpointExceptionRedeliveryInterval);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointExceptionRedeliveryAttempts < 0) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointExceptionRedeliveryAttempts must be greater than or equal to 0\nInvalid value=" + this.endpointExceptionRedeliveryAttempts);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointPoolResizeTimeout < 1) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolResizeTimeout must be greater than 0\nInvalid value=" + this.endpointPoolResizeTimeout);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointPoolResizeCount < 1) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolResizeCount must be greater than 0\nInvalid value=" + this.endpointPoolResizeCount);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointPoolMaxSize < 1) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolMaxSize must be greater than 0\nInvalid value=" + this.endpointPoolMaxSize);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointPoolSteadySize < 0) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolSteadySize must be greater than or equal to 0\nInvalid value=" + this.endpointPoolSteadySize);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        if (this.endpointPoolSteadySize > this.endpointPoolMaxSize) {
            InvalidPropertyException invalidPropertyException = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolSteadySize must be less than or equal to endpointPoolMaxSize\nendpointPoolSteadySize value=" + this.endpointPoolSteadySize + "\nendpointPoolMaxSize value=" + this.endpointPoolSteadySize);
            _loggerIM.throwing(_className, "validate()", invalidPropertyException);
            throw invalidPropertyException;
        }
        _loggerIM.exiting(_className, "validate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter) throws ResourceException {
        _loggerIM.entering(_className, "setResourceAdapter()", resourceAdapter);
        ActivationSpec activationSpec = this;
        synchronized (activationSpec) {
            if (this.ra == null) {
                if (!(resourceAdapter instanceof ResourceAdapter)) {
                    ResourceException resourceException = new ResourceException("MQJMSRA_AS4001: setResourceAdapter:Incompatible ResourceAdapter class=" + resourceAdapter.getClass());
                    _loggerIM.warning(resourceException.getMessage());
                    _loggerIM.throwing(_className, "setResourceAdapter()", resourceException);
                    throw resourceException;
                }
                this.ra = (ResourceAdapter)resourceAdapter;
                this.groupName = this.ra.getGroupName();
                this.inClusteredContainer = this.ra.getInClusteredContainer();
                this.raUID = this.ra._getRAUID();
                if (!this.addressListSet) {
                    this.enableRADirect = this.ra._isRADirect();
                    this.enableAPIDirect = this.ra._isAPIDirect();
                }
            } else {
                ResourceException resourceException = new ResourceException("MQJMSRA_AS4001: setResourceAdapter:Illegal to re-associate ResourceAdapter");
                _loggerIM.warning(resourceException.getMessage());
                _loggerIM.throwing(_className, "setResourceAdapter()", resourceException);
                throw resourceException;
            }
        }
        _loggerIM.exiting(_className, "setResourceAdapter()");
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        _loggerIM.entering(_className, "getResourceAdapter()");
        return this.ra;
    }

    public void setDestinationType(String string) {
        _loggerIM.entering(_className, "setDestinationType()", string);
        if (!QUEUE.equals(string) && !TOPIC.equals(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setDestinationType:Invalid destinationType=" + string);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setDestinationType()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.destinationType = string;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestination(String string) {
        _loggerIM.entering(_className, "setDestination()", string);
        if (!DestinationName.isSyntaxValid(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setDestination:Invalid destination name=" + string);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setDestination()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.destination = string;
    }

    public String getDestination() {
        _loggerIM.entering(_className, "getDestination()", this.destination);
        return this.destination;
    }

    public void setMessageSelector(String string) {
        _loggerIM.entering(_className, "setMessageSelector()", string);
        this.messageSelector = string;
    }

    public String getMessageSelector() {
        _loggerIM.entering(_className, "getMessageSelector()", this.messageSelector);
        return this.messageSelector;
    }

    public void setAcknowledgeMode(String string) {
        _loggerIM.entering(_className, "setAcknowledgeMode()", string);
        if (!AUTOACKNOWLEDGE.equals(string) && !DUPSOKACKNOWLEDGE.equals(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setAcknowledgeMode:Invalid acknowledgeMode=" + string);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setAcknowledgeMode()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.acknowledgeMode = string;
    }

    public String getAcknowledgeMode() {
        _loggerIM.entering(_className, "getAcknowledgeMode()", this.acknowledgeMode);
        return this.acknowledgeMode;
    }

    public void setCustomAcknowledgeMode(String string) {
        _loggerIM.entering(_className, "setCustomAcknowledgeMode()", string);
        if (!NOACKNOWLEDGE.equals(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setCustomAcknowledgeMode:Invalid customAcknowledgeMode=" + string);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setCustomAcknowledgeMode()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.customAcknowledgeMode = string;
    }

    public String getCustomAcknowledgeMode() {
        _loggerIM.entering(_className, "getCustomAcknowledgeMode()", this.customAcknowledgeMode);
        return this.customAcknowledgeMode;
    }

    public void setSubscriptionDurability(String string) {
        _loggerIM.entering(_className, "setSubscriptionDurability()", string);
        if (!DURABLE.equals(string) && !NONDURABLE.equals(string)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setSubscriptionDurability:Invalid subscriptionDurability=" + string);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setSubscriptionDurability()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.subscriptionDurability = string;
    }

    public String getSubscriptionDurability() {
        _loggerIM.entering(_className, "getSubscriptionDurability()", this.subscriptionDurability);
        return this.subscriptionDurability;
    }

    public void setClientId(String string) {
        _loggerIM.entering(_className, "setClientId()", string);
        this.clientId = string;
    }

    public String getClientId() {
        _loggerIM.entering(_className, "getClientId()", this.clientId);
        return this.clientId;
    }

    public void setSubscriptionName(String string) {
        _loggerIM.entering(_className, "setSubscriptionName()", string);
        this.subscriptionName = string;
    }

    public String getSubscriptionName() {
        _loggerIM.entering(_className, "getSubscriptionName()", this.subscriptionName);
        return this.subscriptionName;
    }

    public void _setConnectionFactoryJNDIName(String string) {
        _loggerIM.entering(_className, "_setConnectionFactoryJNDIName()", string);
        this.connectionFactoryJNDIName = string;
    }

    public String _getConnectionFactoryJNDIName() {
        _loggerIM.entering(_className, "_getConnectionFactoryJNDIName()", this.connectionFactoryJNDIName);
        return this.connectionFactoryJNDIName;
    }

    public void setEndpointPoolMaxSize(int n) {
        _loggerIM.entering(_className, "setEndpointPoolMaxSize()", Integer.toString(n));
        if (n < 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolMaxSize:Value must be greater than 0Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolMaxSize()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointPoolMaxSize = n;
    }

    public int getEndpointPoolMaxSize() {
        _loggerIM.entering(_className, "getEndpointPoolMaxSize()", Integer.toString(this.endpointPoolMaxSize));
        return this.endpointPoolMaxSize;
    }

    public void setEndpointPoolSteadySize(int n) {
        _loggerIM.entering(_className, "setEndpointPoolSteadySize()", Integer.toString(n));
        if (n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolSteadySize:Value must be greater than or equal to 0Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolSteadySize()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointPoolSteadySize = n;
    }

    public int getEndpointPoolSteadySize() {
        _loggerIM.entering(_className, "getEndpointPoolSteadySize()", Integer.toString(this.endpointPoolSteadySize));
        return this.endpointPoolSteadySize;
    }

    public void setEndpointPoolResizeCount(int n) {
        _loggerIM.entering(_className, "setEndpointPoolResizeCount()", Integer.toString(n));
        if (n < 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolResizeCount:Value must be greater than 0:Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolResizeCount()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointPoolResizeCount = n;
    }

    public int getEndpointPoolResizeCount() {
        _loggerIM.entering(_className, "getEndpointPoolResizeCount()", Integer.toString(this.endpointPoolResizeCount));
        return this.endpointPoolResizeCount;
    }

    public void setEndpointPoolResizeTimeout(int n) {
        _loggerIM.entering(_className, "setEndpointPoolResizeTimeout()", Integer.toString(n));
        if (n < 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolResizeTimeout:Value must be greater than 0:Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolResizeTimeout()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointPoolResizeTimeout = n;
    }

    public int getEndpointPoolResizeTimeout() {
        _loggerIM.entering(_className, "getEndpointPoolResizeTimeout()", Integer.toString(this.endpointPoolResizeTimeout));
        return this.endpointPoolResizeTimeout;
    }

    public void setEndpointExceptionRedeliveryAttempts(int n) {
        _loggerIM.entering(_className, "setEndpointExceptionRedeliveryAttempts()", Integer.toString(n));
        if (n < 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointExceptionRedeliveryAttempts:Value must be greater than or equal to 0:Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointExceptionRedeliveryAttempts()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointExceptionRedeliveryAttempts = n;
    }

    public int getEndpointExceptionRedeliveryAttempts() {
        _loggerIM.entering(_className, "getEndpointExceptionRedeliveryAttempts()", Integer.toString(this.endpointExceptionRedeliveryAttempts));
        return this.endpointExceptionRedeliveryAttempts;
    }

    public void setEndpointExceptionRedeliveryInterval(int n) {
        _loggerIM.entering(_className, "setEndpointExceptionRedeliveryInterval()", Integer.toString(n));
        if (n < 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointExceptionRedeliveryInterval:Value must be greater than 0:Invalid value=" + n);
            _loggerIM.warning(illegalArgumentException.getMessage());
            _loggerIM.throwing(_className, "setEndpointExceptionRedeliveryInterval()", illegalArgumentException);
            throw illegalArgumentException;
        }
        this.endpointExceptionRedeliveryInterval = n;
    }

    public int getEndpointExceptionRedeliveryInterval() {
        _loggerIM.entering(_className, "getEndpointExceptionRedeliveryInterval()", Integer.toString(this.endpointExceptionRedeliveryInterval));
        return this.endpointExceptionRedeliveryInterval;
    }

    public void setSendUndeliverableMsgsToDMQ(boolean bl) {
        _loggerIM.entering(_className, "setSendUndeliverableMsgsToDMQ()", Boolean.toString(bl));
        this.sendUndeliverableMsgsToDMQ = bl;
    }

    public boolean getSendUndeliverableMsgsToDMQ() {
        _loggerIM.entering(_className, "getSendUndeliverableMsgsToDMQ()", Boolean.toString(this.sendUndeliverableMsgsToDMQ));
        return this.sendUndeliverableMsgsToDMQ;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        _loggerIM.entering(_className, "setContextClassLoader()", classLoader);
        this.contextClassLoader = classLoader;
    }

    public ClassLoader getContextClassLoader() {
        _loggerIM.entering(_className, "getContextClassLoader()", this.contextClassLoader);
        return this.contextClassLoader;
    }

    public void setAddressList(String string) {
        _loggerIM.entering(_className, "setAddressList()", string);
        this.addressList = string;
        if (string != null && !"".equals(string)) {
            this.enableRADirect = false;
            this.enableAPIDirect = false;
            this.addressListSet = true;
        }
    }

    public String getAddressList() {
        _loggerIM.entering(_className, "getAddressList()", this.addressList);
        return this.addressList;
    }

    public void setMdbName(String string) {
        _loggerIM.entering(_className, "setMdbName()", string);
        this.mdbName = string;
    }

    public String getMdbName() {
        _loggerIM.entering(_className, "getMdbName()", this.mdbName);
        return this.mdbName;
    }

    public void setUserName(String string) {
        _loggerIM.entering(_className, "setUserName()", string);
        this.userName = string;
    }

    public String getUserName() {
        _loggerIM.entering(_className, "getUserName()", this.userName);
        if (this.userName == null && this.ra != null) {
            return this.ra.getUserName();
        }
        return this.userName;
    }

    public void setPassword(String string) {
        _loggerIM.entering(_className, "setPassword()");
        this.password = string;
    }

    public String getPassword() {
        _loggerIM.entering(_className, "getPassword()");
        if (this.password == null && this.ra != null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public void setEnableRADirect(boolean bl) {
        _loggerIM.entering(_className, "setEnableRADirect()", bl);
        this.enableRADirect = bl;
    }

    public void setEnableAPIDirect(boolean bl) {
        _loggerIM.entering(_className, "setEnableAPIDirect()", bl);
        this.enableAPIDirect = bl;
    }

    public boolean getEnableRADirect() {
        _loggerIM.entering(_className, "getEnableRADirect()", this.enableRADirect);
        return this.enableRADirect;
    }

    public boolean getEnableAPIDirect() {
        _loggerIM.entering(_className, "getEnableAPIDirect()", this.enableAPIDirect);
        return this.enableAPIDirect;
    }

    public void setOptions(String string) {
        this.options = string;
    }

    public String getOptions() {
        return this.options;
    }

    protected String _AddressList() {
        if (this.addressList != null) {
            return this.addressList;
        }
        if (this.ra != null) {
            return this.ra._getEffectiveConnectionURL();
        }
        return "localhost";
    }

    public void _setDeliverySerial(boolean bl) {
        this.deliverySerial = bl;
    }

    protected boolean _getDeliverySerial() {
        return this.deliverySerial;
    }

    protected boolean _deliverySerial() {
        return this.deliverySerial;
    }

    protected String _getGroupName() {
        return this.groupName;
    }

    protected void _setGroupName(String string) {
        this.groupName = string;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected void _setRAUID(String string) {
        this.raUID = string;
    }

    protected void _setInClusteredContainer(boolean bl) {
        this.inClusteredContainer = bl;
    }

    protected boolean _isInClusteredContainerSet() {
        return this.inClusteredContainer;
    }

    protected boolean _isNoAckDeliverySet() {
        return NOACKNOWLEDGE.equals(this.customAcknowledgeMode);
    }

    protected boolean _isDurableSet() {
        return DURABLE.equals(this.subscriptionDurability);
    }

    protected boolean _isDestTypeQueueSet() {
        return QUEUE.equals(this.destinationType);
    }

    protected boolean _isDestTypeTopicSet() {
        return TOPIC.equals(this.destinationType);
    }

    protected boolean _isRADirectEnabled() {
        if (this.ra != null) {
            return this.ra._isRADirect() && this.enableRADirect;
        }
        return this.enableRADirect;
    }

    protected boolean _isAPIDirectEnabled() {
        if (this.ra != null) {
            return this.ra._isAPIDirect() && this.enableAPIDirect;
        }
        return this.enableAPIDirect;
    }

    public String toString() {
        return "ActvationSpec configuration=\n\tDestinationType                     =" + this.destinationType + "\n" + "\tDestination                         =" + this.destination + "\n" + "\tMessageSelector                     =" + this.messageSelector + "\n" + "\tAcknowledgeMode                     =" + this.acknowledgeMode + "\n" + "\tSubscriptionDurability              =" + this.subscriptionDurability + "\n" + "\tuseSharedSubscriptionInClusteredContainer=" + this.useSharedSubscriptionInClusteredContainer + "\n" + "\tClientId                            =" + this.clientId + "\n" + "\tSubscriptionName                    =" + this.subscriptionName + "\n" + "\tEndpointPoolMaxSize                 =" + this.endpointPoolMaxSize + "\n" + "\tEndpointPoolSteadySize              =" + this.endpointPoolSteadySize + "\n" + "\tEndpointPoolResizeCount             =" + this.endpointPoolResizeCount + "\n" + "\tEndpointPoolResizeTimeout           =" + this.endpointPoolResizeTimeout + "\n" + "\tEndpointExceptionRedeliveryAttempts =" + this.endpointExceptionRedeliveryAttempts + "\n" + "\tEndpointExceptionRedeliveryInterval =" + this.endpointExceptionRedeliveryInterval + "\n" + "\tSendUndeliverableMsgsToDMQ          =" + this.sendUndeliverableMsgsToDMQ + "\n" + "\tGroupName                           =" + this.groupName + "\n" + "\tRAUID                               =" + this.raUID + "\n" + "\tInClusteredContainer                =" + this.inClusteredContainer + "\n" + "\tMdbName                             =" + this.mdbName + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tEnableRADirect                      =" + this.enableRADirect + "\n" + "\tEnableAPIDirect                      =" + this.enableAPIDirect + "\n" + "\tAddressList (in effect)             =" + this._AddressList() + "\n" + "\toptions                 \t\t\t   =" + this.options + "\n";
    }

    public boolean isUseSharedSubscriptionInClusteredContainer() {
        return this.useSharedSubscriptionInClusteredContainer;
    }

    public void setUseSharedSubscriptionInClusteredContainer(boolean bl) {
        this.useSharedSubscriptionInClusteredContainer = bl;
    }
}

