/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.transaction.xa.XAResource;

public class ConnectionFactoryAdapter
extends ConnectionCreator
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private ManagedConnectionFactory mcf = null;
    private ConnectionManager cm = null;
    private Reference reference = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.ConnectionFactoryAdapter";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient String _lgrNameJMSConnectionFactory = "javax.jms.ConnectionFactory.mqjmsra";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJF = Logger.getLogger("javax.jms.ConnectionFactory.mqjmsra");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_FA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_FA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_FA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_FA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_FA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_FA4001: ";

    public ConnectionFactoryAdapter(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        Object[] objectArray = new Object[]{managedConnectionFactory, connectionManager};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.mcf = managedConnectionFactory;
        this.cm = connectionManager;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() throws NamingException {
        throw new NamingException("MQRA:CFA:getReference:NOT Supported");
    }

    public Connection createConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createConnection()");
        return this.createConnection(null, null);
    }

    public Connection createConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createConnection()", string);
        return this._allocateConnection(string, string2);
    }

    private Connection _allocateConnection(String string, String string2) throws javax.jms.JMSException {
        ConnectionAdapter connectionAdapter;
        ConnectionRequestInfo connectionRequestInfo = new ConnectionRequestInfo(this.mcf, string, string2);
        try {
            connectionAdapter = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            String string3 = "1";
            throw new JMSException("MQRA:CFA:allocation failure:createConnection:" + resourceException.getMessage(), string3, resourceException);
        }
        return connectionAdapter;
    }

    public QueueConnection createQueueConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createQueueConnection()");
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createQueueConnection()", string);
        return this._allocateQueueConnection(string, string2);
    }

    private QueueConnection _allocateQueueConnection(String string, String string2) throws javax.jms.JMSException {
        ConnectionAdapter connectionAdapter;
        ConnectionRequestInfo connectionRequestInfo = new ConnectionRequestInfo(this.mcf, string, string2);
        try {
            connectionAdapter = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)connectionRequestInfo);
        }
        catch (ResourceException resourceException) {
            String string3 = "1";
            throw new JMSException("MQRA:CFA:allocation failure:createQueueConnection:" + resourceException.getMessage(), string3, resourceException);
        }
        return connectionAdapter;
    }

    public TopicConnection createTopicConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createTopicConnection()");
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String string, String string2) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createTopicConnection()", string);
        return this._allocateTopicConnection(string, string2);
    }

    private TopicConnection _allocateTopicConnection(String string, String string2) throws javax.jms.JMSException {
        ConnectionRequestInfo connectionRequestInfo = new ConnectionRequestInfo(this.mcf, string, string2);
        try {
            ConnectionAdapter connectionAdapter = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)connectionRequestInfo);
            return connectionAdapter;
        }
        catch (ResourceException resourceException) {
            String string3 = "1";
            throw new JMSException("MQRA:CFA:allocation failure:createTopicConnection:" + resourceException.getMessage(), string3, resourceException);
        }
    }

    protected Connection _createConnection(String string, String string2) throws javax.jms.JMSException {
        return this.mcf._getXACF().createXAConnection(string, string2);
    }

    protected XAResource _createXAResource(ManagedConnection managedConnection, Object object) throws javax.jms.JMSException {
        return null;
    }
}

