/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class DirectBytesPacket
extends DirectPacket
implements BytesMessage {
    private byte[] messageBody = null;
    private int validLength = 0;
    private boolean writePerformed = false;
    private JMQByteArrayOutputStream byteArrayOutputStream = null;
    private DataOutputStream dataOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private DataInputStream dataInputStream = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectBytesPacket";

    public DirectBytesPacket(DirectSession directSession, JMSService jMSService) throws JMSException {
        super(directSession, jMSService);
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    }

    public DirectBytesPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        super(jMSPacket, l, directSession, jMSService);
        this._getMessageBodyFromPacket();
    }

    public long getBodyLength() throws JMSException {
        String string = "getBodyLength()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        if (this.messageBody != null) {
            return this.validLength;
        }
        return 0L;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
        this._initializeOutputStreams();
    }

    public boolean readBoolean() throws JMSException {
        String string = "readBoolean()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        boolean bl = false;
        try {
            bl = this.dataInputStream.readBoolean();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + bl + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return bl;
    }

    public byte readByte() throws JMSException {
        String string = "readByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        byte by = 0;
        try {
            by = this.dataInputStream.readByte();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return by;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        String string = "readBytes(byte[])";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + byArray);
        }
        this.checkForWriteOnlyMessageBody(string);
        int n = -1;
        try {
            n = this.dataInputStream.read(byArray);
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":value=" + byArray + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":value=" + byArray + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return n;
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        String string = "readBytes(byte[], length)";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + byArray);
        }
        this.checkForWriteOnlyMessageBody(string);
        int n2 = -1;
        try {
            n2 = this.dataInputStream.read(byArray, 0, n);
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":value=" + byArray + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":value=" + byArray + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return n2;
    }

    public char readChar() throws JMSException {
        String string = "readChar()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        char c = '\u0000';
        try {
            c = this.dataInputStream.readChar();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return c;
    }

    public double readDouble() throws JMSException {
        String string = "readDouble()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        double d = 0.0;
        try {
            d = this.dataInputStream.readDouble();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return d;
    }

    public float readFloat() throws JMSException {
        String string = "readFloat()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        float f = 0.0f;
        try {
            f = this.dataInputStream.readFloat();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return f;
    }

    public int readInt() throws JMSException {
        String string = "readInt()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        int n = 0;
        try {
            n = this.dataInputStream.readInt();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return n;
    }

    public long readLong() throws JMSException {
        String string = "readLong()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        long l = 0L;
        try {
            l = this.dataInputStream.readLong();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return l;
    }

    public short readShort() throws JMSException {
        String string = "readShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        short s = 0;
        try {
            s = this.dataInputStream.readShort();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return s;
    }

    public String readUTF() throws JMSException {
        String string = "readUTF()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        String string2 = null;
        try {
            string2 = this.dataInputStream.readUTF();
        }
        catch (EOFException eOFException) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string3);
            MessageEOFException messageEOFException = new MessageEOFException(string3);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string4 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string4);
            JMSException jMSException = new JMSException(string4);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return string2;
    }

    public int readUnsignedByte() throws JMSException {
        String string = "readUnsignedByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        int n = 0;
        try {
            n = this.dataInputStream.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return n;
    }

    public int readUnsignedShort() throws JMSException {
        String string = "readUnsignedShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this.checkForWriteOnlyMessageBody(string);
        int n = 0;
        try {
            n = this.dataInputStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + eOFException.getMessage();
            _loggerJM.severe(string2);
            MessageEOFException messageEOFException = new MessageEOFException(string2);
            messageEOFException.initCause((Throwable)eOFException);
            throw messageEOFException;
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        return n;
    }

    public void reset() throws JMSException {
        String string = "reset()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string);
        }
        this._reset("reset()");
    }

    public void writeBoolean(boolean bl) throws JMSException {
        String string = "writeBoolean()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + bl);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeBoolean(bl);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + bl + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeByte(byte by) throws JMSException {
        String string = "writeByte()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + by);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeByte(by);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + by + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeShort(short s) throws JMSException {
        String string = "writeShort()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + s);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + s + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeChar(char c) throws JMSException {
        String string = "writeChar()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + c);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeChar(c);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + c + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeInt(int n) throws JMSException {
        String string = "writeInt()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + n);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeInt(n);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + n + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeLong(long l) throws JMSException {
        String string = "writeLong()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + l);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeLong(l);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + l + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeFloat(float f) throws JMSException {
        String string = "writeFloat()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + f);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeFloat(f);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + f + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeDouble(double d) throws JMSException {
        String string = "writeDouble()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + d);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.writeDouble(d);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + d + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        String string = "writeBytes(byte[])";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + byArray);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.write(byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + byArray + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        String string = "writeBytes(byte[], offset, length)";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + byArray + ":offset=" + n + ":length=" + n2);
        }
        this.checkForReadOnlyMessageBody(string);
        try {
            this.dataOutputStream.write(byArray, n, n2);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + byArray + ":offset=" + n + ":length=" + n2 + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    public void writeObject(Object object) throws JMSException {
        String string = "writeObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string + ":value=" + object);
        }
        if (object == null) {
            String string2 = "MQJMSRA_DM4001: " + string + "value=NULL";
            throw new NullPointerException(string2);
        }
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + "value=" + object + ":Illegal object type=" + object.getClass().getName();
            _loggerJM.severe(string3);
            MessageFormatException messageFormatException = new MessageFormatException(string3);
            throw messageFormatException;
        }
    }

    public void writeUTF(String string) throws JMSException {
        String string2 = "writeUTF()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + string2);
        }
        this.checkForReadOnlyMessageBody(string2);
        try {
            this.dataOutputStream.writeUTF(string);
        }
        catch (Exception exception) {
            String string3 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string2 + "value=" + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
        this.writePerformed = true;
    }

    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(2);
    }

    protected void _setBodyToPacket() throws JMSException {
        this._reset("_setBodyToPacket");
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody, 0, this.validLength);
            }
            catch (Exception exception) {
                String string = "MQJMSRA_DM4001: :ERROR setting BytesMessage body:Exception=" + exception.getMessage();
                _loggerJM.severe(string);
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)exception);
                throw jMSException;
            }
        }
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
        this.validLength = this.pkt.getMessageBodySize();
        this._reset("_getMessageBodyFromPacket()");
    }

    private void _reset(String string) throws JMSException {
        super._setReadOnlyBody(true);
        try {
            if (this.writePerformed) {
                this.dataOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.getBuf();
                this.validLength = this.byteArrayOutputStream.getCount();
                this.dataOutputStream.close();
                this.byteArrayOutputStream.close();
                this.writePerformed = false;
            }
            if (this.messageBody == null) {
                this.messageBody = new byte[0];
                this.validLength = 0;
            }
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody, 0, this.validLength);
            this.dataInputStream = new DataInputStream(this.byteArrayInputStream);
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DM4001: :Exception:BytesMessage." + string + ":message=" + exception.getMessage();
            _loggerJM.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    private void _initializeOutputStreams() {
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    }
}

