/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.EndpointConsumer;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class DirectMessageListener
implements MessageListener {
    private DirectConnection dc;
    private DirectSession ds;
    private Method onMessageMethod;
    private int dMLId = -1;
    private boolean isDeliveryTransacted = false;
    private int maxRedeliverCount = 1;
    private boolean noAckDelivery = false;
    private MessageEndpoint msgEndpoint = null;
    private DirectXAResource dxar = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectMessageListener";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_DML";
    protected static final transient String _lgrMID_EET = "MQJMSRA_DML1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_DML1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_DML2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_DML3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_DML4001: ";
    private static int idCounter = 0;

    public DirectMessageListener(EndpointConsumer endpointConsumer, MessageEndpointFactory messageEndpointFactory, DirectConnection directConnection, DirectSession directSession, Method method, boolean bl, int n, boolean bl2) {
        Object[] objectArray = new Object[]{endpointConsumer, messageEndpointFactory, directConnection, directSession, method, bl, n, bl2};
        _loggerIM.entering(_className, "constructor()", objectArray);
        this.dc = directConnection;
        this.ds = directSession;
        this.onMessageMethod = method;
        this.isDeliveryTransacted = bl;
        this.maxRedeliverCount = n;
        this.noAckDelivery = bl2;
        this.dxar = new DirectXAResource(this.dc, this.dc._getJMSService(), this.dc.getConnectionId());
        this.dxar._setUsedByMDB(true);
        try {
            this.msgEndpoint = messageEndpointFactory.createEndpoint((XAResource)this.dxar);
        }
        catch (UnavailableException unavailableException) {
            System.out.println("DirectMessageListener-Exception creating Endpoint:" + unavailableException.getMessage());
            unavailableException.printStackTrace();
        }
    }

    public void onMessage(Message message) {
        DirectPacket directPacket = (DirectPacket)message;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 0;
        while (bl3) {
            if (this.isDeliveryTransacted) {
                try {
                    this.msgEndpoint.beforeDelivery(this.onMessageMethod);
                }
                catch (ResourceException resourceException) {
                    resourceException.printStackTrace();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            try {
                ((MessageListener)this.msgEndpoint).onMessage(message);
                bl = true;
                bl3 = false;
                try {
                    directPacket._acknowledgeThisMessageForMDB(this.dxar);
                    bl2 = true;
                    this.dxar.setRollback(false, null);
                }
                catch (JMSException jMSException) {
                    jMSException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (n > this.maxRedeliverCount) {
                    bl3 = false;
                    this.dxar.setRollback(true, exception);
                }
                ++n;
            }
            if (!this.isDeliveryTransacted) continue;
            try {
                this.msgEndpoint.afterDelivery();
            }
            catch (ResourceException resourceException) {
                resourceException.printStackTrace();
            }
        }
        if (!bl2) {
            // empty if block
        }
    }
}

