/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class DirectProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private JMSService jmsservice;
    private DirectSession ds;
    private long connectionId;
    private long sessionId;
    private long producerId = 0L;
    private JMSService.MessageDeliveryMode deliveryMode;
    private int jmsDeliveryMode = 2;
    private JMSService.MessagePriority priority;
    private int jmsPriority = 4;
    private long jmsTimeToLive = 0L;
    private javax.jms.Destination destination = null;
    private Destination jmsservice_destination;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private boolean isClosed;
    private boolean isClosing;
    private HashMap<String, Long> producerIds;
    protected int _logLevel;
    protected boolean _logFINE = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectProducer";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSProducer = "javax.jms.MessageProducer.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJMP = Logger.getLogger("javax.jms.MessageProducer.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DMP";
    private static final transient String _lgrMID_EET = "MQJMSRA_DMP1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DMP1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DMP2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DMP3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DMP4001: ";

    public DirectProducer(DirectSession directSession, JMSService jMSService) {
        Object[] objectArray = new Object[]{directSession, jMSService};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.ds = directSession;
        this.jmsservice = jMSService;
        this.connectionId = directSession.getConnectionId();
        this.sessionId = directSession.getSessionId();
        this.producerIds = new HashMap();
    }

    public DirectProducer(DirectSession directSession, JMSService jMSService, long l, javax.jms.Destination destination, Destination destination2) {
        Object[] objectArray = new Object[]{directSession, jMSService, l, destination, destination2};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.ds = directSession;
        this.jmsservice = jMSService;
        this.producerId = l;
        this.destination = destination;
        if (this.destination == null) {
            this.producerIds = new HashMap();
        }
        this.jmsservice_destination = destination2;
        this.connectionId = directSession.getConnectionId();
        this.sessionId = directSession.getSessionId();
        Level level = _loggerJMP.getLevel();
        if (level != null) {
            this._logLevel = level.intValue();
            if (this._logLevel <= Level.FINE.intValue()) {
                this._logFINE = true;
            }
        }
    }

    public synchronized void close() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "close():");
        if (this.isClosed) {
            return;
        }
        this.ds.removeProducer(this);
        this._close();
    }

    public int getDeliveryMode() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "getDeliveryMode():" + (Object)((Object)this.deliveryMode));
        this._checkIfClosed("getDeliveryMode()");
        return this.jmsDeliveryMode;
    }

    public javax.jms.Destination getDestination() throws JMSException {
        String string = "getDestination()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string + (this.jmsservice_destination == null ? null : this.jmsservice_destination.toString()));
        this._checkIfClosed("getDestination()");
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "getDisableMessageID():" + this.disableMessageID);
        this._checkIfClosed("getDisableMessageID()");
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "getDisableMessageTimestamp():" + this.disableMessageTimestamp);
        this._checkIfClosed("getDisableMessageTimestamp()");
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "getPriority():" + (Object)((Object)this.priority));
        this._checkIfClosed("getPriority()");
        return this.jmsPriority;
    }

    public long getTimeToLive() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "getTimeToLive():" + this.jmsTimeToLive);
        this._checkIfClosed("getTimeToLive()");
        return this.jmsTimeToLive;
    }

    public void send(javax.jms.Destination destination, Message message) throws JMSException {
        String string = "send(Destination, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, destination);
        this._createAndAddProducerId(destination);
        this._send(destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(javax.jms.Destination destination, Message message, int n, int n2, long l) throws JMSException {
        String string = "send(Destination, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, destination);
        this._createAndAddProducerId(destination);
        this._send(destination, message, n, n2, l);
    }

    public void send(Message message) throws JMSException {
        String string = "send(Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkForUnsupportedOperation(string, null, true);
        this._send(this.destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        String string = "send(Message, deliveryMode, priority, timeToLive)";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        this._checkIfClosed(string);
        this._checkForUnsupportedOperation(string, null, true);
        this._send(this.destination, message, n, n2, l);
    }

    public void setDeliveryMode(int n) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "setDeliveryMode():" + n);
        this._checkIfClosed("getDeliveryMode()");
        switch (n) {
            case 2: {
                this.deliveryMode = JMSService.MessageDeliveryMode.PERSISTENT;
                this.jmsDeliveryMode = 2;
                break;
            }
            case 1: {
                this.deliveryMode = JMSService.MessageDeliveryMode.NON_PERSISTENT;
                this.jmsDeliveryMode = 1;
                break;
            }
            default: {
                String string = "MQJMSRA_DMP4001: setDeliveryMode():Invalid deliveryMode=" + n;
                _loggerJMP.warning(string);
                throw new JMSException(string);
            }
        }
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "setDisableMessageID():" + bl);
        this._checkIfClosed("setDisableMessageID()");
        this.disableMessageID = bl;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "setDisableMessageTimestamp():" + bl);
        this._checkIfClosed("setDisableMessageTimestamp()");
        this.disableMessageTimestamp = bl;
    }

    public void setPriority(int n) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "setPriority():" + n);
        this._checkIfClosed("setPriority()");
        switch (n) {
            case 0: {
                this.priority = JMSService.MessagePriority.PRIORITY_0;
                break;
            }
            case 1: {
                this.priority = JMSService.MessagePriority.PRIORITY_1;
                break;
            }
            case 2: {
                this.priority = JMSService.MessagePriority.PRIORITY_2;
                break;
            }
            case 3: {
                this.priority = JMSService.MessagePriority.PRIORITY_3;
                break;
            }
            case 4: {
                this.priority = JMSService.MessagePriority.PRIORITY_4;
                break;
            }
            case 5: {
                this.priority = JMSService.MessagePriority.PRIORITY_5;
                break;
            }
            case 6: {
                this.priority = JMSService.MessagePriority.PRIORITY_6;
                break;
            }
            case 7: {
                this.priority = JMSService.MessagePriority.PRIORITY_7;
                break;
            }
            case 8: {
                this.priority = JMSService.MessagePriority.PRIORITY_8;
                break;
            }
            case 9: {
                this.priority = JMSService.MessagePriority.PRIORITY_9;
                break;
            }
            default: {
                String string = "MQJMSRA_DMP4001: setPriority():Invalid to set priority outside (0-9):value=" + n;
                _loggerJMP.warning(string);
                throw new JMSException(string);
            }
        }
        this.jmsPriority = n;
    }

    public void setTimeToLive(long l) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + "setTimeToLive():" + l);
        this._checkIfClosed("setTimeToLive()" + l);
        if (l < 0L) {
            String string = "MQJMSRA_DMP4001: setTimeToLive():Invalid to set timeToLive as negative:value=" + l;
            _loggerJMP.warning(string);
            throw new JMSException(string);
        }
        this.jmsTimeToLive = l;
    }

    public Queue getQueue() throws JMSException {
        String string = "getQueue()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        this._checkIfClosed(string);
        if (this.destination == null) {
            return null;
        }
        if (this.destination instanceof Queue) {
            return (Queue)this.destination;
        }
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string + " called on Destination:" + this.destination);
        return null;
    }

    public void send(Queue queue, Message message) throws JMSException {
        String string = "send(Queue, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, (javax.jms.Destination)queue);
        this._createAndAddProducerId((javax.jms.Destination)queue);
        this._send((javax.jms.Destination)queue, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        String string = "send(Queue, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, (javax.jms.Destination)queue);
        this._createAndAddProducerId((javax.jms.Destination)queue);
        this._send((javax.jms.Destination)queue, message, n, n2, l);
    }

    public Topic getTopic() throws JMSException {
        String string = "getTopic()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        this._checkIfClosed(string);
        if (this.destination == null) {
            return null;
        }
        if (this.destination instanceof Topic) {
            return (Topic)this.destination;
        }
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string + " called on Destination:" + this.destination);
        return null;
    }

    public void publish(Message message) throws JMSException {
        String string = "publish(Message)";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        this._checkIfClosed(string);
        this._checkForUnsupportedOperation(string, null, true);
        this._send(this.destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void publish(Message message, int n, int n2, long l) throws JMSException {
        String string = "publish(Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkForUnsupportedOperation(string, null, true);
        this._send(this.destination, message, n, n2, l);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        String string = "publish(Topic, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, (javax.jms.Destination)topic);
        this._createAndAddProducerId((javax.jms.Destination)topic);
        this._send((javax.jms.Destination)topic, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        String string = "publish(Topic, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkDestinationParam(string, (javax.jms.Destination)topic);
        this._createAndAddProducerId((javax.jms.Destination)topic);
        this._send((javax.jms.Destination)topic, message, n, n2, l);
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private void _checkIfClosed(String string) throws JMSException {
        if (this.isClosed()) {
            String string2 = _lgrMID_EXC + string + "MessageProducer is closed:Id=" + this.producerId;
            _loggerJMP.warning(string2);
            throw new IllegalStateException(string2);
        }
    }

    private void _createAndAddProducerId(javax.jms.Destination destination) throws JMSException {
        String string = null;
        String string2 = null;
        Destination.Type type = Destination.Type.QUEUE;
        Destination.Life life = Destination.Life.STANDARD;
        if (destination instanceof Queue) {
            string = ((Queue)destination).getQueueName();
            type = Destination.Type.QUEUE;
            if (destination instanceof TemporaryQueue) {
                life = Destination.Life.TEMPORARY;
                string2 = string;
            } else {
                string2 = (Object)((Object)type) + string;
            }
        }
        if (destination instanceof Topic) {
            string = ((Topic)destination).getTopicName();
            type = Destination.Type.TOPIC;
            if (destination instanceof TemporaryTopic) {
                life = Destination.Life.TEMPORARY;
                string2 = string;
            } else {
                string2 = (Object)((Object)type) + ":" + string;
            }
        }
        Destination destination2 = new Destination(string, type, life);
        this.ds.getConnection()._createDestination(destination2);
        if (!this.producerIds.containsKey(string2)) {
            long l = this.ds._createProducerId(destination2);
            this.producerIds.put(string2, l);
        }
    }

    private void _checkDestinationParam(String string, javax.jms.Destination destination) throws JMSException {
        if (destination == null) {
            String string2 = _lgrMID_EXC + string + ":Null Destination used:";
            _loggerJMP.warning(string2);
            throw new InvalidDestinationException(string2);
        }
        this._checkForUnsupportedOperation(string, destination, false);
    }

    private void _checkForUnsupportedOperation(String string, javax.jms.Destination destination, boolean bl) {
        if (!bl) {
            if (this.destination != null) {
                String string2 = null;
                String string3 = null;
                try {
                    string3 = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
                }
                catch (JMSException jMSException) {
                    string3 = "null";
                }
                string2 = _lgrMID_EXC + string + ":Unsupported Operation:" + "Producing to destination:" + string3 + ":in MessageProducer with specified Destination";
                if (this.jmsservice_destination != null) {
                    string2 = string2 + "=" + (Object)((Object)this.jmsservice_destination.getType()) + ":" + this.jmsservice_destination.getName();
                }
                _loggerJMP.warning(string2);
                throw new UnsupportedOperationException(string2);
            }
        } else if (this.destination == null) {
            String string4 = _lgrMID_EXC + string + ":Unsupported Operation:" + "Producing destination not specified (null) " + "in MessageProducer with unspecified Destination";
            _loggerJMP.warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    private void _send(javax.jms.Destination destination, Message message, int n, int n2, long l) throws JMSException {
        DirectPacket directPacket = null;
        DirectPacket directPacket2 = null;
        boolean bl = false;
        if (message instanceof DirectPacket) {
            directPacket2 = (DirectPacket)message;
        } else {
            directPacket2 = DirectPacket.constructFromForeignMessage(this.jmsservice, this.ds, message);
            bl = true;
        }
        assert (directPacket2 != null);
        directPacket2.setJMSDestination(destination);
        directPacket2.setJMSDeliveryMode(n);
        directPacket2.setJMSPriority(n2);
        directPacket2.setJMSExpiration(l);
        directPacket2.preparePacketForSend();
        directPacket = directPacket2;
        this.ds._sendMessage(directPacket);
        if (bl) {
            DirectPacket.updateForeignMessageAfterSend(directPacket2, message);
        }
    }

    protected synchronized void _close() throws JMSException {
        block7: {
            if (this.isClosed) {
                return;
            }
            this.isClosing = true;
            try {
                if (this.destination != null) {
                    this.jmsservice.deleteProducer(this.connectionId, this.sessionId, this.producerId);
                    break block7;
                }
                String string = null;
                Iterator<String> iterator = this.producerIds.keySet().iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    long l = this.producerIds.get(string);
                    try {
                        this.jmsservice.deleteProducer(this.connectionId, this.sessionId, l);
                    }
                    catch (JMSServiceException jMSServiceException) {
                        _loggerJMP.warning("MQJMSRA_DMP2001: producerId=" + l + ":" + "close():" + "JMSService.deleteProducer():" + "Destination=:" + string + ":JMSServiceException=" + jMSServiceException.getMessage());
                    }
                    iterator.remove();
                }
                this.producerIds.clear();
            }
            catch (JMSServiceException jMSServiceException) {
                _loggerJMP.warning("MQJMSRA_DMP2001: producerId=" + this.producerId + ":" + "close():" + "JMSService.deleteProducer():" + "Destination=:" + this.destination + ":JMSServiceException=" + jMSServiceException.getMessage());
            }
        }
        this.isClosed = true;
        this.isClosing = false;
    }
}

