/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.ra.DirectAck;
import com.sun.messaging.jms.ra.DirectBytesPacket;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectConsumer;
import com.sun.messaging.jms.ra.DirectMapPacket;
import com.sun.messaging.jms.ra.DirectObjectPacket;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectProducer;
import com.sun.messaging.jms.ra.DirectQueueBrowser;
import com.sun.messaging.jms.ra.DirectStreamPacket;
import com.sun.messaging.jms.ra.DirectTextPacket;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.MessageListener;
import com.sun.messaging.jms.ra.TemporaryDestination;
import com.sun.messaging.jms.ra.TemporaryQueue;
import com.sun.messaging.jms.ra.TemporaryTopic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class DirectSession
implements Session,
QueueSession,
TopicSession {
    protected JMSService jmsservice;
    protected DirectConnection dc;
    protected long connectionId;
    protected long sessionId;
    protected JMSService.SessionAckMode ackMode;
    protected boolean isClosed;
    protected boolean isClosing;
    protected boolean isStopped;
    protected boolean isAsync;
    protected boolean inDeliver;
    protected long deliverThreadId = 0L;
    protected boolean enableThreadCheck = false;
    protected boolean isMDBSession = false;
    private boolean isXATransacted;
    protected long transactionId = 0L;
    protected boolean ackOnFetch = false;
    private transient Vector<DirectConsumer> consumers = null;
    private transient Vector<DirectConsumer> asyncConsumers = null;
    private transient Vector<DirectProducer> producers = null;
    private transient Vector<DirectQueueBrowser> browsers = null;
    private transient ArrayList<SysMessageID> unackedMessageIDs = null;
    private transient ArrayList<Long> unackedConsumerIDs = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectSession";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSSession = "javax.jms.Session.mqjmsra";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJS = Logger.getLogger("javax.jms.Session.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DS";
    protected static final transient String _lgrMID_EET = "MQJMSRA_DS1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_DS1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_DS2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_DS3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_DS4001: ";
    protected static int _logLevel;
    protected static boolean _logFINE;

    public DirectSession(DirectConnection directConnection, JMSService jMSService, long l, JMSService.SessionAckMode sessionAckMode) throws JMSException {
        Object[] objectArray = new Object[]{directConnection, jMSService, l, sessionAckMode};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.dc = directConnection;
        this.jmsservice = jMSService;
        this.connectionId = directConnection.getConnectionId();
        this.sessionId = l;
        this.ackMode = sessionAckMode;
        this.producers = new Vector();
        this.consumers = new Vector();
        this.asyncConsumers = new Vector();
        this.browsers = new Vector();
        this.unackedMessageIDs = new ArrayList();
        this.unackedConsumerIDs = new ArrayList();
        this._initSession();
    }

    public synchronized void close() throws JMSException {
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + "close()");
        if (this.isClosed) {
            return;
        }
        this.dc.removeSession(this);
        this._close();
    }

    public void commit() throws JMSException {
        String string = "commit()";
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        this._checkIfClosed(string);
        this._checkTransactedState(string, true);
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.commitTransaction(this.connectionId, this.transactionId, null, 0);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + string + ":JMSServiceException=" + jMSServiceException.getMessage());
        }
        this._startTransaction(string);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this._createAndAddBrowser("createBrowser(Queue)", queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return this._createAndAddBrowser("createBrowser(Queue, Selector)", queue, string);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        String string = "createBytesMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectBytesPacket(this, this.jmsservice);
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination) throws JMSException {
        return this._createAndAddConsumer("createConsumer(Destination)", destination, null, null, false);
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination, String string) throws JMSException {
        return this._createAndAddConsumer("createConsumer(Destination, selector)", destination, string, null, false);
    }

    public MessageConsumer createConsumer(javax.jms.Destination destination, String string, boolean bl) throws JMSException {
        return this._createAndAddConsumer("createConsumer(Destination, selector, noLocal)", destination, string, null, bl);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        return this._createAndAddConsumer("createDurableSubscriber(Topic, name)", (javax.jms.Destination)topic, null, string, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this._createAndAddConsumer("createDurableSubscriber(Topic, name, selector, noLocal)", (javax.jms.Destination)topic, string2, string, bl);
    }

    public MapMessage createMapMessage() throws JMSException {
        String string = "createMapMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectMapPacket(this, this.jmsservice);
    }

    public Message createMessage() throws JMSException {
        String string = "createMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectPacket(this, this.jmsservice);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        String string = "createObjectMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectObjectPacket(this, this.jmsservice, null);
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        String string = "createObjectMessage(object)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectObjectPacket(this, this.jmsservice, serializable);
    }

    public MessageProducer createProducer(javax.jms.Destination destination) throws JMSException {
        return this._createAndAddProducer("createProducer()", destination);
    }

    public Queue createQueue(String string) throws JMSException {
        String string2 = "createQueue(queueName)";
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string2 + "=" + string);
        this._checkIfClosed(string2);
        return new BasicQueue(string);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        String string = "createStreamMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectStreamPacket(this, this.jmsservice);
    }

    public javax.jms.TemporaryQueue createTemporaryQueue() throws JMSException {
        String string = "createTemporaryQueue()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        TemporaryQueue temporaryQueue = new TemporaryQueue(this.dc);
        this.dc._createDestination(temporaryQueue._getDestination());
        this.dc.addTemporaryDestination(temporaryQueue);
        return temporaryQueue;
    }

    public javax.jms.TemporaryTopic createTemporaryTopic() throws JMSException {
        String string = "createTemporaryTopic()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        TemporaryTopic temporaryTopic = new TemporaryTopic(this.dc);
        this.dc._createDestination(temporaryTopic._getDestination());
        this.dc.addTemporaryDestination(temporaryTopic);
        return temporaryTopic;
    }

    public TextMessage createTextMessage() throws JMSException {
        String string = "createTextMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return new DirectTextPacket(this, this.jmsservice, null);
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        String string2 = "createTextMessage(text)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string2);
        }
        this._checkIfClosed(string2);
        return new DirectTextPacket(this, this.jmsservice, string);
    }

    public Topic createTopic(String string) throws JMSException {
        String string2 = "createTopic(topicName)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string2 + "=" + string);
        }
        this._checkIfClosed(string2);
        return new BasicTopic(string);
    }

    public int getAcknowledgeMode() throws JMSException {
        String string = "getAcknowledgeMode()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        switch (this.ackMode) {
            case AUTO_ACKNOWLEDGE: {
                return 1;
            }
            case CLIENT_ACKNOWLEDGE: {
                return 2;
            }
            case DUPS_OK_ACKNOWLEDGE: {
                return 3;
            }
            case TRANSACTED: {
                return 0;
            }
            case NO_ACKNOWLEDGE: {
                return 32768;
            }
        }
        throw new JMSException(string + ":Unknown aknowledge mode");
    }

    public MessageListener getMessageListener() throws JMSException {
        String string = "getMessageListener()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return null;
    }

    public boolean getTransacted() throws JMSException {
        String string = "getTransacted()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        return this.ackMode == JMSService.SessionAckMode.TRANSACTED;
    }

    public void recover() throws JMSException {
        String string = "recover()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkTransactedState(string, false);
        if (this._isMDBSession() || this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
            return;
        }
        try {
            try {
                JMSServiceReply jMSServiceReply = this.jmsservice.redeliverMessages(this.connectionId, this.sessionId, this.unackedMessageIDs.toArray(new SysMessageID[0]), this.unackedConsumerIDs.toArray(new Long[0]), this.transactionId, true);
            }
            catch (JMSServiceException jMSServiceException) {
                JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
                String string2 = "unknown JMSService error";
                String string3 = "redeliverMessage on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to " + string2;
                _loggerJS.severe(string3);
                JMSException jMSException = new JMSException(string3);
                jMSException.initCause((Throwable)jMSServiceException);
                throw jMSException;
            }
            Object var9_3 = null;
            this.unackedMessageIDs.clear();
            this.unackedConsumerIDs.clear();
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            this.unackedMessageIDs.clear();
            this.unackedConsumerIDs.clear();
            throw throwable;
        }
    }

    public void rollback() throws JMSException {
        String string = "rollback()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._checkIfClosed(string);
        this._checkTransactedState(string, true);
        this._rollback(string);
        this._startTransaction(string);
    }

    public void run() {
        String string = "run()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        try {
            this._checkIfClosed(string);
            this._checkTransactedState(string, false);
            this._unsupported("Session.recover()");
        }
        catch (JMSException jMSException) {
            _loggerJS.severe(_lgrMID_EXC + "sessionId=" + this.sessionId + ":" + string + jMSException.getMessage());
            throw new RuntimeException(jMSException);
        }
    }

    public void setMessageListener(javax.jms.MessageListener messageListener) throws JMSException {
        String string = "setMessageListener()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string);
        }
        this._unsupported("Session.setMessageListener()");
        this._checkIfClosed(string);
    }

    public void unsubscribe(String string) throws JMSException {
        String string2 = "unsubscribe()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string2);
        }
        this._checkIfClosed(string2);
        if (string == null || "".equals(string)) {
            throw new InvalidDestinationException("NULL or empty name for unsubscribe");
        }
        DirectConsumer directConsumer2 = null;
        for (DirectConsumer directConsumer2 : this.dc._getDurableConsumers()) {
            if (!string.equals(directConsumer2.getDurableName())) continue;
            String string3 = "MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + string2 + ":name:" + string + ":Is in use";
            _loggerJS.warning(string3);
            JMSException jMSException = new JMSException(string3);
            throw jMSException;
        }
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, 0L, string, this.dc._getClientID());
        }
        catch (JMSServiceException jMSServiceException) {
            String string4 = "MQJMSRA_DS4001: sessionId=" + this.sessionId + ":" + string2 + ":name:" + string + ":error=" + jMSServiceException.getMessage();
            _loggerJS.warning(string4);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4);
            invalidDestinationException.initCause((Throwable)jMSServiceException);
            throw invalidDestinationException;
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this._createAndAddConsumer("createReceiver(Queue)", (javax.jms.Destination)queue, null, null, false);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        return this._createAndAddConsumer("createReceiver(Queue, selector)", (javax.jms.Destination)queue, string, null, false);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return this._createAndAddProducer("createSender(Queue)", (javax.jms.Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this._createAndAddProducer("createPublisher()", (javax.jms.Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this._createAndAddConsumer("createSubscriber(Topic)", (javax.jms.Destination)topic, null, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        return this._createAndAddConsumer("createSubscriber(Topic, selector, noLocal)", (javax.jms.Destination)topic, string, null, bl);
    }

    protected void _initSession() throws JMSException {
        String string = "_initSession()";
        _loggerOC.entering(_className, string);
        this.isAsync = false;
        this.inDeliver = false;
        this.isClosed = false;
        this.isClosing = false;
        this.isStopped = true;
        boolean bl = this.ackOnFetch = this.ackMode == JMSService.SessionAckMode.AUTO_ACKNOWLEDGE || this.ackMode == JMSService.SessionAckMode.TRANSACTED || this.ackMode == JMSService.SessionAckMode.DUPS_OK_ACKNOWLEDGE;
        if (this.isTransacted() && !this.dc.isManaged()) {
            this._startTransaction(string);
        }
        if (!this.dc.isStopped()) {
            this._start();
        }
    }

    protected void _start() {
        this.isStopped = false;
        try {
            this.jmsservice.startSession(this.connectionId, this.sessionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "_start():" + "JMSService.startSession():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    protected void _startTransaction(String string) throws JMSException {
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.startTransaction(this.connectionId, this.sessionId, null, 0, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                this.transactionId = jMSServiceReply.getJMQTransactionID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string2 = "MQJMSRA_DS4001: sessionId=" + this.sessionId + ":_startTransaction from " + string + ":JMSServiceException:Missing JMQTransactionID";
                JMSException jMSException = new JMSException(string2);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJS.severe(string2);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.severe("MQJMSRA_DS4001: sessionId=" + this.sessionId + ":_startTransaction from " + string + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    protected void _rollback(String string) throws JMSException {
        JMSServiceReply jMSServiceReply = null;
        try {
            jMSServiceReply = this.jmsservice.rollbackTransaction(this.connectionId, this.transactionId, null, true, true);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + string + ":JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    protected void _stop() {
        try {
            this.jmsservice.stopSession(this.connectionId, this.sessionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "_stop():" + "JMSService.stopSession():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
    }

    public final DirectConnection getConnection() {
        return this.dc;
    }

    public final long getConnectionId() {
        return this.connectionId;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    protected long _getTransactionId() {
        return this.transactionId;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isAsync() {
        return this.isAsync;
    }

    protected synchronized void _setAsync(boolean bl) {
        this.isAsync = bl;
    }

    protected final boolean inDeliver() {
        return this.inDeliver;
    }

    public synchronized boolean isXATransacted() {
        return this.isXATransacted;
    }

    public boolean isTransacted() {
        return this.ackMode == JMSService.SessionAckMode.TRANSACTED;
    }

    private void _checkIfClosed(String string) throws JMSException {
        if (this.isClosed()) {
            String string2 = _lgrMID_EXC + string + "Session is closed:Id=" + this.sessionId;
            _loggerJS.warning(string2);
            throw new IllegalStateException(string2);
        }
    }

    private void _checkTransactedState(String string, boolean bl) throws JMSException {
        String string2 = null;
        if (this.isTransacted() && !bl) {
            string2 = _lgrMID_EXC + string + ":Illegal for a transacted Session:sessionId=" + this.sessionId;
        } else if (!this.isTransacted() && bl) {
            string2 = _lgrMID_EXC + string + ":Illegal for a non-transacted Session:sessionId=" + this.sessionId;
        }
        if (string2 != null) {
            _loggerJS.warning(string2);
            throw new IllegalStateException(string2);
        }
    }

    protected synchronized void _close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.isClosing = true;
        if (this.isTransacted() && !this.dc.isManaged()) {
            this._rollback("_close()");
        }
        this._closeAndClearProducers();
        this._stop();
        this._closeAndClearConsumers();
        this._closeAndClearBrowsers();
        try {
            this.jmsservice.destroySession(this.connectionId, this.sessionId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "close():" + "JMSService.destroySession():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
        this.isClosed = true;
        this.isClosing = false;
    }

    private Destination _checkDestinationForConsumer(javax.jms.Destination destination) throws JMSException {
        Destination destination2 = null;
        if (destination == null) {
            String string = "MQJMSRA_DS4001: _checkDestination:Destination is null";
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string);
            _loggerJS.severe(string);
            throw invalidDestinationException;
        }
        String string = null;
        Destination.Type type = Destination.Type.QUEUE;
        Destination.Life life = Destination.Life.STANDARD;
        if (destination instanceof TemporaryDestination) {
            if (!this.dc._hasTemporaryDestination((TemporaryDestination)destination)) {
                String string2 = "MQJMSRA_DS4001: _checkDestination:Temporary Destination not owned by  parent connectionId=" + this.dc.getConnectionId();
                JMSException jMSException = new JMSException(string2);
                _loggerJS.severe(string2);
                throw jMSException;
            }
            life = Destination.Life.TEMPORARY;
        }
        if (destination instanceof Queue) {
            string = ((Queue)destination).getQueueName();
            type = Destination.Type.QUEUE;
        }
        if (destination instanceof Topic) {
            string = ((Topic)destination).getTopicName();
            type = Destination.Type.TOPIC;
        }
        destination2 = new Destination(string, type, life);
        this.dc._createDestination(destination2);
        return destination2;
    }

    private void _unsupported(String string) throws JMSException {
        String string2 = "MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + string;
        _loggerJS.warning(string2);
        throw new JMSException(string2);
    }

    protected void addConsumer(DirectConsumer directConsumer) {
        this.consumers.add(directConsumer);
    }

    protected void removeConsumer(DirectConsumer directConsumer) {
        boolean bl = this.consumers.remove(directConsumer);
        assert (bl);
    }

    protected void addProducer(DirectProducer directProducer) {
        this.producers.add(directProducer);
    }

    protected void removeProducer(DirectProducer directProducer) {
        boolean bl = this.producers.remove(directProducer);
        assert (bl);
    }

    protected void addBrowser(DirectQueueBrowser directQueueBrowser) {
        this.browsers.add(directQueueBrowser);
    }

    protected void removeBrowser(DirectQueueBrowser directQueueBrowser) {
        boolean bl = this.browsers.remove(directQueueBrowser);
        assert (bl);
    }

    protected long _createProducerId(Destination destination) throws JMSException {
        long l = 0L;
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.addProducer(this.connectionId, this.sessionId, destination);
            try {
                l = jMSServiceReply.getJMQProducerID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string = "MQJMSRA_DS4001: JMSServiceException:Missing JMQProducerID";
                JMSException jMSException = new JMSException(string);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJS.severe(string);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case FORBIDDEN: {
                    string = "client forbidden to send messages to this destination.";
                    break;
                }
                case NOT_FOUND: {
                    string = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    string = "destination limit for number of producers exceeded.";
                    break;
                }
                default: {
                    string = "unkown JMSService server error.";
                }
            }
            String string2 = "createProducer on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to " + string;
            _loggerJS.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
        return l;
    }

    private DirectProducer _createAndAddProducer(String string, javax.jms.Destination destination) throws JMSException {
        Object object;
        long l = 0L;
        Destination destination2 = null;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string + ":Destination=" + destination);
        }
        this._checkIfClosed(string);
        if (destination != null) {
            object = null;
            Destination.Type type = Destination.Type.QUEUE;
            Destination.Life life = Destination.Life.STANDARD;
            if (destination instanceof Queue) {
                object = ((Queue)destination).getQueueName();
                type = Destination.Type.QUEUE;
                if (destination instanceof javax.jms.TemporaryQueue) {
                    life = Destination.Life.TEMPORARY;
                }
            }
            if (destination instanceof Topic) {
                object = ((Topic)destination).getTopicName();
                type = Destination.Type.TOPIC;
                if (destination instanceof javax.jms.TemporaryTopic) {
                    life = Destination.Life.TEMPORARY;
                }
            }
            destination2 = new Destination((String)object, type, life);
            this.dc._createDestination(destination2);
            l = this._createProducerId(destination2);
        }
        object = new DirectProducer(this, this.jmsservice, l, destination, destination2);
        this.addProducer((DirectProducer)object);
        return object;
    }

    private DirectConsumer _createAndAddConsumer(String string, javax.jms.Destination destination, String string2, String string3, boolean bl) throws JMSException {
        long l = 0L;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string + ":Destination=" + destination + ":Selector=" + string2 + ":DurableName=" + string3 + ":noLocal=" + bl);
        }
        this._checkIfClosed(string);
        Destination destination2 = this._checkDestinationForConsumer(destination);
        DirectConsumer directConsumer = new DirectConsumer(this, this.jmsservice, destination, destination2, bl, string2, string3);
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.addConsumer(this.connectionId, this.sessionId, destination2, string2, string3, this.getConnection()._getClientID(), bl, false);
            try {
                l = jMSServiceReply.getJMQConsumerID();
                directConsumer._setConsumerId(l);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string4 = "MQJMSRA_DS4001: JMSServiceException:Missing JMQConsumerID";
                JMSException jMSException = new JMSException(string4);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJS.severe(string4);
                throw jMSException;
            }
        }
        catch (JMSServiceException jMSServiceException) {
            String string5;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            JMSException jMSException = null;
            String string6 = "createConsumer on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to ";
            switch (status) {
                case FORBIDDEN: {
                    string5 = "client forbidden to receive messages from this destination.";
                    break;
                }
                case NOT_FOUND: {
                    string5 = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    string5 = "destination limit for number of consumers exceeded.";
                    break;
                }
                case BAD_REQUEST: {
                    string5 = "invalid selector=" + string2;
                    string6 = string6 + string5;
                    jMSException = new InvalidSelectorException(string6);
                    break;
                }
                default: {
                    string5 = "unkown JMSService server error.";
                }
            }
            _loggerJS.severe(string6);
            if (jMSException == null) {
                string6 = string6 + string5;
                jMSException = new JMSException(string6);
            }
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
        this.addConsumer(directConsumer);
        if (string3 != null) {
            this.dc.addDurableConsumer(directConsumer);
        }
        if (destination instanceof TemporaryDestination) {
            this.dc._incrementTemporaryDestinationUsage((TemporaryDestination)destination);
        }
        return directConsumer;
    }

    private DirectQueueBrowser _createAndAddBrowser(String string, Queue queue, String string2) throws JMSException {
        long l = 0L;
        DirectQueueBrowser directQueueBrowser = null;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + string + ":Destination=" + queue + ":selector=" + string2);
        }
        this._checkIfClosed(string);
        Destination destination = this._checkDestinationForConsumer((javax.jms.Destination)queue);
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.addBrowser(this.connectionId, this.sessionId, destination, string2);
            try {
                l = jMSServiceReply.getJMQConsumerID();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string3 = _lgrMID_EXC + string + "JMSServiceException:Missing JMQConsumerID";
                JMSException jMSException = new JMSException(string3);
                jMSException.initCause((Throwable)noSuchFieldException);
                _loggerJS.severe(string3);
                throw jMSException;
            }
            directQueueBrowser = new DirectQueueBrowser(this, this.jmsservice, l, queue, destination, string2);
        }
        catch (JMSServiceException jMSServiceException) {
            String string4;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            JMSException jMSException = null;
            String string5 = "createBrowser on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to ";
            switch (status) {
                case FORBIDDEN: {
                    string4 = "client forbidden to receive messages from this destination.";
                    break;
                }
                case NOT_FOUND: {
                    string4 = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    string4 = "destination limit for number of consumers exceeded.";
                    break;
                }
                case BAD_REQUEST: {
                    string4 = "invalid selector=" + string2;
                    string5 = string5 + string4;
                    jMSException = new InvalidSelectorException(string5);
                    break;
                }
                default: {
                    string4 = "unkown JMSService server error.";
                }
            }
            _loggerJS.severe(string5);
            if (jMSException == null) {
                string5 = string5 + string4;
                jMSException = new JMSException(string5);
            }
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
        this.addBrowser(directQueueBrowser);
        return directQueueBrowser;
    }

    private void _closeAndClearProducers() {
        DirectProducer directProducer = null;
        Iterator<DirectProducer> iterator = this.producers.iterator();
        while (iterator.hasNext()) {
            directProducer = iterator.next();
            try {
                directProducer._close();
                iterator.remove();
            }
            catch (JMSException jMSException) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "close_producer:" + "producerId:" + directProducer.getProducerId() + ":JMSException=" + jMSException.getMessage());
            }
        }
        this.producers.clear();
    }

    private void _closeAndClearConsumers() {
        DirectConsumer directConsumer = null;
        Iterator<DirectConsumer> iterator = this.consumers.iterator();
        while (iterator.hasNext()) {
            directConsumer = iterator.next();
            try {
                directConsumer._close();
                iterator.remove();
            }
            catch (JMSException jMSException) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "close_consumer:" + "consumerId:" + directConsumer.getConsumerId() + ":JMSException=" + jMSException.getMessage());
            }
        }
        this.consumers.clear();
    }

    private void _closeAndClearBrowsers() {
        DirectQueueBrowser directQueueBrowser = null;
        Iterator<DirectQueueBrowser> iterator = this.browsers.iterator();
        while (iterator.hasNext()) {
            directQueueBrowser = iterator.next();
            try {
                directQueueBrowser._close();
                iterator.remove();
            }
            catch (JMSException jMSException) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + "close_producer:" + "consumerId:" + directQueueBrowser.getConsumerId() + ":JMSException=" + jMSException.getMessage());
            }
        }
        this.browsers.clear();
    }

    protected synchronized void _sendMessage(JMSPacket jMSPacket) throws JMSException {
        if (this.transactionId != 0L) {
            jMSPacket.getPacket().setTransactionID(this.transactionId);
        } else if (this.dc.isManaged() && this.dc.isEnlisted()) {
            jMSPacket.getPacket().setTransactionID(this.dc._getXAResource()._getTransactionId());
        } else {
            jMSPacket.getPacket().setTransactionID(0L);
            jMSPacket.getPacket().setIsTransacted(false);
        }
        try {
            this.jmsservice.sendMessage(this.connectionId, jMSPacket);
        }
        catch (JMSServiceException jMSServiceException) {
            String string = "MQJMSRA_DS4001: JMSServiceException on send message:" + jMSServiceException.getMessage();
            JMSException jMSException = new JMSException(string);
            jMSException.initCause((Throwable)jMSServiceException);
            _loggerJS.severe(string);
            throw jMSException;
        }
    }

    protected synchronized JMSAck _deliverMessage(javax.jms.MessageListener messageListener, JMSPacket jMSPacket, long l) {
        DirectAck directAck = null;
        SysMessageID sysMessageID = null;
        long l2 = 0L;
        if (this.enableThreadCheck) {
            long l3 = Thread.currentThread().getId();
            if (this.deliverThreadId == 0L) {
                this.deliverThreadId = l3;
            } else if (this.deliverThreadId != l3) {
                throw new RuntimeException("Invalid to call deliver from two different threads!");
            }
        }
        Message message = null;
        if (messageListener == null) {
            throw new RuntimeException("DirectConsumer:MessageListener not set!");
        }
        if (jMSPacket == null) {
            throw new RuntimeException("DirectConsumer:JMSPacket is null!");
        }
        try {
            message = DirectPacket.constructMessage(jMSPacket, l, this, this.jmsservice, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message == null) {
            throw new RuntimeException("DirectConsumer:JMS Message in Packet is null!");
        }
        try {
            this.inDeliver = true;
            messageListener.onMessage(message);
            this.inDeliver = false;
            sysMessageID = ((DirectPacket)message).getReceivedSysMessageID();
            if (this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                l2 = this._getTransactionId();
                directAck = new DirectAck(this.connectionId, this.sessionId, l, sysMessageID, l2, JMSService.MessageAckType.ACKNOWLEDGE);
            } else if (!this._isMDBSession()) {
                this.unackedMessageIDs.add(sysMessageID);
                this.unackedConsumerIDs.add(l);
            }
        }
        catch (Exception exception) {
            System.out.println("DirectConsumer:Caught Exception delivering message" + exception.getMessage());
        }
        return directAck;
    }

    protected synchronized Message _fetchMessage(long l, long l2, String string) throws JMSException {
        JMSPacket jMSPacket = null;
        Message message = null;
        SysMessageID sysMessageID = null;
        long l3 = 0L;
        l3 = this.dc.isManaged() && this.dc.isEnlisted() ? this.dc._getXAResource()._getTransactionId() : this._getTransactionId();
        try {
            jMSPacket = this.jmsservice.fetchMessage(this.connectionId, this.sessionId, l, l2, this.ackOnFetch, l3);
        }
        catch (JMSServiceException jMSServiceException) {
            // empty catch block
        }
        if (jMSPacket == null) {
            return null;
        }
        try {
            message = DirectPacket.constructMessage(jMSPacket, l, this, this.jmsservice, false);
            if (this.ackMode == JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                sysMessageID = ((DirectPacket)message).getReceivedSysMessageID();
                this.unackedMessageIDs.add(sysMessageID);
                this.unackedConsumerIDs.add(l);
            }
            return message;
        }
        catch (Exception exception) {
            String string2 = "MQJMSRA_DS4001: receive:Exception constructing message:" + exception.getMessage();
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)exception);
            _loggerJS.warning(string2);
            throw jMSException;
        }
    }

    protected void _acknowledgeThisMessage(DirectPacket directPacket, long l, JMSService.MessageAckType messageAckType) throws JMSException {
        Object object;
        long l2 = 0L;
        if (this.dc.isManaged()) {
            object = this.dc._getXAResource();
            if (object != null && ((DirectXAResource)object).isEnlisted()) {
                l2 = ((DirectXAResource)object)._getTransactionId();
            }
        } else {
            l2 = this.transactionId;
        }
        this._acknowledgeMessage(directPacket, l, l2, messageAckType);
        object = directPacket.getReceivedSysMessageID();
        int n = this.unackedMessageIDs.indexOf(object);
        this.unackedMessageIDs.remove(n);
        this.unackedConsumerIDs.remove(n);
    }

    protected void _acknowledgeThisMessageForMDB(DirectPacket directPacket, long l, JMSService.MessageAckType messageAckType, DirectXAResource directXAResource) throws JMSException {
        long l2 = 0L;
        if (directXAResource != null && directXAResource.isEnlisted()) {
            l2 = directXAResource._getTransactionId();
        }
        this._acknowledgeMessage(directPacket, l, l2, messageAckType);
    }

    protected void _acknowledgeMessage(DirectPacket directPacket, long l, long l2, JMSService.MessageAckType messageAckType) throws JMSException {
        try {
            JMSServiceReply jMSServiceReply = this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, l, directPacket.getReceivedSysMessageID(), l2, messageAckType);
        }
        catch (JMSServiceException jMSServiceException) {
            String string;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case NOT_FOUND: {
                    string = "message not found and cannot be acknowledged";
                    break;
                }
                default: {
                    string = "unkown JMSService server error.";
                }
            }
            String string2 = "acknowledgeMessage on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " and consumerId:" + l + " due to " + string;
            _loggerJS.severe(string2);
            JMSException jMSException = new JMSException(string2);
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
    }

    protected void _setMDBSession(boolean bl) {
        this.isMDBSession = bl;
    }

    protected boolean _isMDBSession() {
        return this.isMDBSession;
    }

    static {
        _logFINE = false;
        Level level = _loggerJS.getLevel();
        if (level != null && (_logLevel = level.intValue()) <= Level.FINE.intValue()) {
            _logFINE = true;
        }
    }
}

