/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunnerPool;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;

public class OnMessageRunner
implements Work {
    protected int omrId;
    private Message message;
    private Thread omrThread;
    private OnMessageRunnerPool omrPool;
    MessageImpl mqmsg;
    SessionImpl mqsess;
    private DirectPacket dpMsg = null;
    private DirectSession ds = null;
    private MessageEndpoint msgEndpoint = null;
    private MessageEndpointFactory epFactory;
    private EndpointConsumer epConsumer;
    private ActivationSpec spec = null;
    private XAResourceForRA xar = null;
    private DirectXAResource dxar = null;
    private Object xarSyncObj = null;
    private Method onMessage = null;
    private boolean transactedDelivery = false;
    private boolean endpointValid = false;
    private boolean useDirect = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.OnMessageRunner";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_MR";
    protected static final transient String _lgrMID_EET = "MQJMSRA_MR1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_MR1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_MR2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_MR3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_MR4001: ";

    public OnMessageRunner(int n, OnMessageRunnerPool onMessageRunnerPool, MessageEndpointFactory messageEndpointFactory, EndpointConsumer endpointConsumer, ActivationSpec activationSpec, boolean bl) {
        Object[] objectArray = new Object[]{onMessageRunnerPool, messageEndpointFactory, endpointConsumer, activationSpec, new Boolean(bl)};
        _loggerIM.entering(_className, "constructor()", objectArray);
        this.omrId = n;
        this.omrPool = onMessageRunnerPool;
        this.epFactory = messageEndpointFactory;
        this.epConsumer = endpointConsumer;
        this.spec = activationSpec;
        this.useDirect = bl;
        if (bl) {
            this.dxar = new DirectXAResource(endpointConsumer.getDirectSession().dc, endpointConsumer.getDirectSession().jmsservice, endpointConsumer.getDirectSession().connectionId);
            this.dxar._setUsedByMDB(true);
        } else {
            while (this.xar == null) {
                try {
                    this.xar = new XAResourceForRA(this, endpointConsumer.ra.xac, endpointConsumer.xac);
                    break;
                }
                catch (JMSException jMSException) {
                    System.err.println("MQRA:OMR:Exception on XAResource creation-" + jMSException.getMessage());
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.xarSyncObj = bl ? this.dxar : this.xar;
        this.onMessage = endpointConsumer.ra._getOnMessageMethod();
        try {
            this.transactedDelivery = messageEndpointFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (int i = 1; i < 6; ++i) {
            try {
                if (endpointConsumer.deactivated) continue;
                this.msgEndpoint = messageEndpointFactory.createEndpoint(bl ? this.dxar : this.xar);
                break;
            }
            catch (UnavailableException unavailableException) {
                try {
                    System.err.println("MQRA:OMR:createEndpoint-UnavailableException:Sleeping for:" + i * 200);
                    Thread.sleep(i * 200);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.msgEndpoint == null) {
            System.err.println("MQRA:OMR:Endpoint Unavailable:Marking OMR as invalid-omrId=" + n + " for:" + activationSpec.toString());
            return;
        }
        this.endpointValid = true;
    }

    public void release() {
    }

    public void releaseEndpoint() {
        if (this.msgEndpoint != null) {
            this.msgEndpoint.release();
        }
    }

    public void invalidate() {
        this.endpointValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.xarSyncObj;
        synchronized (object) {
            boolean bl = this.spec.getSendUndeliverableMsgsToDMQ();
            if (!this.endpointValid) {
                System.err.println("MQRA:OMR:run:msgEP invalid-Ack Undeliverable & remove OMR fr pool-omrId=" + this.omrId + ":msg=" + this.mqmsg.toString());
                this.omrPool.removeOnMessageRunner(this);
                try {
                    if (!this.useDirect) {
                        this.mqsess.acknowledgeUndeliverableFromRAEndpoint(this.mqmsg, this.xar, bl);
                    }
                }
                catch (JMSException jMSException) {
                    System.err.println("MQRA:OMR:run:msgEP invalid:JMSException on Ack Undeliverable-" + jMSException.getMessage());
                    jMSException.printStackTrace();
                }
                return;
            }
            ClassLoader classLoader = this.spec.getContextClassLoader();
            int n = this.spec.getEndpointExceptionRedeliveryAttempts();
            int n2 = this.spec.getEndpointExceptionRedeliveryInterval();
            boolean bl2 = true;
            while (bl2) {
                try {
                    block32: {
                        if (this.transactedDelivery) {
                            this.msgEndpoint.beforeDelivery(this.onMessage);
                        }
                        try {
                            if (classLoader != null) {
                                try {
                                    Thread.currentThread().setContextClassLoader(classLoader);
                                }
                                catch (Exception exception) {
                                    System.err.println("MQRA:ML:run:Exception setting ContextClassLoader:" + exception.getMessage());
                                }
                            }
                            ((MessageListener)this.msgEndpoint).onMessage(this.message);
                            bl2 = false;
                            try {
                                if (this.useDirect) {
                                    this.dpMsg._acknowledgeThisMessageForMDB(this.dxar);
                                    this.dxar.setRollback(false, null);
                                    break block32;
                                }
                                this.mqsess.acknowledgeFromRAEndpoint(this.mqmsg, this.xar);
                                this.xar.setRollback(false, null);
                            }
                            catch (JMSException jMSException) {
                                System.err.println("MQRA:OMR:run:JMSException on message acknowledgement:Rolling back if in txn");
                                if (this.useDirect) {
                                    this.dxar.setRollback(true, jMSException);
                                } else {
                                    this.xar.setRollback(true, (Exception)((Object)jMSException));
                                }
                                jMSException.printStackTrace();
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("MQRA:OMR:run:Caught Exception from onMessage():Redelivering:" + exception.getMessage());
                            try {
                                this.message.setJMSRedelivered(true);
                            }
                            catch (Exception exception2) {
                                System.err.println("MQRA:OMR:run:Exception on setJMSRedelivered():" + exception2.getMessage());
                                exception2.printStackTrace();
                            }
                            if (n > 0) {
                                try {
                                    Thread.sleep(n2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                --n;
                            }
                            System.err.println("MQRA:OMR:run:Exhausted redeliveryAttempts-msg=" + this.message.toString());
                            System.err.println("MQRA:OMR:run:Exhausted redeliveryAttempts-spec=" + this.spec.toString());
                            if (bl) {
                                System.err.println("MQRA:OMR:run:Message returned & marked for routing to the DMQ");
                            } else {
                                System.err.println("MQRA:OMR:run:Message returned & marked for redelivery by the broker");
                            }
                            try {
                                if (this.useDirect) {
                                    this.dpMsg._acknowledgeThisMessageAsDeadForMDB(this.dxar);
                                    System.err.println("MQRA:OMR:run:omrId=" + this.omrId + ":Acked Undeliverable-Msg=" + this.dpMsg.toString());
                                } else {
                                    this.mqsess.acknowledgeUndeliverableFromRAEndpoint(this.mqmsg, this.xar, bl);
                                    System.err.println("MQRA:OMR:run:omrId=" + this.omrId + ":Acked Undeliverable-Msg=" + this.mqmsg.toString());
                                }
                            }
                            catch (JMSException jMSException) {
                                System.err.println("MQRA:OMR:run:JMSException on Acked Undeliverable-" + jMSException.getMessage());
                                jMSException.printStackTrace();
                            }
                            bl2 = false;
                        }
                    }
                    if (!this.transactedDelivery) continue;
                    this.msgEndpoint.afterDelivery();
                }
                catch (Throwable throwable) {
                    System.err.println("MQRA:OMR:run:onMessage caught Throwable-before/on/afterDelivery:Class=" + throwable.getClass().getName() + "Msg=" + throwable.getMessage());
                    bl2 = false;
                    throwable.printStackTrace();
                }
            }
            this.message = null;
            this.omrPool.putOnMessageRunner(this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof OnMessageRunner) {
            return this.omrId == ((OnMessageRunner)object).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.omrId;
    }

    public void onMessage(Message message) {
        if (this.useDirect) {
            this.message = message;
            this.dpMsg = (DirectPacket)this.message;
            this.ds = this.epConsumer.getDirectSession();
            try {
                this.epConsumer.ra.workMgr.scheduleWork((Work)this);
            }
            catch (WorkException workException) {
                System.err.println("MQRA:OMR:onMessage:WorkException-" + workException.getMessage() + " on omrId=" + this.omrId);
                workException.printStackTrace();
            }
        } else {
            this.message = message;
            this.mqmsg = (MessageImpl)this.message;
            this.mqsess = (SessionImpl)this.epConsumer.getXASession();
            this.mqmsg._setConsumerInRA();
            try {
                this.epConsumer.ra.workMgr.startWork((Work)this);
            }
            catch (WorkException workException) {
                System.err.println("MQRA:OMR:onMessage:WorkException-" + workException.getMessage() + " on omrId=" + this.omrId);
                workException.printStackTrace();
            }
        }
    }

    public int getId() {
        return this.omrId;
    }

    public boolean isValid() {
        return this.endpointValid;
    }

    public EndpointConsumer getEndpointConsumer() {
        return this.epConsumer;
    }
}

