/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jms.ra.DirectConnection;
import java.util.logging.Logger;
import javax.jms.JMSException;

public abstract class TemporaryDestination
extends Destination {
    private static final transient String _className = "com.sun.messaging.jms.ra.TemporaryDestination";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSConnection = "javax.jms.Connection.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJC = Logger.getLogger("javax.jms.Connection.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_TD";
    private static final transient String _lgrMID_EET = "MQJMSRA_TD1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_TD1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_TD2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_TD3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_TD4001: ";
    private DirectConnection dc = null;
    private com.sun.messaging.jmq.jmsservice.Destination destination = null;
    private boolean deleted = false;
    private int consumer_count = 0;

    protected TemporaryDestination(DirectConnection directConnection, Destination.Type type, Destination.TemporaryType temporaryType) throws JMSException {
        super("temporary_destination://" + (Object)((Object)temporaryType) + "/" + directConnection._getConnectionIdentifierForTemporaryDestination() + "/" + directConnection.nextTemporaryDestinationId());
        String string = super.getName();
        this.dc = directConnection;
        this.destination = new com.sun.messaging.jmq.jmsservice.Destination(string, type, Destination.Life.TEMPORARY);
    }

    protected TemporaryDestination(String string, Destination.Type type) throws JMSException {
        super(string);
        this.destination = new com.sun.messaging.jmq.jmsservice.Destination(string, type, Destination.Life.TEMPORARY);
    }

    public void delete() throws JMSException {
        this._delete();
        this.dc.removeTemporaryDestination(this);
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean _isDeleted() {
        return this.deleted;
    }

    protected com.sun.messaging.jmq.jmsservice.Destination _getDestination() {
        return this.destination;
    }

    protected void _delete() throws JMSException {
        if (this.dc == null) {
            String string = "MQJMSRA_TD4001: delete():Can only delete user created TemporaryDestinations";
            _loggerJC.warning(string);
            throw new JMSException(string);
        }
        if (this.dc._hasConsumers(this)) {
            String string = "MQJMSRA_TD4001: delete():Cannot delete TemporaryDestination with active consumers";
            _loggerJC.warning(string);
            throw new JMSException(string);
        }
        this.dc._deleteDestination(this, this.destination);
        this.deleted = true;
    }

    protected int _incrementConsumerCount() {
        return ++this.consumer_count;
    }

    protected int _decrementConsumerCount() {
        --this.consumer_count;
        assert (this.consumer_count >= 0);
        return this.consumer_count;
    }

    protected int _getConsumerCount() {
        return this.consumer_count;
    }
}

