/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.AnnotationScanner;
import com.sun.enterprise.deployment.annotation.introspection.AppClientPersistenceDependencyAnnotationScanner;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.loader.ASURLClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.AppClientInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.xml.sax.SAXParseException;

@Service
public class StandAloneAppClientInfo
extends AppClientInfo
implements PostConstruct {
    @Inject
    protected ArchivistFactory archivistFactory;
    private ReadableArchive appClientArchive;
    private AppClientArchivist appClientArchivist;

    public StandAloneAppClientInfo(boolean isJWS, Logger logger, ReadableArchive archive, String mainClassFromCommandLine) throws IOException, ClassNotFoundException, URISyntaxException, SAXParseException {
        super(isJWS, logger, mainClassFromCommandLine);
        this.appClientArchive = archive;
    }

    public void postConstruct() {
        try {
            Archivist archivist = this.archivistFactory.getArchivist(this.appClientArchive, this.getClassLoader());
            if (!(archivist instanceof AppClientArchivist)) {
                throw new IllegalArgumentException("expected an app client module but " + this.appClientArchive.getURI().toASCIIString() + " was recognized by " + archivist.getClass().getName());
            }
            this.appClientArchivist = (AppClientArchivist)archivist;
            this.setDescriptor((ApplicationClientDescriptor)this.appClientArchivist.getDescriptor());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void completeInit() throws Exception {
        this.populateDescriptor(this.appClientArchive, (Archivist)this.appClientArchivist, this.getClassLoader());
        if (this.appClientDependsOnPersistenceUnit(this.getAppClient())) {
            this.handlePersistenceUnitDependency();
        }
        this.appClientArchivist.validate(this.getClassLoader());
        this.fixupWSDLEntries();
    }

    protected void fixupWSDLEntries() throws URISyntaxException, MalformedURLException, IOException, AnnotationProcessorException {
        ApplicationClientDescriptor ac = this.getAppClient();
        URI uri = new File(this.getAppClientRoot(this.appClientArchive, ac)).toURI();
        File moduleFile = new File(uri);
        for (ServiceReferenceDescriptor serviceRef : ac.getServiceReferenceDescriptors()) {
            if (serviceRef.getWsdlFileUri() == null) continue;
            String wsdlURI = serviceRef.getWsdlFileUri();
            File wsdlFile = new File(wsdlURI);
            if (wsdlFile.isAbsolute()) {
                serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                continue;
            }
            serviceRef.setWsdlFileUrl(StandAloneAppClientInfo.getEntryAsUrl(moduleFile, serviceRef.getWsdlFileUri()));
        }
    }

    protected boolean appClientDependsOnPersistenceUnit(ApplicationClientDescriptor acDescr) throws MalformedURLException, ClassNotFoundException, IOException, URISyntaxException {
        return this.descriptorContainsPURefcs(acDescr) || this.mainClassContainsPURefcAnnotations(acDescr);
    }

    protected boolean mainClassContainsPURefcAnnotations(ApplicationClientDescriptor acDescr) throws MalformedURLException, ClassNotFoundException, IOException, URISyntaxException {
        AnnotationDetector annoDetector = new AnnotationDetector((AnnotationScanner)new AppClientPersistenceDependencyAnnotationScanner());
        String mainClassEntryName = acDescr.getMainClassName().replace('.', '/') + ".class";
        return this.classContainsAnnotation(mainClassEntryName, annoDetector, this.appClientArchive, acDescr);
    }

    private RootDeploymentDescriptor populateDescriptor(ReadableArchive archive, Archivist theArchivist, ClassLoader loader) throws IOException, SAXParseException, Exception {
        theArchivist.setAnnotationProcessingRequested(true);
        theArchivist.setClassLoader(loader);
        RootDeploymentDescriptor d = null;
        try {
            d = theArchivist.open(archive);
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
        this.massageDescriptor();
        theArchivist.setDescriptor(d);
        return d;
    }

    protected void massageDescriptor() throws IOException, AnnotationProcessorException {
        this.getDescriptor().getModuleDescriptor().setStandalone(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        try {
            ClassLoader classLoader;
            if (this.appClientArchive != null) {
                this.appClientArchive.close();
            }
            if ((classLoader = this.getClassLoader()) != null && classLoader instanceof ASURLClassLoader) {
                ((ASURLClassLoader)classLoader).done();
            }
        }
        finally {
            if (this.deleteAppClientDir() && this.appClientArchive != null) {
                this.appClientArchive.delete();
            }
            this.appClientArchive = null;
        }
    }

    protected boolean classContainsAnnotation(String entry, AnnotationDetector detector, ReadableArchive archive, ApplicationClientDescriptor descriptor) throws FileNotFoundException, IOException {
        try {
            boolean bl = detector.containsAnnotation(archive, entry);
            return bl;
        }
        catch (Throwable thr) {
            throw new RuntimeException(this.getLocalString("appclient.errorCheckingAnnos", "Error checking for persistence unit annotations in the main class", new Object[0]), thr);
        }
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + ": " + lineSep);
        result.append("  isJWS: " + this.isJWS);
        result.append("  archive file: " + this.appClientArchive.getURI().toASCIIString() + lineSep);
        result.append("  archive type: " + this.appClientArchive.getClass().getName() + lineSep);
        result.append("  archivist type: " + this.appClientArchivist.getClass().getName() + lineSep);
        result.append("  main class to be run: " + this.mainClassNameToRun + lineSep);
        result.append("  temporary archive directory: " + this.appClientArchive.getURI() + lineSep);
        result.append("  class loader type: " + this.getClassLoader().getClass().getName() + lineSep);
        return result.toString();
    }
}

