/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.common;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;

public class Util {
    private static Pattern placeholderPattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static final String CLASS_SUFFIX = ".class";
    private static final int BUFFER_SIZE = 1024;

    public static String replaceTokens(String s, Properties values) {
        Matcher m = placeholderPattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = values.getProperty(propertyName);
            if (propertyValue == null) continue;
            String adjustedPropertyValue = propertyValue.replaceAll("\\$", "\\\\\\$");
            String x = s.substring(m.start(), m.end());
            try {
                m.appendReplacement(sb, adjustedPropertyValue);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("**** appendReplacement failed: segment is " + x + "; original replacement was " + propertyValue + " and adj. replacement is " + adjustedPropertyValue + "; exc follows");
                throw iae;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String getMainClassNameForAppClient(ModuleDescriptor moduleDescr) throws IOException, FileNotFoundException, SAXParseException {
        RootDeploymentDescriptor bd = moduleDescr.getDescriptor();
        ApplicationClientDescriptor acDescr = (ApplicationClientDescriptor)bd;
        String mainClassName = acDescr.getMainClassName();
        return mainClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeTextToTempFile(String content, String prefix, String suffix, boolean retainFile) throws IOException, FileNotFoundException {
        BufferedWriter wtr = null;
        try {
            File result = File.createTempFile(prefix, suffix);
            if (!retainFile) {
                result.deleteOnExit();
            }
            FileOutputStream fos = new FileOutputStream(result);
            wtr = new BufferedWriter(new OutputStreamWriter(fos));
            wtr.write(content);
            wtr.close();
            File file = result;
            return file;
        }
        finally {
            if (wtr != null) {
                wtr.close();
            }
        }
    }

    public static File writeTextToTempFile(String content, String prefix, String suffix) throws IOException, FileNotFoundException {
        return Util.writeTextToTempFile(content, prefix, suffix, false);
    }

    public static URL locateClass(Class target) {
        return target.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String loadResource(Class contextClass, String resourcePath) throws IOException {
        String result = null;
        InputStream is = null;
        try {
            int charsRead;
            is = contextClass.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Could not locate the requested resource relative to class " + contextClass.getName());
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            char[] buffer = new char[1024];
            while ((charsRead = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
            String string = result = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            IOException wrapperIOE = new IOException("Error loading resource " + resourcePath);
            wrapperIOE.initCause(ioe);
            throw wrapperIOE;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyToTempFile(File inputFile, String prefix, String suffix, boolean retainFile) throws IOException, FileNotFoundException {
        File result = null;
        BufferedInputStream is = null;
        FilterOutputStream os = null;
        try {
            result = File.createTempFile(prefix, suffix);
            if (!retainFile) {
                result.deleteOnExit();
            }
            os = new BufferedOutputStream(new FileOutputStream(result));
            is = new BufferedInputStream(new FileInputStream(inputFile));
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer)) != -1) {
                ((BufferedOutputStream)os).write(buffer, 0, bytesRead);
            }
            File file = result;
            return file;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static String URLtoCodeBase(URL classPathElement) throws FileNotFoundException, URISyntaxException {
        File file = new File(classPathElement.toURI());
        if (!file.exists()) {
            return null;
        }
        String result = file.isDirectory() ? classPathElement.getProtocol() + ":" + classPathElement.toURI().getPath() + "-" : classPathElement.getProtocol() + ":" + classPathElement.toURI().getPath();
        return result;
    }
}

