/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.RbCbSelector;
import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.renderkit.html.RowColumnRenderer;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

abstract class SelectorGroupRenderer
extends RowColumnRenderer {
    protected static final int GRP = 0;
    protected static final int GRP_CAPTION = 1;
    protected static final int GRP_LABEL = 2;
    protected static final int GRP_LABEL_DIS = 3;
    protected static final int GRP_ROW_EVEN = 4;
    protected static final int GRP_ROW_ODD = 5;
    protected static final int GRP_CELL_EVEN = 6;
    protected static final int GRP_CELL_ODD = 7;
    protected static final int INPUT = 8;
    protected static final int INPUT_DIS = 9;
    protected static final int LABEL = 10;
    protected static final int LABEL_DIS = 11;
    protected static final int IMAGE = 12;
    protected static final int IMAGE_DIS = 13;
    protected static final int LABEL_LVL1 = 14;
    protected static final int LABEL_LVL2 = 15;
    protected static final int LABEL_LVL3 = 16;
    protected static final int LABEL_LVL_DEF = 0;
    private static final int LABEL_LVL = 13;
    private int[] rowcolstyle = new int[]{0, 1, 4, 5, 6, 7};

    protected abstract String[] getStyles();

    protected abstract UIComponent getSelectorComponent(FacesContext var1, UIComponent var2, Theme var3, String var4, Option var5);

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        this.setSubmittedValues(context, component);
    }

    private void setSubmittedValues(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap();
        if (requestParameterValuesMap.containsKey(clientId)) {
            String[] newValues = (String[])requestParameterValuesMap.get(clientId);
            ((UIInput)component).setSubmittedValue((Object)newValues);
            return;
        }
        ((UIInput)component).setSubmittedValue((Object)new String[0]);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected void renderSelectorGroup(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int columns) throws IOException {
        Option[] items;
        Selector selector = (Selector)component;
        Object selected = selector.getSelected();
        if (selector.getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, selected);
        }
        if ((items = this.getItems((Selector)component)) == null) {
            return;
        }
        int length = items.length;
        if (length == 0) {
            return;
        }
        columns = columns <= 0 ? 1 : (columns > length ? length : columns);
        int rows = (length + (columns - 1)) / columns;
        this.renderRowColumnLayout(context, component, theme, writer, rows, columns);
    }

    protected Option[] getItems(Selector selector) {
        Object items = selector.getItems();
        if (items == null) {
            return null;
        }
        if (items instanceof Option[]) {
            return (Option[])items;
        }
        if (items instanceof Map) {
            int size = ((Map)items).size();
            return ((Map)items).values().toArray(new Option[size]);
        }
        if (items instanceof Collection) {
            int size = ((Collection)items).size();
            return ((Collection)items).toArray(new Option[size]);
        }
        throw new IllegalArgumentException("Selector.items is not Option[], Map, or Collection");
    }

    protected void renderCellContent(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int itemN) throws IOException {
        Option[] items = this.getItems((Selector)component);
        if (itemN >= items.length) {
            this.renderEmptyCell(context, component, theme, writer);
            return;
        }
        String id = component.getId().concat("_") + itemN;
        UIComponent content = this.getSelectorComponent(context, component, theme, id, items[itemN]);
        RenderingUtilities.renderComponent(content, context);
    }

    protected void renderCaption(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent captionComponent = this.getCaptionComponent(context, component, theme, component.getId().concat("_caption"));
        if (captionComponent != null) {
            RenderingUtilities.renderComponent(captionComponent, context);
        }
    }

    private UIComponent getCaptionComponent(FacesContext context, UIComponent component, Theme theme, String captionId) throws IOException {
        String captionStyle;
        Integer lblLvl;
        UIComponent labelComponent = component.getFacet("label");
        if (labelComponent != null) {
            return labelComponent;
        }
        String attrvalue = (String)component.getAttributes().get("label");
        if (attrvalue == null || attrvalue.length() <= 0) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet(component, "label", true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId(component, "label"));
            ComponentUtilities.putPrivateFacet(component, "label", (UIComponent)label);
        }
        label.setText(attrvalue);
        label.setFor(component.getClientId(context));
        attrvalue = (String)component.getAttributes().get("toolTip");
        if (attrvalue != null) {
            label.setToolTip(attrvalue);
        }
        if ((lblLvl = (Integer)component.getAttributes().get("labelLevel")) == null) {
            lblLvl = new Integer(2);
        }
        label.setLabelLevel(lblLvl == null ? 2 : lblLvl);
        int styleCode = 2;
        Boolean disabled = (Boolean)component.getAttributes().get("disabled");
        if (disabled != null && disabled.booleanValue()) {
            styleCode = 3;
        }
        if ((captionStyle = this.getStyle(theme, styleCode)) != null) {
            label.setStyleClass(captionStyle);
        }
        return label;
    }

    protected void renderEmptyCell(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
    }

    protected final String getRowColumnStyle(Theme theme, int styleCode) {
        return this.getStyle(theme, this.rowcolstyle[styleCode]);
    }

    private String getStyle(Theme theme, int styleCode) {
        String style = null;
        try {
            style = theme.getStyleClass(this.getStyles()[styleCode]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return style;
    }

    protected String getStyle(Theme theme, int styleCode, int styleLevelCode) {
        String style = this.getStyle(theme, styleCode);
        if (style == null) {
            return null;
        }
        StringBuffer styleBuf = new StringBuffer(style);
        String styleLevel = null;
        if (styleLevelCode != 0) {
            styleLevel = this.getStyle(theme, styleLevelCode);
        }
        if (styleLevel != null) {
            if (styleBuf.length() != 0) {
                styleBuf.append(" ");
            }
            styleBuf.append(styleLevel);
        } else {
            style = null;
            switch (styleCode) {
                case 1: {
                    style = this.getStyle(theme, 15);
                    break;
                }
                case 10: {
                    style = this.getStyle(theme, 16);
                }
            }
            if (style != null) {
                if (styleBuf.length() != 0) {
                    styleBuf.append(" ");
                }
                styleBuf.append(style);
            }
        }
        return styleBuf.toString();
    }

    protected void transferEventAttributes(Selector group, RbCbSelector rbcb) {
        Map groupAttributes = group.getAttributes();
        Map rbcbAttributes = rbcb.getAttributes();
        String[] eventAttributeNames = AbstractRenderer.EVENTS_ATTRIBUTES;
        for (int i = 0; i < eventAttributeNames.length; ++i) {
            Object eventAttributeValue = groupAttributes.get(eventAttributeNames[i]);
            if (eventAttributeValue == null) continue;
            rbcbAttributes.put(eventAttributeNames[i], eventAttributeValue);
        }
    }
}

