/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-network-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.network.listener")
public class DeleteNetworkListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteNetworkListener.class);
    @Param(name="networkListenerName", primary=true)
    String networkListenerName;
    NetworkListener listenerToBeRemoved = null;
    @Inject
    Configs configs;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        NetworkListeners networkListeners = networkConfig.getNetworkListeners();
        try {
            for (NetworkListener nl : networkListeners.getNetworkListener()) {
                if (!this.networkListenerName.equalsIgnoreCase(nl.getName())) continue;
                this.listenerToBeRemoved = nl;
            }
            if (this.listenerToBeRemoved == null) {
                report.setMessage(localStrings.getLocalString("delete.network.listener.notexists", "{0} Network Listener doesn't exist", new Object[]{this.networkListenerName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply(new SingleConfigCode<NetworkListeners>(){

                @Override
                public Object run(NetworkListeners param) throws PropertyVetoException, TransactionFailure {
                    param.getNetworkListener().remove(DeleteNetworkListener.this.listenerToBeRemoved);
                    DeleteNetworkListener.this.updateVirtualServer(DeleteNetworkListener.this.listenerToBeRemoved);
                    return DeleteNetworkListener.this.listenerToBeRemoved;
                }
            }, networkListeners);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.networkListener.fail", "Deletion of NetworkListener {0} failed", new Object[]{this.networkListenerName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void updateVirtualServer(final NetworkListener listener) throws TransactionFailure {
        Protocol prot = listener.findHttpProtocol();
        if (prot != null) {
            ConfigSupport.apply(new SingleConfigCode<VirtualServer>(){

                @Override
                public Object run(VirtualServer param) throws PropertyVetoException, TransactionFailure {
                    param.removeNetworkListener(listener.getName());
                    return null;
                }
            }, (ConfigBeanProxy)this.habitat.getComponent(VirtualServer.class, prot.getHttp().getDefaultVirtualServer()));
        }
    }
}

